/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.python.core.JyAttribute;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyJavaType;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.PyType;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.ThreadContext;
import org.python.core.Untraversable;

@Untraversable
public class PyReflectedConstructor
extends PyReflectedFunction {
    public PyReflectedConstructor(String name) {
        super(name);
    }

    public PyReflectedConstructor(Constructor<?> c) {
        this(c.getDeclaringClass().getName());
        this.addConstructor(c);
    }

    private ReflectedArgs makeArgs(Constructor<?> m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), true);
    }

    public void addConstructor(Constructor<?> m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && Options.respectJavaAccessibility) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    PyObject make(PyObject[] args2, String[] keywords) {
        PyObject obj;
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        boolean consumes_keywords = false;
        PyObject[] allArgs = null;
        if (this.nargs > 0) {
            if (this.argslist[0].matches(null, args2, keywords, callData)) {
                method = this.argslist[0].data;
                consumes_keywords = this.argslist[0].flags == 2;
            } else {
                allArgs = args2;
                int i = 1;
                if (keywords.length > 0) {
                    args2 = new PyObject[allArgs.length - keywords.length];
                    System.arraycopy(allArgs, 0, args2, 0, args2.length);
                    i = 0;
                }
                while (i < this.nargs) {
                    if (this.argslist[i].matches(null, args2, Py.NoKeywords, callData)) {
                        method = this.argslist[i].data;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args2.length, true, false);
        }
        try {
            obj = (PyObject)((Constructor)method).newInstance(callData.getArgsArray());
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
        if (!consumes_keywords) {
            int offset = args2.length;
            for (int i = 0; i < keywords.length; ++i) {
                obj.__setattr__(keywords[i], allArgs[i + offset]);
            }
        }
        return obj;
    }

    @Override
    public PyObject __call__(PyObject self, PyObject[] args2, String[] keywords) {
        int i;
        int n;
        Class<?> declaringClass;
        if (self == null) {
            throw Py.TypeError("invalid self argument to constructor");
        }
        Class<?> javaClass = self.getType().getProxyType();
        if (javaClass == null) {
            throw Py.TypeError("self invalid - must be a Java subclass [self=" + self + "]");
        }
        Class<?> clazz = declaringClass = this.argslist[0] == null ? null : this.argslist[0].declaringClass;
        if (!(declaringClass != null && PyProxy.class.isAssignableFrom(declaringClass) || self.getType() instanceof PyJavaType)) {
            return PyType.fromClass(javaClass).lookup("__init__").__call__(self, args2, keywords);
        }
        if (this.nargs == 0) {
            throw Py.TypeError("No visible constructors for class (" + javaClass.getName() + ")");
        }
        if (!declaringClass.isAssignableFrom(javaClass)) {
            throw Py.TypeError("self invalid - must implement: " + declaringClass.getName());
        }
        int mods = declaringClass.getModifiers();
        if (Modifier.isInterface(mods)) {
            throw Py.TypeError("can't instantiate interface (" + declaringClass.getName() + ")");
        }
        if (Modifier.isAbstract(mods)) {
            throw Py.TypeError("can't instantiate abstract class (" + declaringClass.getName() + ")");
        }
        if (JyAttribute.hasAttr(self, (byte)-128)) {
            Class<?> sup = javaClass;
            if (PyProxy.class.isAssignableFrom(sup)) {
                sup = sup.getSuperclass();
            }
            throw Py.TypeError("instance already instantiated for " + sup.getName());
        }
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        int nkeywords = keywords.length;
        ReflectedArgs rargs = null;
        PyObject[] allArgs = args2;
        boolean usingKeywordArgsCtor = false;
        if (nkeywords > 0) {
            n = this.nargs;
            for (i = 0; i < n; ++i) {
                rargs = this.argslist[i];
                if (!rargs.matches(null, args2, keywords, callData)) continue;
                method = rargs.data;
                break;
            }
            if (method != null) {
                usingKeywordArgsCtor = true;
            } else {
                args2 = new PyObject[allArgs.length - nkeywords];
                System.arraycopy(allArgs, 0, args2, 0, args2.length);
                for (i = 0; i < n; ++i) {
                    rargs = this.argslist[i];
                    if (!rargs.matches(null, args2, Py.NoKeywords, callData)) continue;
                    method = rargs.data;
                    break;
                }
            }
        } else {
            n = this.nargs;
            for (i = 0; i < n; ++i) {
                rargs = this.argslist[i];
                if (!rargs.matches(null, args2, Py.NoKeywords, callData)) continue;
                method = rargs.data;
                break;
            }
        }
        if (method == null) {
            this.throwError(callData.errArg, args2.length, false, false);
        }
        this.constructProxy(self, (Constructor)method, callData.getArgsArray(), javaClass);
        if (!usingKeywordArgsCtor) {
            int offset = args2.length;
            for (i = 0; i < nkeywords; ++i) {
                self.__setattr__(keywords[i], allArgs[i + offset]);
            }
        }
        return Py.None;
    }

    @Override
    public PyObject __call__(PyObject[] args2, String[] keywords) {
        if (args2.length < 1) {
            throw Py.TypeError("constructor requires self argument");
        }
        PyObject[] newArgs = new PyObject[args2.length - 1];
        System.arraycopy(args2, 1, newArgs, 0, newArgs.length);
        return this.__call__(args2[0], newArgs, keywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void constructProxy(PyObject obj, Constructor<?> ctor, Object[] args2, Class<?> proxy) {
        Object jself = null;
        Object[] previous = ThreadContext.initializingProxy.get();
        ThreadContext.initializingProxy.set(new Object[]{obj});
        try {
            try {
                jself = ctor.newInstance(args2);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InstantiationException) {
                    Class<?> sup = proxy.getSuperclass();
                    String msg = "Constructor failed for Java superclass";
                    if (sup != null) {
                        msg = msg + " " + sup.getName();
                    }
                    throw Py.TypeError(msg);
                }
                throw Py.JavaError(e);
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
        }
        finally {
            ThreadContext.initializingProxy.set(previous);
        }
        JyAttribute.setAttr(obj, (byte)-128, jself);
    }

    @Override
    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this;
        }
        return new PyMethod(this, container, wherefound);
    }

    @Override
    public String toString() {
        return "<java constructor " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

