/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyMethod$PyExposer;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="instancemethod", isBaseType=false, doc="instancemethod(function, instance, class)\n\nCreate an instance method object.")
public class PyMethod
extends PyObject
implements InvocationHandler,
Traverseproc {
    public static final PyType TYPE;
    public PyObject im_class;
    public PyObject __func__;
    public PyObject __self__;

    @Deprecated
    public PyObject getFunc() {
        return this.__func__;
    }

    @Deprecated
    public PyObject getSelf() {
        return this.__self__;
    }

    public PyMethod(PyObject function, PyObject self, PyObject type) {
        super(TYPE);
        if (self == Py.None) {
            self = null;
        }
        this.__func__ = function;
        this.__self__ = self;
        this.im_class = type;
    }

    @ExposedNew
    static final PyObject instancemethod___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args2, String[] keywords) {
        ArgParser ap = new ArgParser("instancemethod", args2, keywords, "func");
        ap.noKeywords();
        PyObject func = ap.getPyObject(0);
        PyObject self = ap.getPyObject(1);
        PyObject classObj = ap.getPyObject(2, null);
        if (!func.isCallable()) {
            throw Py.TypeError("first argument must be callable");
        }
        if (self == Py.None && classObj == null) {
            throw Py.TypeError("unbound methods must have non-NULL im_class");
        }
        return new PyMethod(func, self, classObj);
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        return this.instancemethod___findattr_ex__(name);
    }

    final PyObject instancemethod___findattr_ex__(String name) {
        PyObject ret = super.__findattr_ex__(name);
        if (ret != null) {
            return ret;
        }
        return this.__func__.__findattr_ex__(name);
    }

    final PyObject instancemethod___getattribute__(PyObject arg0) {
        String name = PyMethod.asName(arg0);
        PyObject ret = this.instancemethod___findattr_ex__(name);
        if (ret == null) {
            this.noAttributeError(name);
        }
        return ret;
    }

    @Override
    public PyObject __get__(PyObject obj, PyObject type) {
        return this.instancemethod___get__(obj, type);
    }

    final PyObject instancemethod___get__(PyObject obj, PyObject type) {
        if (obj == null || this.__self__ != null) {
            return this;
        }
        if (Py.isSubClass(obj.fastGetClass(), this.im_class)) {
            return new PyMethod(this.__func__, obj, this.im_class);
        }
        return this;
    }

    @Override
    public PyObject __call__() {
        return this.__call__(Py.getThreadState());
    }

    @Override
    public PyObject __call__(ThreadState state) {
        PyObject self = this.checkSelf(null, null);
        if (self == null) {
            return this.__func__.__call__(state);
        }
        return this.__func__.__call__(state, self);
    }

    @Override
    public PyObject __call__(PyObject arg0) {
        return this.__call__(Py.getThreadState(), arg0);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.__func__.__call__(state, arg0);
        }
        return this.__func__.__call__(state, self, arg0);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1) {
        return this.__call__(Py.getThreadState(), arg0, arg1);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.__func__.__call__(state, arg0, arg1);
        }
        return this.__func__.__call__(state, self, arg0, arg1);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2) {
        return this.__call__(Py.getThreadState(), arg0, arg1, arg2);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.__func__.__call__(state, arg0, arg1, arg2);
        }
        return this.__func__.__call__(state, self, arg0, arg1, arg2);
    }

    @Override
    public PyObject __call__(PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        return this.__call__(Py.getThreadState(), arg0, arg1, arg2, arg3);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg0, PyObject arg1, PyObject arg2, PyObject arg3) {
        PyObject self = this.checkSelf(arg0, null);
        if (self == null) {
            return this.__func__.__call__(state, arg0, arg1, arg2, arg3);
        }
        return this.__func__.__call__(state, self, new PyObject[]{arg0, arg1, arg2, arg3}, Py.NoKeywords);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject[] args2, String[] keywords) {
        return this.__call__(Py.getThreadState(), arg1, args2, keywords);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject arg1, PyObject[] args2, String[] keywords) {
        PyObject self = this.checkSelf(arg1, args2);
        if (self == null) {
            return this.__func__.__call__(state, arg1, args2, keywords);
        }
        PyObject[] newArgs = new PyObject[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 1, args2.length);
        newArgs[0] = arg1;
        return this.__func__.__call__(state, self, newArgs, keywords);
    }

    @Override
    public PyObject __call__(PyObject[] args2) {
        return this.__call__(Py.getThreadState(), args2);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject[] args2) {
        return this.__call__(state, args2, Py.NoKeywords);
    }

    @Override
    public PyObject __call__(PyObject[] args2, String[] keywords) {
        return this.__call__(Py.getThreadState(), args2, keywords);
    }

    @Override
    public PyObject __call__(ThreadState state, PyObject[] args2, String[] keywords) {
        return this.instancemethod___call__(state, args2, keywords);
    }

    final PyObject instancemethod___call__(ThreadState state, PyObject[] args2, String[] keywords) {
        PyObject self = this.checkSelf(null, args2);
        if (self == null) {
            return this.__func__.__call__(state, args2, keywords);
        }
        return this.__func__.__call__(state, self, args2, keywords);
    }

    private PyObject checkSelf(PyObject arg, PyObject[] args2) {
        PyObject self = this.__self__;
        if (self == null) {
            if (arg != null) {
                self = arg;
            } else if (args2 != null && args2.length >= 1) {
                self = args2[0];
            }
            boolean ok = self == null ? false : Py.isInstance(self, this.im_class);
            if (!ok) {
                String msg = String.format("unbound method %s%s must be called with %s instance as first argument (got %s%s instead)", this.getFuncName(), "()", this.getClassName(this.im_class), this.getInstClassName(self), self == null ? "" : " instance");
                throw Py.TypeError(msg);
            }
            return null;
        }
        return self;
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.instancemethod___cmp__(other);
    }

    final int instancemethod___cmp__(PyObject other) {
        if (!(other instanceof PyMethod)) {
            return -2;
        }
        PyMethod otherMethod = (PyMethod)other;
        int cmp = this.__func__._cmp(otherMethod.__func__);
        if (cmp != 0) {
            return cmp;
        }
        if (this.__self__ == otherMethod.__self__) {
            return 0;
        }
        if (this.__self__ == null || otherMethod.__self__ == null) {
            return System.identityHashCode(this.__self__) < System.identityHashCode(otherMethod.__self__) ? -1 : 1;
        }
        return this.__self__._cmp(otherMethod.__self__);
    }

    @Override
    public int hashCode() {
        int hashCode = this.__self__ == null ? Py.None.hashCode() : this.__self__.hashCode();
        return hashCode ^ this.__func__.hashCode();
    }

    public PyObject getDoc() {
        return this.__func__.__getattr__("__doc__");
    }

    @Override
    public String toString() {
        String className = "?";
        if (this.im_class != null) {
            className = this.getClassName(this.im_class);
        }
        if (this.__self__ == null) {
            return String.format("<unbound method %s.%s>", className, this.getFuncName());
        }
        return String.format("<bound method %s.%s of %s>", className, this.getFuncName(), this.__self__.__str__());
    }

    private String getClassName(PyObject cls) {
        if (cls instanceof PyClass) {
            return ((PyClass)cls).__name__;
        }
        if (cls instanceof PyType) {
            return ((PyType)cls).fastGetName();
        }
        return "?";
    }

    private String getInstClassName(PyObject inst) {
        if (inst == null) {
            return "nothing";
        }
        PyObject classObj = inst.__findattr__("__class__");
        if (classObj == null) {
            classObj = inst.getType();
        }
        return this.getClassName(classObj);
    }

    private String getFuncName() {
        PyObject funcName = null;
        try {
            funcName = this.__func__.__findattr__("__name__");
        }
        catch (PyException pyException) {
            // empty catch block
        }
        if (funcName == null) {
            return "?";
        }
        return funcName.toString();
    }

    @Override
    public Object __tojava__(Class<?> c) {
        if (this.__self__ == null) {
            return super.__tojava__(c);
        }
        if (c.isInstance(this) && c != InvocationHandler.class) {
            return c.cast(this);
        }
        if (c.isInterface()) {
            if (c.getDeclaredMethods().length == 1 && c.getInterfaces().length == 0) {
                return this.proxy(c);
            }
            String name = null;
            for (Method method : c.getMethods()) {
                if (method.getDeclaringClass() == Object.class) continue;
                if (name == null || name.equals(method.getName())) {
                    name = method.getName();
                    continue;
                }
                name = null;
                break;
            }
            if (name != null) {
                return this.proxy(c);
            }
        }
        return super.__tojava__(c);
    }

    private Object proxy(Class<?> c) {
        return Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args2);
        }
        if (args2 == null || args2.length == 0) {
            return this.__call__().__tojava__(method.getReturnType());
        }
        return this.__call__(Py.javas2pys(args2)).__tojava__(method.getReturnType());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.im_class != null && (retVal = visit.visit(this.im_class, arg)) != 0) {
            return retVal;
        }
        if (this.__func__ != null && (retVal = visit.visit(this.__func__, arg)) != 0) {
            return retVal;
        }
        return this.__self__ == null ? 0 : visit.visit(this.__self__, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.im_class || ob == this.__func__ || ob == this.__self__);
    }

    static {
        PyType.addBuilder(PyMethod.class, new PyMethod$PyExposer());
        TYPE = PyType.fromClass(PyMethod.class);
    }
}

