/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.ParseException;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.base.expr;
import org.python.antlr.base.stmt;

public class ArgListCompiler
extends Visitor {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public List<expr> defaults = null;
    public List<String> names = new ArrayList<String>();
    public List<String> fpnames = new ArrayList<String>();
    public List<stmt> init_code = new ArrayList<stmt>();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.clear();
        this.init_code.clear();
    }

    public void appendInitCode(Suite node) {
        node.getInternalBody().addAll(0, this.init_code);
    }

    public List<expr> getDefaults() {
        return this.defaults;
    }

    public void visitArgs(arguments args2) throws Exception {
        int i;
        for (i = 0; i < args2.getInternalArgs().size(); ++i) {
            String name = (String)this.visit(args2.getInternalArgs().get(i));
            this.names.add(name);
            if (!(args2.getInternalArgs().get(i) instanceof Tuple)) continue;
            ArrayList<expr> targets = new ArrayList<expr>();
            targets.add(args2.getInternalArgs().get(i));
            Assign ass = new Assign(args2.getInternalArgs().get(i), targets, (expr)new Name(args2.getInternalArgs().get(i), name, expr_contextType.Load));
            this.init_code.add(ass);
        }
        if (args2.getInternalVararg() != null) {
            this.arglist = true;
            this.names.add(args2.getInternalVararg());
        }
        if (args2.getInternalKwarg() != null) {
            this.keywordlist = true;
            this.names.add(args2.getInternalKwarg());
        }
        this.defaults = args2.getInternalDefaults();
        for (i = 0; i < this.defaults.size(); ++i) {
            if (this.defaults.get(i) != null) continue;
            throw new ParseException("non-default argument follows default argument", args2.getInternalArgs().get(args2.getInternalArgs().size() - this.defaults.size() + i));
        }
    }

    @Override
    public Object visitName(Name node) throws Exception {
        if (node.getInternalCtx() != expr_contextType.Store && node.getInternalCtx() != expr_contextType.Param) {
            return null;
        }
        if (this.fpnames.contains(node.getInternalId())) {
            throw new ParseException("duplicate argument name found: " + node.getInternalId(), node);
        }
        this.fpnames.add(node.getInternalId());
        return node.getInternalId();
    }

    @Override
    public Object visitTuple(Tuple node) throws Exception {
        StringBuffer name = new StringBuffer("(");
        int n = node.getInternalElts().size();
        for (int i = 0; i < n - 1; ++i) {
            name.append(this.visit(node.getInternalElts().get(i)));
            name.append(", ");
        }
        name.append(this.visit(node.getInternalElts().get(n - 1)));
        name.append(")");
        return name.toString();
    }
}

