/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public class TokenMap {
    private int size;
    private TokenMapToken[] tokenMap;
    private boolean ignoreCase;
    private static final int DEFAULT_TOKEN_MAP_SIZE = 52;

    public TokenMap() {
        this(52);
    }

    public TokenMap(int size) {
        this(size, false);
    }

    public TokenMap(boolean ignoreCase) {
        this(52, ignoreCase);
    }

    public TokenMap(int size, boolean ignoreCase) {
        this.size = size;
        this.tokenMap = new TokenMapToken[size];
        this.ignoreCase = ignoreCase;
    }

    private void addTokenToBucket(int bucket, TokenMapToken token2) {
        TokenMapToken old = this.tokenMap[bucket];
        token2.nextToken = old;
        this.tokenMap[bucket] = token2;
    }

    public int get(Segment text2, int start, int end) {
        return this.get(text2.array, start, end);
    }

    public int get(char[] array1, int start, int end) {
        int length1 = end - start + 1;
        int hash = this.getHashCode(array1, start, length1);
        TokenMapToken token2 = this.tokenMap[hash];
        if (!this.ignoreCase) {
            block0: while (token2 != null) {
                if (token2.length == length1) {
                    char[] array2 = token2.text;
                    int offset2 = token2.offset;
                    int offset1 = start;
                    int length = length1;
                    while (length-- > 0) {
                        if (array1[offset1++] == array2[offset2++]) continue;
                        token2 = token2.nextToken;
                        continue block0;
                    }
                    return token2.tokenType;
                }
                token2 = token2.nextToken;
            }
        } else {
            block2: while (token2 != null) {
                if (token2.length == length1) {
                    char[] array2 = token2.text;
                    int offset2 = token2.offset;
                    int offset1 = start;
                    int length = length1;
                    while (length-- > 0) {
                        if (RSyntaxUtilities.toLowerCase(array1[offset1++]) == array2[offset2++]) continue;
                        token2 = token2.nextToken;
                        continue block2;
                    }
                    return token2.tokenType;
                }
                token2 = token2.nextToken;
            }
        }
        return -1;
    }

    private int getHashCode(char[] text2, int offset, int length) {
        return (RSyntaxUtilities.toLowerCase(text2[offset]) + RSyntaxUtilities.toLowerCase(text2[offset + length - 1])) % this.size;
    }

    protected boolean isIgnoringCase() {
        return this.ignoreCase;
    }

    public void put(String string2, int tokenType) {
        if (this.isIgnoringCase()) {
            this.put(string2.toLowerCase().toCharArray(), tokenType);
        } else {
            this.put(string2.toCharArray(), tokenType);
        }
    }

    private void put(char[] string2, int tokenType) {
        int hashCode = this.getHashCode(string2, 0, string2.length);
        this.addTokenToBucket(hashCode, new TokenMapToken(string2, tokenType));
    }

    private static final class TokenMapToken {
        private char[] text;
        private int offset;
        private int length;
        private int tokenType;
        private TokenMapToken nextToken;

        private TokenMapToken(char[] text2, int tokenType) {
            this.text = text2;
            this.offset = 0;
            this.length = text2.length;
            this.tokenType = tokenType;
        }

        public String toString() {
            return "[TokenMapToken: " + new String(this.text, this.offset, this.length) + "]";
        }
    }
}

