/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    DefaultTokenPainter() {
    }

    @Override
    public final float paint(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e) {
        return this.paint(token2, g, x, y, host, e, 0.0f);
    }

    @Override
    public float paint(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart) {
        return this.paintImpl(token2, g, x, y, host, e, clipStart, false, false);
    }

    @Override
    public float paint(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart, boolean paintBG) {
        return this.paintImpl(token2, g, x, y, host, e, clipStart, !paintBG, false);
    }

    protected void paintBackground(float x, float y, float width, float height, Graphics2D g, int fontAscent, RSyntaxTextArea host, Color color) {
        g.setColor(color);
        this.bgRect.setRect(x, y - (float)fontAscent, width, height);
        g.fillRect((int)x, (int)(y - (float)fontAscent), (int)width, (int)height);
    }

    protected float paintImpl(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart, boolean selected, boolean useSTC) {
        int origX = (int)x;
        int textOffs = token2.getTextOffset();
        char[] text2 = token2.getTextArray();
        int end = textOffs + token2.length();
        float nextX = x;
        int flushLen = 0;
        int flushIndex = textOffs;
        Color fg = useSTC ? host.getSelectedTextColor() : host.getForegroundForToken(token2);
        Color bg = selected ? null : host.getBackgroundForToken(token2);
        g.setFont(host.getFontForTokenType(token2.getType()));
        FontMetrics fm = host.getFontMetricsForTokenType(token2.getType());
        block3: for (int i = textOffs; i < end; ++i) {
            switch (text2[i]) {
                case '\t': {
                    nextX = e.nextTabStop(x + (float)fm.charsWidth(text2, flushIndex, flushLen), 0);
                    if (bg != null) {
                        this.paintBackground(x, y, nextX - x, fm.getHeight(), g, fm.getAscent(), host, bg);
                    }
                    if (flushLen > 0) {
                        g.setColor(fg);
                        g.drawChars(text2, flushIndex, flushLen, (int)x, (int)y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    x = nextX;
                    continue block3;
                }
                default: {
                    ++flushLen;
                }
            }
        }
        nextX = x + (float)fm.charsWidth(text2, flushIndex, flushLen);
        Rectangle r = host.getMatchRectangle();
        if (flushLen > 0 && nextX >= clipStart) {
            if (bg != null) {
                this.paintBackground(x, y, nextX - x, fm.getHeight(), g, fm.getAscent(), host, bg);
                if (token2.length() == 1 && r != null && (float)r.x == x) {
                    ((RSyntaxTextAreaUI)host.getUI()).paintMatchedBracketImpl(g, host, r);
                }
            }
            g.setColor(fg);
            g.drawChars(text2, flushIndex, flushLen, (int)x, (int)y);
        }
        if (host.getUnderlineForToken(token2)) {
            g.setColor(fg);
            int y2 = (int)(y + 1.0f);
            g.drawLine(origX, y2, (int)nextX, y2);
        }
        if (host.getPaintTabLines() && origX == host.getMargin().left) {
            this.paintTabLines(token2, origX, (int)y, (int)nextX, g, e, host);
        }
        return nextX;
    }

    @Override
    public float paintSelected(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, boolean useSTC) {
        return this.paintSelected(token2, g, x, y, host, e, 0.0f, useSTC);
    }

    @Override
    public float paintSelected(Token token2, Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e, float clipStart, boolean useSTC) {
        return this.paintImpl(token2, g, x, y, host, e, clipStart, true, useSTC);
    }

    protected void paintTabLines(Token token2, int x, int y, int endX, Graphics2D g, TabExpander e, RSyntaxTextArea host) {
        Token next;
        if (token2.getType() != 21) {
            int offs;
            for (offs = 0; offs < token2.length() && RSyntaxUtilities.isWhitespace(token2.charAt(offs)); ++offs) {
            }
            if (offs < 2) {
                return;
            }
            endX = (int)token2.getWidthUpTo(offs, host, e, 0.0f);
        }
        FontMetrics fm = host.getFontMetricsForTokenType(token2.getType());
        int tabSize = host.getTabSize();
        if (tabBuf == null || tabBuf.length < tabSize) {
            tabBuf = new char[tabSize];
            for (int i = 0; i < tabSize; ++i) {
                DefaultTokenPainter.tabBuf[i] = 32;
            }
        }
        int tabW = fm.charsWidth(tabBuf, 0, tabSize);
        g.setColor(host.getTabLineColor());
        int x0 = x + tabW;
        int y0 = y - fm.getAscent();
        if ((y0 & 1) > 0) {
            ++y0;
        }
        if ((next = token2.getNextToken()) == null || !next.isPaintable()) {
            ++endX;
        }
        while (x0 < endX) {
            int y2 = y0 + host.getLineHeight();
            for (int y1 = y0; y1 < y2; y1 += 2) {
                g.drawLine(x0, y1, x0, y1);
            }
            x0 += tabW;
        }
    }
}

