/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hpack;

import java.io.IOException;
import java.io.OutputStream;

final class HuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;

    HuffmanEncoder(int[] codes, byte[] lengths) {
        this.codes = codes;
        this.lengths = lengths;
    }

    public void encode(OutputStream out, byte[] data) throws IOException {
        this.encode(out, data, 0, data.length);
    }

    public void encode(OutputStream out, byte[] data, int off, int len) throws IOException {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (off < 0 || len < 0 || off + len < 0 || off > data.length || off + len > data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        long current = 0L;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int b = data[off + i] & 0xFF;
            int code2 = this.codes[b];
            byte nbits = this.lengths[b];
            current <<= nbits;
            current |= (long)code2;
            n += nbits;
            while (n >= 8) {
                out.write((int)(current >> (n -= 8)));
            }
        }
        if (n > 0) {
            current <<= 8 - n;
            out.write((int)(current |= (long)(255 >>> n)));
        }
    }

    public int getEncodedLength(byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        long len = 0L;
        for (byte b : data) {
            len += (long)this.lengths[b & 0xFF];
        }
        return (int)(len + 7L >> 3);
    }
}

