/*
 * Decompiled with CFR 0.152.
 */
package burp.api.montoya.http.message.requests;

import burp.api.montoya.core.ByteArray;
import burp.api.montoya.core.Marker;
import burp.api.montoya.http.HttpService;
import burp.api.montoya.http.message.ContentType;
import burp.api.montoya.http.message.HttpHeader;
import burp.api.montoya.http.message.HttpMessage;
import burp.api.montoya.http.message.params.HttpParameter;
import burp.api.montoya.http.message.params.HttpParameterType;
import burp.api.montoya.http.message.params.ParsedHttpParameter;
import burp.api.montoya.http.message.requests.HttpTransformation;
import burp.api.montoya.internal.ObjectFactoryLocator;
import java.util.List;
import java.util.regex.Pattern;

public interface HttpRequest
extends HttpMessage {
    public boolean isInScope();

    public HttpService httpService();

    public String url();

    public String method();

    public String path();

    @Override
    public String httpVersion();

    @Override
    public List<HttpHeader> headers();

    @Override
    public boolean hasHeader(HttpHeader var1);

    @Override
    public boolean hasHeader(String var1);

    @Override
    public boolean hasHeader(String var1, String var2);

    @Override
    public HttpHeader header(String var1);

    @Override
    public String headerValue(String var1);

    public ContentType contentType();

    public List<ParsedHttpParameter> parameters();

    public List<ParsedHttpParameter> parameters(HttpParameterType var1);

    public boolean hasParameters();

    public ParsedHttpParameter parameter(String var1, HttpParameterType var2);

    public String parameterValue(String var1, HttpParameterType var2);

    public boolean hasParameter(String var1, HttpParameterType var2);

    public boolean hasParameter(HttpParameter var1);

    @Override
    public ByteArray body();

    @Override
    public String bodyToString();

    @Override
    public int bodyOffset();

    @Override
    public List<Marker> markers();

    @Override
    public boolean contains(String var1, boolean var2);

    @Override
    public boolean contains(Pattern var1);

    @Override
    public ByteArray toByteArray();

    @Override
    public String toString();

    public HttpRequest copyToTempFile();

    public HttpRequest withService(HttpService var1);

    public HttpRequest withPath(String var1);

    public HttpRequest withMethod(String var1);

    public HttpRequest withHeader(HttpHeader var1);

    public HttpRequest withHeader(String var1, String var2);

    public HttpRequest withParameter(HttpParameter var1);

    public HttpRequest withAddedParameters(List<? extends HttpParameter> var1);

    public HttpRequest withAddedParameters(HttpParameter ... var1);

    public HttpRequest withRemovedParameters(List<? extends HttpParameter> var1);

    public HttpRequest withRemovedParameters(HttpParameter ... var1);

    public HttpRequest withUpdatedParameters(List<? extends HttpParameter> var1);

    public HttpRequest withUpdatedParameters(HttpParameter ... var1);

    public HttpRequest withTransformationApplied(HttpTransformation var1);

    public HttpRequest withBody(String var1);

    public HttpRequest withBody(ByteArray var1);

    public HttpRequest withAddedHeader(String var1, String var2);

    public HttpRequest withAddedHeader(HttpHeader var1);

    public HttpRequest withUpdatedHeader(String var1, String var2);

    public HttpRequest withUpdatedHeader(HttpHeader var1);

    public HttpRequest withRemovedHeader(String var1);

    public HttpRequest withRemovedHeader(HttpHeader var1);

    public HttpRequest withMarkers(List<Marker> var1);

    public HttpRequest withMarkers(Marker ... var1);

    public HttpRequest withDefaultHeaders();

    public static HttpRequest httpRequest() {
        return ObjectFactoryLocator.FACTORY.httpRequest();
    }

    public static HttpRequest httpRequest(ByteArray request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(request);
    }

    public static HttpRequest httpRequest(String request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(request);
    }

    public static HttpRequest httpRequest(HttpService service, ByteArray request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, request);
    }

    public static HttpRequest httpRequest(HttpService service, String request) {
        return ObjectFactoryLocator.FACTORY.httpRequest(service, request);
    }

    public static HttpRequest httpRequestFromUrl(String url) {
        return ObjectFactoryLocator.FACTORY.httpRequestFromUrl(url);
    }

    public static HttpRequest http2Request(HttpService service, List<HttpHeader> headers2, ByteArray body) {
        return ObjectFactoryLocator.FACTORY.http2Request(service, headers2, body);
    }

    public static HttpRequest http2Request(HttpService service, List<HttpHeader> headers2, String body) {
        return ObjectFactoryLocator.FACTORY.http2Request(service, headers2, body);
    }
}

