/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.H2Connection;
import burp.HTTP2Request;
import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpHeader;
import burp.IHttpService;
import burp.WordRecorder;
import burp.api.montoya.MontoyaApi;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import kotlin.Pair;
import kotlin.text.Charsets;

public class Utils {
    static boolean gotBurp = false;
    static IBurpExtenderCallbacks callbacks;
    static IExtensionHelpers helpers;
    static MontoyaApi montoyaApi;
    private static PrintWriter stdout;
    private static PrintWriter stderr;
    static WordRecorder witnessedWords;
    public static boolean unloaded;

    public static void setTurboSize(Dimension size) {
        callbacks.saveExtensionSetting("turboHeight", String.valueOf(size.height));
        callbacks.saveExtensionSetting("turboWidth", String.valueOf(size.width));
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, Charsets.ISO_8859_1);
    }

    public static ArrayList<String> getClipboard() {
        String clipboard = "";
        try {
            clipboard = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            Utils.err("failed to read from clipboard");
        }
        return new ArrayList<String>(Arrays.asList(clipboard.split("\\r?\\n")));
    }

    public static void setClipboard(String contents) {
        StringSelection selection = new StringSelection(contents);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    public static Dimension getTurboSize() {
        try {
            int height = Integer.parseInt(callbacks.loadExtensionSetting("turboHeight")) - 20;
            int width = Integer.parseInt(callbacks.loadExtensionSetting("turboWidth"));
            return new Dimension(width, height);
        }
        catch (Exception e) {
            return new Dimension(1280, 800);
        }
    }

    static void setBurpPresent(IBurpExtenderCallbacks incallbacks) {
        gotBurp = true;
        callbacks = incallbacks;
        helpers = callbacks.getHelpers();
        stdout = new PrintWriter(callbacks.getStdout(), true);
        stderr = new PrintWriter(callbacks.getStderr(), true);
    }

    static void out(String message2) {
        if (gotBurp) {
            stdout.println(message2);
        } else {
            System.out.println(message2);
        }
    }

    static void err(String message2) {
        if (gotBurp) {
            stderr.println(message2);
        } else {
            System.out.println(message2);
        }
    }

    static String getHeaders(String request) {
        int bodyStart = request.indexOf("\r\n\r\n");
        if (bodyStart < 0) {
            return request;
        }
        return request.substring(0, bodyStart);
    }

    public static byte[] h2request(IHttpService service, byte[] req) {
        return Utils.h2request(service, req, null);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] h2request(IHttpService service, byte[] req, String connectionID) {
        void var6_11;
        LinkedList<Pair<String, String>> h2headers = H2Connection.Companion.buildReq(new HTTP2Request(helpers.bytesToString(req)));
        ArrayList<IHttpHeader> headers2 = new ArrayList<IHttpHeader>();
        for (Pair pair : h2headers) {
            headers2.add(helpers.buildHeader((String)pair.getFirst(), (String)pair.getSecond()));
        }
        byte[] body = Utils.getBodyBytes(req);
        try {
            if (connectionID == null) {
                byte[] byArray = callbacks.makeHttp2Request(service, headers2, body, true);
            } else {
                byte[] byArray = callbacks.makeHttp2Request(service, headers2, body, true, connectionID);
            }
        }
        catch (RuntimeException e) {
            Object var6_10 = null;
        }
        return var6_11;
    }

    static byte[] getBodyBytes(byte[] response) {
        if (response == null) {
            return null;
        }
        int bodyStart = Utils.getBodyStart(response);
        return Arrays.copyOfRange(response, bodyStart, response.length);
    }

    public static int getBodyStart(byte[] response) {
        return Utils.indexOf(response, "\r\n\r\n".getBytes()) + 4;
    }

    public static int indexOf(byte[] outerArray, byte[] smallerArray) {
        for (int i = 0; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    static {
        witnessedWords = new WordRecorder();
        unloaded = false;
    }
}

