/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.ConfigurableSettings;
import burp.IBurpExtenderCallbacks;
import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IRequestInfo;
import burp.IScannerInsertionPoint;
import burp.LazyRequestInfo;
import burp.Resp;
import burp.api.montoya.MontoyaApi;
import burp.api.montoya.core.ByteArray;
import burp.api.montoya.http.HttpService;
import burp.api.montoya.http.message.requests.HttpRequest;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

class Utilities {
    public static final String version = "1.10b";
    public static String name = "uninitialised";
    private static PrintWriter stdout;
    private static PrintWriter stderr;
    static final boolean DEBUG = false;
    static boolean chopNestedResponses;
    static boolean supportsHTTP2;
    static AtomicBoolean unloaded;
    static final byte PARAM_HEADER = 7;
    static IBurpExtenderCallbacks callbacks;
    static IExtensionHelpers helpers;
    static MontoyaApi montoyaApi;
    static HashSet<String> phpFunctions;
    static HashSet<String> wafParams;
    static ArrayList<String> paramNames;
    static HashSet<String> boringHeaders;
    static Set<String> reportedParams;
    static CircularFifoQueue<Long> requestTimes;
    static AtomicInteger requestCount;
    private static final String CHARSET = "0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String START_CHARSET = "ghijklmnopqrstuvwxyz";
    static Random rnd;
    static int burpTimeout;
    static ConfigurableSettings globalSettings;
    private static char[] DIGITS;
    static ThreadLocal<Integer> goAcceleratorPort;
    static AtomicInteger nextPort;

    static JFrame getBurpFrame() {
        for (Frame f : Frame.getFrames()) {
            if (!f.isVisible() || !f.getTitle().startsWith("Burp Suite")) continue;
            return (JFrame)f;
        }
        return null;
    }

    Utilities(IBurpExtenderCallbacks incallbacks, HashMap<String, Object> settings, String name) {
        Utilities.name = name;
        callbacks = incallbacks;
        stdout = new PrintWriter(callbacks.getStdout(), true);
        stderr = new PrintWriter(callbacks.getStderr(), true);
        helpers = callbacks.getHelpers();
        try {
            burpTimeout = Integer.parseInt(Utilities.getSetting("project_options.connections.timeouts.normal_timeout"));
        }
        catch (IndexOutOfBoundsException e) {
            burpTimeout = 10;
        }
        Utilities.out("Using albinowaxUtils v1.10b");
        Utilities.out("This extension should be run on the latest version of Burp Suite. Using an older version of Burp may cause impaired functionality.");
        if (settings != null) {
            globalSettings = new ConfigurableSettings(settings);
        }
    }

    static boolean isBurpPro() {
        return callbacks.getBurpVersion()[0].contains("Professional");
    }

    static String getResource(String name) {
        return new Scanner(Utilities.class.getResourceAsStream(name), "UTF-8").useDelimiter("\\A").next();
    }

    static String getSetting(String name) {
        int depth = StringUtils.countMatches((CharSequence)name, ".") + 1;
        String json = callbacks.saveConfigAsJson(name);
        String value = json.split("\n")[depth].split(":", 2)[1];
        return value;
    }

    static void showError(Exception e) {
        Utilities.out("Error in thread: " + e.getMessage() + ". See error pane for stack trace.");
        e.printStackTrace(stderr);
    }

    static String getNameFromType(byte type) {
        switch (type) {
            case 1: {
                return "body";
            }
            case 0: {
                return "url";
            }
            case 2: {
                return "cookie";
            }
            case 6: {
                return "json";
            }
            case 7: {
                return "header";
            }
        }
        return "unknown";
    }

    static int generate(int seed, int count2, List<String> accumulator) {
        int num;
        int limit = seed + count2;
        for (num = seed; num < limit; ++num) {
            String word = Utilities.num2word(num);
            if (word != null) {
                accumulator.add(word);
                continue;
            }
            ++limit;
        }
        return num;
    }

    private static String num2word(int num) {
        String number = Utilities.num2String(num);
        if (number.contains("0")) {
            return null;
        }
        return number;
    }

    private static String num2String(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("+ve integers only please");
        }
        char[] buf = new char[7];
        int charPos = 6;
        for (i = -i; i <= -DIGITS.length; i /= DIGITS.length) {
            buf[charPos--] = DIGITS[-(i % DIGITS.length)];
        }
        buf[charPos] = DIGITS[-i];
        return new String(buf, charPos, 7 - charPos);
    }

    static String filter(String input, String safeChars) {
        StringBuilder out = new StringBuilder(input.length());
        HashSet charset2 = new HashSet();
        charset2.addAll(safeChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList()));
        for (char c2 : input.toCharArray()) {
            if (!charset2.contains(Character.valueOf(c2))) continue;
            out.append(c2);
        }
        return out.toString();
    }

    static boolean mightBeOrderBy(String name, String value) {
        return name.toLowerCase().contains("order") || name.toLowerCase().contains("sort") || value.toLowerCase().equals("asc") || value.toLowerCase().equals("desc") || StringUtils.isNumeric(value) && Double.parseDouble(value) <= 1000.0 || value.length() < 20 && StringUtils.isAlpha(value);
    }

    static boolean mightBeIdentifier(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (CharUtils.isAsciiAlphanumeric(x) || x == '.' || x == '-' || x == '_' || x == ':' || x == '$') continue;
            return false;
        }
        return true;
    }

    static boolean isInPath(IScannerInsertionPoint insertionPoint) {
        boolean isInPath;
        byte type = insertionPoint.getInsertionPointType();
        boolean bl = isInPath = type == 37 || type == 33;
        if (!isInPath && type == 64) {
            String injectionCanary = "zxcvcxz";
            String path = Utilities.getPathFromRequest(insertionPoint.buildRequest("zxcvcxz".getBytes()));
            if (path.contains("zxcvcxz")) {
                if (path.contains("?")) {
                    if (path.indexOf("zxcvcxz") < path.indexOf("?")) {
                        isInPath = true;
                    }
                } else {
                    isInPath = true;
                }
            }
        }
        return isInPath;
    }

    static boolean invertable(String value) {
        return !value.equals(Utilities.invert(value));
    }

    static Object invert(String value) {
        if (value != null) {
            if (value.equals("true")) {
                return false;
            }
            if (value.equals("false")) {
                return true;
            }
            if (value.equals("1")) {
                return 0;
            }
            if (value.equals("0")) {
                return 1;
            }
        }
        return value;
    }

    static String randomString(int len) {
        StringBuilder sb = new StringBuilder(len);
        sb.append(START_CHARSET.charAt(rnd.nextInt(START_CHARSET.length())));
        for (int i = 1; i < len; ++i) {
            sb.append(CHARSET.charAt(rnd.nextInt(CHARSET.length())));
        }
        return sb.toString();
    }

    static String mangle(String seed) {
        Random seededRandom = new Random(seed.hashCode());
        StringBuilder sb = new StringBuilder(7);
        sb.append(START_CHARSET.charAt(seededRandom.nextInt(START_CHARSET.length())));
        for (int i = 1; i < 8; ++i) {
            sb.append(CHARSET.charAt(seededRandom.nextInt(CHARSET.length())));
        }
        return sb.toString();
    }

    static void out(String message2) {
        stdout.println(message2);
    }

    static void err(String message2) {
        stderr.println(message2);
    }

    static void log(String message2) {
    }

    static String getHeaders(byte[] response) {
        if (response == null) {
            return "";
        }
        int bodyStart = Utilities.getBodyStart(response);
        String body = helpers.bytesToString(Arrays.copyOfRange(response, 0, bodyStart));
        body = body.substring(body.indexOf("\n") + 1);
        return body;
    }

    static String getBody(byte[] response) {
        if (response == null) {
            return "";
        }
        int bodyStart = Utilities.getBodyStart(response);
        String body = helpers.bytesToString(Arrays.copyOfRange(response, bodyStart, response.length));
        return body;
    }

    static byte[] getBodyBytes(byte[] response) {
        if (response == null) {
            return null;
        }
        int bodyStart = Utilities.getBodyStart(response);
        return Arrays.copyOfRange(response, bodyStart, response.length);
    }

    static String generateCanary() {
        return Utilities.randomString(4 + rnd.nextInt(7)) + Integer.toString(rnd.nextInt(9));
    }

    private static String sensibleURL(URL url) {
        String out = url.toString();
        if (url.getDefaultPort() == url.getPort()) {
            out = out.replaceFirst(":" + Integer.toString(url.getPort()), "");
        }
        return out;
    }

    static URL getURL(byte[] request, IHttpService service) {
        URL url;
        try {
            url = new URL(service.getProtocol(), service.getHost(), service.getPort(), Utilities.getPathFromRequest(request));
        }
        catch (MalformedURLException e) {
            url = null;
        }
        return url;
    }

    static URL getURL(IHttpRequestResponse request) {
        return Utilities.getURL(request.getRequest(), request.getHttpService());
    }

    static int parseArrayIndex(String key) {
        try {
            if (key.length() > 2 && key.startsWith("[") && key.endsWith("]")) {
                return Integer.parseInt(key.substring(1, key.length() - 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    static boolean mightBeFunction(String value) {
        return phpFunctions.contains(value);
    }

    static byte[] setPath(byte[] request, String newPath) {
        String oldPath = Utilities.getPathFromRequest(request);
        return Utilities.replaceFirst(request, oldPath.getBytes(), newPath.getBytes());
    }

    static String getPathFromRequest(byte[] request) {
        boolean recording = false;
        StringBuilder path = new StringBuilder("");
        for (int i = 0; i < request.length; ++i) {
            byte x = request[i];
            if (recording) {
                if (x == 32) break;
                path.append((char)x);
                continue;
            }
            if (x != 32) continue;
            recording = true;
        }
        return path.toString();
    }

    static boolean isHTTP2(byte[] request) {
        int i;
        for (i = 0; i < request.length && request[i] != 13; ++i) {
        }
        if (i < 6) {
            return false;
        }
        return "HTTP/2".equals(new String(Arrays.copyOfRange(request, i - 6, i)));
    }

    static String getExtension(byte[] request) {
        int last_dot;
        String url = Utilities.getPathFromRequest(request);
        int query_start = url.indexOf(63);
        if (query_start == -1) {
            query_start = url.length();
        }
        if ((last_dot = (url = url.substring(0, query_start)).lastIndexOf(46)) == -1) {
            return "";
        }
        return url.substring(last_dot);
    }

    static byte[] replace(byte[] request, String find, String replace) {
        return Utilities.replace(request, find.getBytes(), replace.getBytes());
    }

    static IHttpRequestResponse fetchFromSitemap(URL url) {
        IHttpRequestResponse[] pages;
        for (IHttpRequestResponse page : pages = callbacks.getSiteMap(Utilities.sensibleURL(url))) {
            if (page.getResponse() == null || !url.equals(Utilities.getURL(page))) continue;
            return page;
        }
        return null;
    }

    static int countByte(byte[] response, byte match) {
        int count2 = 0;
        for (int i = 0; i < response.length; ++i) {
            if (response[i] != match) continue;
            ++count2;
        }
        return count2;
    }

    static int countMatches(Resp response, String match) {
        byte[] resp = response.getReq().getResponse();
        if (resp == null || resp.length == 0) {
            return 0;
        }
        return Utilities.countMatches(resp, match.getBytes());
    }

    static int countMatches(byte[] response, byte[] match) {
        int matches = 0;
        if (match.length < 4) {
            return matches;
        }
        for (int start = 0; start < response.length && (start = helpers.indexOf(response, match, true, start, response.length)) != -1; start += match.length) {
            ++matches;
        }
        return matches;
    }

    static int byteCount(byte[] response, char match, int from, int to) {
        int count2 = 0;
        for (int i = from; i < to; ++i) {
            if (response[i] != match) continue;
            ++count2;
        }
        return count2;
    }

    static byte[] replace(byte[] request, byte[] find, byte[] replace) {
        return Utilities.replace(request, find, replace, -1);
    }

    static byte[] replaceFirst(byte[] request, String find, String replace) {
        return Utilities.replace(request, find.getBytes(), replace.getBytes(), 1);
    }

    static byte[] replaceFirst(byte[] request, byte[] find, byte[] replace) {
        return Utilities.replace(request, find, replace, 1);
    }

    private static byte[] replace(byte[] request, byte[] find, byte[] replace, int limit) {
        List<int[]> matches = Utilities.getMatches(request, find, -1);
        if (limit != -1 && limit < matches.size()) {
            matches = matches.subList(0, limit);
        }
        if (matches.size() == 0) {
            return request;
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (int i = 0; i < matches.size(); ++i) {
                if (i == 0) {
                    outputStream.write(Arrays.copyOfRange(request, 0, matches.get(i)[0]));
                } else {
                    outputStream.write(Arrays.copyOfRange(request, matches.get(i - 1)[1], matches.get(i)[0]));
                }
                outputStream.write(replace);
                if (i != matches.size() - 1) continue;
                outputStream.write(Arrays.copyOfRange(request, matches.get(i)[1], request.length));
                break;
            }
            request = outputStream.toByteArray();
        }
        catch (IOException e) {
            Utilities.out("IO Exception in replace() somehow");
            return null;
        }
        return request;
    }

    static byte[] appendToQueryzzz(byte[] request, String suffix) {
        if (suffix == null || ((String)suffix).equals("")) {
            return request;
        }
        int lineEnd = 0;
        while (lineEnd < request.length && request[lineEnd++] != 10) {
        }
        int queryStart = 0;
        while (queryStart < lineEnd && request[queryStart++] != 63) {
        }
        suffix = queryStart >= lineEnd ? "?" + (String)suffix : "&";
        return Utilities.replace(request, " HTTP/".getBytes(), ((String)suffix + " HTTP/").getBytes());
    }

    static byte[] setBody(byte[] req, String body) {
        try {
            ByteArrayOutputStream synced = new ByteArrayOutputStream();
            synced.write(Arrays.copyOfRange(req, 0, Utilities.getBodyStart(req)));
            synced.write(body.getBytes());
            return synced.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    static byte[] appendToQuery(byte[] request, String suffix) {
        String url = Utilities.getPathFromRequest(request);
        if (url.contains("?")) {
            if (url.indexOf("?") != url.length() - 1) {
                suffix = "&" + (String)suffix;
            }
        } else {
            suffix = "?" + (String)suffix;
        }
        return Utilities.replaceFirst(request, url.getBytes(), (url + (String)suffix).getBytes());
    }

    static byte[] appendToPath(byte[] request, String suffix) {
        if (suffix == null || suffix.equals("")) {
            return request;
        }
        int i = 0;
        while (i < request.length && request[i++] != 10) {
        }
        int j = 0;
        while (j < i && request[j++] != 63) {
        }
        request = j >= i ? Utilities.replace(request, " HTTP/".getBytes(), (suffix + " HTTP/").getBytes()) : Utilities.replace(request, "?".getBytes(), (suffix + "?").getBytes());
        return request;
    }

    static List<int[]> getMatches(byte[] response, byte[] match, int giveUpAfter) {
        if (giveUpAfter == -1) {
            giveUpAfter = response.length;
        }
        if (match.length == 0) {
            throw new RuntimeException("Utilities.getMatches() on the empty string is not allowed)");
        }
        ArrayList<int[]> matches = new ArrayList<int[]>();
        for (int start = 0; start < giveUpAfter && (start = helpers.indexOf(response, match, true, start, giveUpAfter)) != -1; start += match.length) {
            matches.add(new int[]{start, start + match.length});
        }
        return matches;
    }

    public static byte[] setMethod(byte[] request, String newMethod) {
        int i = 0;
        while (request[++i] != 32) {
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(newMethod.getBytes());
            outputStream.write(Arrays.copyOfRange(request, i, request.length));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    public static void doActiveScan(IHttpRequestResponse req, int[] offsets) {
        String host = helpers.analyzeRequest(req).getUrl().getHost();
        int port = helpers.analyzeRequest(req).getUrl().getPort();
        boolean useHTTPS = helpers.analyzeRequest(req).getUrl().toString().startsWith("https");
        ArrayList<int[]> offsetList = new ArrayList<int[]>();
        offsetList.add(offsets);
        try {
            callbacks.doActiveScan(host, port, useHTTPS, req.getRequest(), offsetList);
        }
        catch (IllegalArgumentException e) {
            Utilities.err("Couldn't scan, bad insertion points: " + Arrays.toString((int[])offsetList.get(0)));
        }
    }

    static String fuzzSuffix() {
        if (globalSettings.getBoolean("fuzz detect")) {
            return "<a`'\"${{\\";
        }
        return "";
    }

    static String toCanary(String payload) {
        return globalSettings.getString("canary") + Utilities.mangle(payload);
    }

    public static int getBodyStart(byte[] response) {
        int i;
        int newlines_seen = 0;
        for (i = 0; i < response.length; ++i) {
            byte x = response[i];
            if (x == 10) {
                ++newlines_seen;
            } else if (x != 13) {
                newlines_seen = 0;
            }
            if (newlines_seen != 2) continue;
            ++i;
            break;
        }
        return i;
    }

    static String getStartType(byte[] response) {
        int i;
        Object start = "";
        if (i == response.length) {
            start = "[blank]";
        } else if (response[i] == 60) {
            for (i = Utilities.getBodyStart(response); i < response.length && response[i] != 32 && response[i] != 10 && response[i] != 13 && response[i] != 62; ++i) {
                start = (String)start + (char)(response[i] & 0xFF);
            }
        } else {
            start = "text";
        }
        return start;
    }

    public static byte[] appendToHeader(byte[] request, String header2, String value) {
        String baseValue = Utilities.getHeader(request, header2);
        if ("".equals(baseValue)) {
            return request;
        }
        return Utilities.addOrReplaceHeader(request, header2, baseValue + value);
    }

    public static String getHeader(byte[] request, String header2) {
        int[] offsets = Utilities.getHeaderOffsets(request, header2);
        if (offsets == null) {
            return "";
        }
        String value = helpers.bytesToString(Arrays.copyOfRange(request, offsets[1], offsets[2]));
        return value;
    }

    public static String getMethod(byte[] request) {
        int i = 0;
        while (request[i] != 32) {
            ++i;
        }
        return new String(Arrays.copyOfRange(request, 0, i));
    }

    static short getCode(byte[] resp) {
        int i;
        if (resp == null || resp.length == 0) {
            return 0;
        }
        for (i = 0; i < resp.length && resp[i] != 32; ++i) {
        }
        int start = ++i;
        while (i < resp.length && resp[i] != 32) {
            ++i;
        }
        if (start == i) {
            return 0;
        }
        return Short.parseShort(new String(Arrays.copyOfRange(resp, start, i)));
    }

    public static boolean containsBytes(byte[] request, byte[] value) {
        if (request == null) {
            return false;
        }
        return helpers.indexOf(request, value, false, 0, request.length) != -1;
    }

    static boolean contains(Resp response, String match) {
        byte[] resp = response.getReq().getResponse();
        if (resp == null || resp.length == 0) {
            return false;
        }
        return helpers.indexOf(resp, match.getBytes(), false, 0, resp.length) != -1;
    }

    public static byte[] setHeader(byte[] request, String header2, String value) {
        return Utilities.setHeader(request, header2, value, false);
    }

    public static byte[] setHeader(byte[] request, String header2, String value, boolean tolerateMissing) {
        int[] offsets = Utilities.getHeaderOffsets(request, header2);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(Arrays.copyOfRange(request, 0, offsets[1]));
            outputStream.write(helpers.stringToBytes(value));
            outputStream.write(Arrays.copyOfRange(request, offsets[2], request.length));
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Req creation unexpectedly failed");
        }
        catch (NullPointerException e) {
            if (tolerateMissing) {
                return request;
            }
            Utilities.out("header locating fail: " + header2);
            Utilities.out("'" + helpers.bytesToString(request) + "'");
            throw new RuntimeException("Can't find the header: " + header2);
        }
    }

    public static String encodeJSON(String input) {
        input = input.replace("\\", "\\\\");
        input = input.replace("\"", "\\\"");
        return input;
    }

    public static int[] getHeaderOffsets(byte[] request, String header2) {
        int i = 0;
        int end = request.length;
        while (i < end) {
            int line_start = i++;
            while (i < end && request[i++] != 32) {
            }
            byte[] header_name = Arrays.copyOfRange(request, line_start, i - 2);
            int headerValueStart = i;
            while (i < end && request[i++] != 10) {
            }
            if (i == end) break;
            String header_str = helpers.bytesToString(header_name);
            if (header2.equals(header_str)) {
                int[] offsets = new int[]{line_start, headerValueStart, i - 2};
                return offsets;
            }
            if (i + 2 >= end || request[i] != 13 || request[i + 1] != 10) continue;
            break;
        }
        return null;
    }

    public static byte[] addOrReplaceHeader(byte[] request, String header2, String value) {
        if (Utilities.getHeaderOffsets(request, header2) != null) {
            return Utilities.setHeader(request, header2, value);
        }
        return Utilities.replaceFirst(request, "\r\n\r\n".getBytes(), ("\r\n" + header2 + ": " + value + "\r\n\r\n").getBytes());
    }

    public static byte[] addOrReplaceHeaderOld(byte[] request, String header2, String value) {
        try {
            int i = 0;
            int end = request.length;
            while (i < end && request[i++] != 10) {
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while (i < end) {
                int line_start = i;
                while (i < end && request[i++] != 32) {
                }
                byte[] header_name = Arrays.copyOfRange(request, line_start, i - 2);
                int headerValueStart = i;
                while (i < end && request[i++] != 10) {
                }
                if (i == end) break;
                if (i + 2 < end && request[i] == 13 && request[i + 1] == 10) {
                    outputStream.write(Arrays.copyOfRange(request, 0, i));
                    outputStream.write(helpers.stringToBytes(header2 + ": " + value + "\r\n"));
                    outputStream.write(Arrays.copyOfRange(request, i, end));
                    return outputStream.toByteArray();
                }
                String header_str = helpers.bytesToString(header_name);
                if (!header2.equals(header_str)) continue;
                outputStream.write(Arrays.copyOfRange(request, 0, headerValueStart));
                outputStream.write(helpers.stringToBytes(value));
                outputStream.write(Arrays.copyOfRange(request, i - 2, end));
                return outputStream.toByteArray();
            }
            outputStream.write(Arrays.copyOfRange(request, 0, end - 2));
            outputStream.write(helpers.stringToBytes(header2 + ": " + value + "\r\n\r\n"));
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Req creation unexpectedly failed");
        }
    }

    static boolean isResponse(byte[] data) {
        byte[] start = Arrays.copyOfRange(data, 0, 5);
        return helpers.bytesToString(start).equals("HTTP/");
    }

    public static byte[] fixContentLength(byte[] request) {
        if (Utilities.countMatches(request, helpers.stringToBytes("Content-Length: ")) > 0) {
            int start = Utilities.getBodyStart(request);
            int contentLength = request.length - start;
            return Utilities.setHeader(request, "Content-Length", Integer.toString(contentLength), true);
        }
        return request;
    }

    static boolean isHTTP(URL url) {
        String protocol = url.getProtocol().toLowerCase();
        return "https".equals(protocol);
    }

    static IHttpRequestResponse highlightRequestResponse(IHttpRequestResponse attack, String responseHighlight, String requestHighlight, IScannerInsertionPoint insertionPoint) {
        ArrayList<int[]> requestMarkers = new ArrayList<int[]>(1);
        if (requestHighlight != null && requestHighlight.length() > 2) {
            requestMarkers.add(insertionPoint.getPayloadOffsets(requestHighlight.getBytes()));
        }
        List<int[]> responseMarkers = new ArrayList<int[]>(1);
        if (responseHighlight != null) {
            responseMarkers = Utilities.getMatches(attack.getResponse(), responseHighlight.getBytes(), -1);
        }
        attack = callbacks.applyMarkers(attack, requestMarkers, responseMarkers);
        return attack;
    }

    static IHttpRequestResponse fetchWithGo(IHttpService service, byte[] req) {
        int port = goAcceleratorPort.get();
        if (port == 0) {
            goAcceleratorPort.set(nextPort.getAndIncrement());
        }
        try {
            int read;
            Utilities.out("Routing request to " + port);
            Socket sock = new Socket("127.0.0.1", port);
            String preppedService = service.getProtocol() + "://" + service.getHost() + ":" + service.getPort();
            sock.getOutputStream().write((preppedService + "\u0000|\u0000" + helpers.bytesToString(req) + "\u0000|\u0000").getBytes());
            byte[] readBuffer = new byte[4096];
            ByteArrayOutputStream response = new ByteArrayOutputStream();
            while ((read = sock.getInputStream().read(readBuffer)) != -1) {
                response.write(Arrays.copyOfRange(readBuffer, 0, read));
            }
            throw new RuntimeException("oh dear");
        }
        catch (Exception e) {
            Utilities.out("oh dear");
            return null;
        }
    }

    static byte[] convertToHttp1(byte[] req) {
        String tmp = new String(req, StandardCharsets.ISO_8859_1);
        tmp = tmp.replaceFirst("HTTP/2", "HTTP/1.1");
        return tmp.getBytes(StandardCharsets.ISO_8859_1);
    }

    static IHttpRequestResponse attemptRequest_deprecated(IHttpService service, byte[] req) {
        return Utilities.attemptRequest_deprecated(service, req, false);
    }

    static IHttpRequestResponse attemptRequest_deprecated(IHttpService service, byte[] req, boolean forceHttp1) {
        if (unloaded.get()) {
            Utilities.out("Extension unloaded - aborting attack");
            throw new RuntimeException("Extension unloaded");
        }
        boolean LOG_PERFORMANCE = false;
        boolean GO_ACCELERATOR = false;
        IHttpRequestResponse result2 = null;
        long start = 0L;
        int maxAttempts = 3;
        boolean expectNestedResponse = false;
        if (chopNestedResponses && "1".equals(Utilities.getHeader(req, "X-Mine-Nested-Request"))) {
            expectNestedResponse = true;
            maxAttempts = globalSettings.getInt("tunnelling retry count");
        }
        for (int attempt = 1; attempt < maxAttempts; ++attempt) {
            try {
                if (LOG_PERFORMANCE) {
                    requestCount.incrementAndGet();
                    start = System.currentTimeMillis();
                }
                result2 = GO_ACCELERATOR ? Utilities.fetchWithGo(service, req) : callbacks.makeHttpRequest(service, req, forceHttp1);
            }
            catch (RuntimeException e) {
                Utilities.log(e.toString());
                Utilities.log("Critical request error, retrying...");
                continue;
            }
            if (result2.getResponse() == null) {
                Utilities.log("Req failed, retrying...");
                continue;
            }
            if (expectNestedResponse) {
                byte[] nestedResponse = Utilities.getNestedResponse(result2.getResponse());
                result2.setResponse(nestedResponse);
                if (nestedResponse == null) continue;
            }
            if (!LOG_PERFORMANCE) break;
            long duration = System.currentTimeMillis() - start;
            Utilities.out("Time: " + duration);
            break;
        }
        if (result2 == null || result2.getResponse() == null) {
            if (expectNestedResponse) {
                if (globalSettings.getBoolean("abort on tunnel failure")) {
                    throw new RuntimeException("Failed to get a nested response after " + maxAttempts + " retries. Bailing!");
                }
                Utilities.out("Failed to get a nested response after " + maxAttempts + " retries. Continuing with null response.");
            } else {
                Utilities.log("Req failed multiple times, giving up");
            }
        }
        return result2;
    }

    static byte[] getNestedResponse(byte[] response) {
        byte[] body = Utilities.getBodyBytes(response);
        if (!Utilities.containsBytes(body, "HTTP/".getBytes())) {
            return null;
        }
        int nestedRespStart = helpers.indexOf(body, "HTTP/".getBytes(), true, 0, body.length);
        return Arrays.copyOfRange(body, nestedRespStart, body.length);
    }

    static String encodeParam(String payload) {
        return payload.replace("%", "%25").replace("\u0000", "%00").replace("&", "%26").replace("#", "%23").replace(" ", "%20").replace(";", "%3b").replace("+", "%2b").replace("\n", "%0A").replace("\r", "%0d");
    }

    static byte[] addCacheBuster(byte[] req, String cacheBuster) {
        String customHeader;
        if (cacheBuster != null) {
            req = Utilities.appendToQuery(req, cacheBuster + "=1");
        } else {
            cacheBuster = Utilities.generateCanary();
        }
        if (globalSettings.getBoolean("include origin in cachebusters")) {
            req = Utilities.addOrReplaceHeader(req, "Origin", "https://" + cacheBuster + ".com");
        }
        if (globalSettings.getBoolean("include via in cachebusters")) {
            req = Utilities.addOrReplaceHeader(req, "Via", cacheBuster);
        }
        if (globalSettings.getBoolean("include path in cachebusters")) {
            Object path = Utilities.getPathFromRequest(req);
            path = "/" + cacheBuster + "/.." + (String)path;
            req = Utilities.setPath(req, (String)path);
        }
        if (globalSettings.getBoolean("misc header cachebusters")) {
            req = Utilities.appendToHeader(req, "Accept", ", text/" + cacheBuster);
            req = Utilities.appendToHeader(req, "Accept-Encoding", ", " + cacheBuster);
            req = Utilities.appendToHeader(req, "User-Agent", " " + cacheBuster);
        }
        if (!"".equals(customHeader = globalSettings.getString("custom header cachebuster"))) {
            req = Utilities.addOrReplaceHeader(req, customHeader, cacheBuster);
        }
        return req;
    }

    static boolean isHTTPS(IHttpService service) {
        return service.getProtocol().toLowerCase().contains("https");
    }

    static IRequestInfo analyzeRequest(byte[] request) {
        return Utilities.analyzeRequest(request, null);
    }

    static IRequestInfo analyzeRequest(IHttpRequestResponse request) {
        return Utilities.analyzeRequest(request.getRequest(), request.getHttpService());
    }

    static IRequestInfo analyzeRequest(byte[] request, IHttpService service) {
        return new LazyRequestInfo(request, service);
    }

    static HttpRequest buildMontoyaReq(byte[] baseReq, IHttpService service) {
        HttpService montoyaService = HttpService.httpService(service.getHost(), service.getPort(), "https".equals(service.getProtocol()));
        return HttpRequest.httpRequest(montoyaService, ByteArray.byteArray(baseReq));
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        chopNestedResponses = false;
        supportsHTTP2 = true;
        unloaded = new AtomicBoolean(false);
        phpFunctions = new HashSet();
        wafParams = new HashSet();
        paramNames = new ArrayList();
        boringHeaders = new HashSet();
        reportedParams = ConcurrentHashMap.newKeySet();
        requestTimes = new CircularFifoQueue(100);
        requestCount = new AtomicInteger(0);
        rnd = new Random();
        DIGITS = new char[]{'0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        goAcceleratorPort = new ThreadLocal();
        nextPort = new AtomicInteger(1901);
    }
}

