/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.BurpRequestEngine;
import burp.IHttpService;
import burp.Req;
import burp.Request;
import burp.RequestEngine;
import burp.Resp;
import burp.ThreadedRequestEngine;
import burp.Utilities;
import burp.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.functions.Function2;

class TurboHelper
implements AutoCloseable {
    RequestEngine engine;
    private List<Resp> reqs = new LinkedList<Resp>();
    private IHttpService service;
    private int requestTimeout;
    private int id = 0;

    public IHttpService getService() {
        return this.service;
    }

    TurboHelper(IHttpService service, boolean reuseConnection) {
        this(service, reuseConnection, 10, false);
    }

    TurboHelper(IHttpService service, boolean reuseConnection, int requestTimeout) {
        this(service, reuseConnection, requestTimeout, false);
    }

    TurboHelper(IHttpService service, boolean reuseConnection, int requestTimeout, boolean forceH2) {
        this.service = service;
        this.requestTimeout = requestTimeout;
        String url = service.getProtocol() + "://" + service.getHost() + ":" + service.getPort();
        this.engine = forceH2 ? new BurpRequestEngine(url, 1, 20, 0, 0L, this::callback, null, false) : (reuseConnection ? new ThreadedRequestEngine(url, 1, 20, 1, 50, 0, 10L, this::callback, requestTimeout, null, 1024, false, true) : new BurpRequestEngine(url, 1, 20, 0, 0L, this::callback, null, true));
        this.engine.start(5);
    }

    void queue(byte[] req) {
        this.queue(Utilities.helpers.bytesToString(req));
    }

    void queue(String req) {
        this.queue(req, 0, 0);
    }

    void queue(String req, int pauseBefore, int pauseTime) {
        this.engine.queue(req, new ArrayList(), 0, null, null, null, pauseBefore, pauseTime, new ArrayList<String>(), 0L, null);
    }

    Resp blockingRequest(byte[] req) {
        return this.blockingRequest(req, 0, 0);
    }

    Resp blockingRequest(byte[] req, int pauseBefore, int pauseTime) {
        final AtomicReference resp = new AtomicReference();
        final CountDownLatch responseLock = new CountDownLatch(1);
        this.engine.queue(Utilities.helpers.bytesToString(req), new ArrayList(), 0, (Function2<? super Request, ? super Boolean, Boolean>)new Function2<Request, Boolean, Boolean>(){

            @Override
            public Boolean invoke(Request req, Boolean interesting) {
                try {
                    resp.set(new Resp(new Req(req.getRequestAsBytes(), req.getResponseAsBytes(), TurboHelper.this.service), System.currentTimeMillis() - req.getTime()));
                }
                catch (Exception e) {
                    Utils.err(e.getMessage());
                }
                responseLock.countDown();
                return false;
            }
        }, null, null, pauseBefore, pauseTime, new ArrayList<String>(), 0L, null);
        try {
            boolean done = responseLock.await(this.requestTimeout + 1, TimeUnit.SECONDS);
            if (!done) {
                this.waitFor(1);
                return this.dudResponse(req);
            }
        }
        catch (InterruptedException e) {
            this.waitFor(1);
            return this.dudResponse(req);
        }
        return (Resp)resp.get();
    }

    private Resp dudResponse(byte[] req) {
        return new Resp(new Req(req, "null".getBytes(), this.service));
    }

    private boolean callback(Request req, boolean interesting) {
        this.reqs.add(new Resp(new Req(req.getRequestAsBytes(), req.getResponseAsBytes(), this.service), System.currentTimeMillis() - req.getTime()));
        return false;
    }

    List<Resp> waitFor() {
        return this.waitFor(65);
    }

    List<Resp> waitFor(int timeout) {
        this.engine.showStats(timeout);
        return this.reqs;
    }

    int getConnectionCount() {
        return this.engine.getConnections().get();
    }

    @Override
    public void close() throws IOException {
        this.waitFor();
    }
}

