/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.DataFrame;
import burp.Frame;
import burp.GoAwayFrame;
import burp.H2Connection;
import burp.HTTP2RequestEngine;
import burp.HTTP2Utils;
import burp.HeaderFrame;
import burp.PingFrame;
import burp.Request;
import burp.RstStreamFrame;
import burp.SettingsFrame;
import burp.Utils;
import burp.WindowFrame;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006&"}, d2={"Lburp/Stream;", "", "connection", "Lburp/H2Connection;", "streamID", "", "req", "Lburp/Request;", "fromClient", "", "(Lburp/H2Connection;ILburp/Request;Z)V", "body", "", "getBody", "()Ljava/lang/String;", "setBody", "(Ljava/lang/String;)V", "getConnection", "()Lburp/H2Connection;", "headers", "getHeaders", "setHeaders", "getReq", "()Lburp/Request;", "state", "getState", "()I", "setState", "(I)V", "getStreamID", "parseFrame", "Lburp/Frame;", "raw", "", "processFrame", "", "frameBytes", "Companion", "turbo-intruder"})
public final class Stream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final H2Connection connection;
    private final int streamID;
    @NotNull
    private final Request req;
    private int state;
    @NotNull
    private String headers;
    @NotNull
    private String body;
    public static final int CLEAN = 0;
    public static final int WANTBODY = 1;
    public static final int DONE = 2;

    public Stream(@NotNull H2Connection connection, int streamID, @NotNull Request req, boolean fromClient) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(req, "req");
        this.connection = connection;
        this.streamID = streamID;
        this.req = req;
        this.headers = "";
        this.body = "";
        if (!fromClient) {
            throw new Exception("Can't handle client-initiated streams yet");
        }
    }

    @NotNull
    public final H2Connection getConnection() {
        return this.connection;
    }

    public final int getStreamID() {
        return this.streamID;
    }

    @NotNull
    public final Request getReq() {
        return this.req;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    @NotNull
    public final String getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.headers = string2;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    public final void setBody(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "<set-?>");
        this.body = string2;
    }

    public final void processFrame(@NotNull byte[] frameBytes) {
        Object ackFrame;
        Intrinsics.checkNotNullParameter(frameBytes, "frameBytes");
        this.connection.getStateLock().readLock().lock();
        Frame frame = this.parseFrame(frameBytes, this.streamID);
        H2Connection.Companion.debug("Stream " + this.streamID + " type " + frame.getType() + " flags " + frame.getFlags());
        if (frame instanceof SettingsFrame) {
            if (((SettingsFrame)frame).getMaxConcurrentStreams() != 0) {
                H2Connection.Companion.debug("Change max concurrent streams from " + this.connection.getRequestsPerConnection() + " to " + ((SettingsFrame)frame).getMaxConcurrentStreams());
                this.connection.setMaxConcurrentStreams(((SettingsFrame)frame).getMaxConcurrentStreams());
            }
            if (frame.getPayload().length != 0) {
                ackFrame = new Frame(4, 1, 0, new byte[0]);
                this.connection.sendFrame((Frame)ackFrame);
                this.connection.startSendingRequests();
            }
            this.connection.getStreams().remove(this.streamID);
        }
        if (frame instanceof GoAwayFrame) {
            Utils.out("Server sent a GOAWAY, dumping the whole connection");
            this.connection.getStateLock().readLock().unlock();
            this.connection.close();
            return;
        }
        if (frame instanceof RstStreamFrame) {
            Utils.out("Server sent a RST_STREAM, dumping the whole connection");
            this.connection.getStateLock().readLock().unlock();
            this.connection.close();
            return;
        }
        if (this.state == 0) {
            if (frame instanceof HeaderFrame) {
                this.headers = ((HeaderFrame)frame).getHeaderString();
                this.state = !frame.getDie() ? 1 : 2;
            } else if (frame instanceof DataFrame) {
                throw new Exception("Expected headers, got data");
            }
        }
        if (this.state == 1 && frame instanceof DataFrame) {
            ackFrame = this;
            ((Stream)ackFrame).body = Intrinsics.stringPlus(((Stream)ackFrame).body, ((DataFrame)frame).getBody());
        }
        if (frame.getDie()) {
            this.req.setTime((System.nanoTime() - this.req.getTime()) / (long)1000000);
            this.connection.getEngine().getSuccessfulRequests().getAndIncrement();
            this.req.setResponse(this.headers + "\r\n" + this.body);
            HTTP2RequestEngine hTTP2RequestEngine = this.connection.getEngine();
            String string2 = this.req.getResponse();
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            Charset charset2 = Charsets.ISO_8859_1;
            boolean bl = false;
            byte[] byArray = string2.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            boolean interesting = hTTP2RequestEngine.processResponse(this.req, byArray);
            this.connection.getEngine().invokeCallback(this.req, interesting);
            H2Connection.Companion.debug(Intrinsics.stringPlus("Deleting stream ", this.streamID));
            this.connection.getStreams().remove(this.streamID);
        }
        this.connection.getStateLock().readLock().unlock();
    }

    @NotNull
    public final Frame parseFrame(@NotNull byte[] raw, int streamID) {
        Frame frame;
        Intrinsics.checkNotNullParameter(raw, "raw");
        byte type = raw[3];
        byte flags = raw[4];
        byte[] payload = ArraysKt.sliceArray(raw, new IntRange(9, raw.length - 1));
        if (streamID != HTTP2Utils.Companion.fourByteInt(ArraysKt.sliceArray(raw, new IntRange(5, 8)))) {
            throw new Exception("bad stream ID");
        }
        byte by = type;
        switch (by) {
            case 0: {
                frame = new DataFrame(type, flags, streamID, payload);
                break;
            }
            case 1: {
                frame = new HeaderFrame(type, flags, streamID, payload, this);
                break;
            }
            case 3: {
                frame = new RstStreamFrame(type, flags, streamID, payload);
                break;
            }
            case 4: {
                frame = new SettingsFrame(type, flags, streamID, payload);
                break;
            }
            case 6: {
                frame = new PingFrame(type, flags, streamID, payload);
                break;
            }
            case 7: {
                frame = new GoAwayFrame(type, flags, streamID, payload);
                break;
            }
            case 8: {
                frame = new WindowFrame(type, flags, streamID, payload);
                break;
            }
            default: {
                frame = new Frame(type, flags, streamID, payload);
            }
        }
        return frame;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lburp/Stream$Companion;", "", "()V", "CLEAN", "", "DONE", "WANTBODY", "turbo-intruder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

