/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.Frame;
import burp.H2Connection;
import burp.HTTP2Utils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lburp/SettingsFrame;", "Lburp/Frame;", "type", "", "flags", "streamID", "", "payload", "", "(BBI[B)V", "maxConcurrentStreams", "getMaxConcurrentStreams", "()I", "setMaxConcurrentStreams", "(I)V", "turbo-intruder"})
public final class SettingsFrame
extends Frame {
    private int maxConcurrentStreams;

    public SettingsFrame(byte type, byte flags, int streamID, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        super(type, flags, streamID, payload);
        H2Connection.Companion.debug("Parsing settings...");
        if (payload.length == 0) {
            H2Connection.Companion.debug("Just an ack");
        } else {
            block8: for (int head = 0; head < payload.length; head += 6) {
                int key = HTTP2Utils.Companion.twoByteInt(CollectionsKt.toByteArray((Collection<Byte>)ArraysKt.slice(payload, new IntRange(head, head + 1))));
                int value = HTTP2Utils.Companion.fourByteInt(CollectionsKt.toByteArray((Collection<Byte>)ArraysKt.slice(payload, new IntRange(head + 2, head + 5))));
                int n = key;
                switch (n) {
                    case 1: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("HEADER_TABLE_SIZE = ", value));
                        continue block8;
                    }
                    case 2: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("ENABLE_PUSH = ", value));
                        continue block8;
                    }
                    case 3: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("MAX_CONCURRENT_STREAMS = ", value));
                        this.maxConcurrentStreams = value;
                        continue block8;
                    }
                    case 4: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("INITIAL_WINDOW_SIZE = ", value));
                        continue block8;
                    }
                    case 5: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("MAX_FRAME_SIZE = ", value));
                        continue block8;
                    }
                    case 6: {
                        H2Connection.Companion.debug(Intrinsics.stringPlus("Max headers = ", value));
                        continue block8;
                    }
                    default: {
                        H2Connection.Companion.debug("Unrecognised setting " + key + '=' + value);
                    }
                }
            }
        }
    }

    public final int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public final void setMaxConcurrentStreams(int n) {
        this.maxConcurrentStreams = n;
    }
}

