/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IResponseInfo;
import burp.IResponseVariations;
import burp.Req;
import burp.Utilities;
import burp.api.montoya.http.message.HttpRequestResponse;
import java.util.Arrays;

class Resp
implements IHttpRequestResponse {
    private IHttpRequestResponse req;
    private HttpRequestResponse montoyaReq;
    private IResponseInfo info;
    private IResponseVariations attributes;
    private long timestamp = 0L;
    private long responseTime = 0L;
    private short status = 0;
    private boolean timedOut = false;
    private boolean failed = false;
    private boolean early = false;

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public short getStatus() {
        return this.status;
    }

    Resp(IHttpRequestResponse req) {
        this(req, System.currentTimeMillis());
    }

    Resp(HttpRequestResponse req) {
        this(new Req(req), System.currentTimeMillis());
    }

    Resp(IHttpRequestResponse req, long startTime) {
        this(req, startTime, System.currentTimeMillis());
    }

    Resp(IHttpRequestResponse req, long startTime, long endTime) {
        this.req = req;
        byte[] fail = Utilities.helpers.stringToBytes("null");
        byte[] earlyResponse = Utilities.helpers.stringToBytes("early-response");
        int scanTimeout = Utilities.globalSettings.getInt("timeout") * 1000;
        this.early = Arrays.equals(req.getResponse(), earlyResponse);
        this.failed = req.getResponse() == null || req.getResponse().length == 0 || Arrays.equals(req.getResponse(), fail) || this.early;
        this.responseTime = endTime - startTime;
        if (Utilities.burpTimeout == scanTimeout) {
            if (this.failed && this.responseTime > (long)scanTimeout) {
                this.timedOut = true;
            }
        } else if (this.responseTime > (long)scanTimeout) {
            this.timedOut = true;
            if (this.failed) {
                Utilities.out("Timeout with response. Start time: " + startTime + " Current time: " + System.currentTimeMillis() + " Difference: " + (System.currentTimeMillis() - startTime) + " Tolerance: " + scanTimeout);
            }
        }
        if (!this.failed) {
            this.status = Utilities.getCode(req.getResponse());
        }
        this.timestamp = System.currentTimeMillis();
    }

    IHttpRequestResponse getReq() {
        return this.req;
    }

    IResponseInfo getInfo() {
        if (this.info == null) {
            this.info = Utilities.helpers.analyzeResponse(this.req.getResponse());
        }
        return this.info;
    }

    IResponseVariations getAttributes() {
        if (this.attributes == null) {
            this.attributes = Utilities.helpers.analyzeResponseVariations(new byte[][]{this.req.getResponse()});
        }
        return this.attributes;
    }

    long getAttribute(String attribute) {
        switch (attribute) {
            case "time": {
                return this.responseTime;
            }
            case "failed": {
                return this.failed ? 1L : 0L;
            }
            case "timedout": {
                return this.timedOut ? 1L : 0L;
            }
        }
        try {
            return this.getAttributes().getAttributeValue(attribute, 0);
        }
        catch (IllegalArgumentException e) {
            Utilities.out("Invalid attribute: " + attribute);
            Utilities.out("Supported attributes: " + this.getAttributes().getInvariantAttributes() + this.getAttributes().getVariantAttributes());
            throw new RuntimeException("Invalid attribute: " + attribute);
        }
    }

    boolean early() {
        return this.early;
    }

    boolean failed() {
        return this.failed || this.timedOut;
    }

    boolean timedOut() {
        return this.timedOut;
    }

    @Override
    public byte[] getRequest() {
        return this.req.getRequest();
    }

    @Override
    public void setRequest(byte[] bytes) {
        this.req.setRequest(bytes);
    }

    @Override
    public byte[] getResponse() {
        return this.req.getResponse();
    }

    @Override
    public void setResponse(byte[] bytes) {
        this.req.setResponse(bytes);
    }

    @Override
    public String getComment() {
        return this.req.getComment();
    }

    @Override
    public void setComment(String s) {
        this.req.setComment(s);
    }

    @Override
    public String getHighlight() {
        return this.req.getHighlight();
    }

    @Override
    public void setHighlight(String s) {
        this.req.setHighlight(s);
    }

    @Override
    public IHttpService getHttpService() {
        return this.req.getHttpService();
    }

    @Override
    public void setHttpService(IHttpService iHttpService) {
        this.req.setHttpService(iHttpService);
    }
}

