/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.AttackHandler;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IMessageEditor;
import burp.IMessageEditorController;
import burp.OutputHandler;
import burp.Request;
import burp.RequestTableModel;
import burp.StubRequest;
import burp.TurboScanIssue;
import burp.UpdateStatusbar;
import burp.Utilities;
import burp.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000fH\u0016J\u0018\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u000f04j\b\u0012\u0004\u0012\u00020\u000f`5H\u0002J\u0010\u00106\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R \u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lburp/RequestTable;", "Ljavax/swing/JPanel;", "Lburp/OutputHandler;", "service", "Lburp/IHttpService;", "handler", "Lburp/AttackHandler;", "(Lburp/IHttpService;Lburp/AttackHandler;)V", "bottomSplit", "Ljavax/swing/JSplitPane;", "getBottomSplit", "()Ljavax/swing/JSplitPane;", "controller", "Lburp/RequestTable$MessageEditorController;", "currentRequest", "Lburp/Request;", "firstEntry", "", "getHandler", "()Lburp/AttackHandler;", "issueTable", "Ljavax/swing/JTable;", "getIssueTable", "()Ljavax/swing/JTable;", "lock", "Ljava/lang/Object;", "model", "Lburp/RequestTableModel;", "getModel", "()Lburp/RequestTableModel;", "requestEditor", "Lburp/IMessageEditor;", "getRequestEditor", "()Lburp/IMessageEditor;", "requestListView", "Ljavax/swing/JScrollPane;", "getRequestListView", "()Ljavax/swing/JScrollPane;", "requests", "", "getRequests", "()Ljava/util/List;", "setRequests", "(Ljava/util/List;)V", "responseEditor", "getResponseEditor", "getService", "()Lburp/IHttpService;", "add", "", "req", "getSelectedRequests", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "setCurrentRequest", "MessageEditorController", "turbo-intruder"})
public final class RequestTable
extends JPanel
implements OutputHandler {
    @NotNull
    private final IHttpService service;
    @NotNull
    private final AttackHandler handler;
    @NotNull
    private List<Request> requests;
    @NotNull
    private final RequestTableModel model;
    @NotNull
    private final JTable issueTable;
    @NotNull
    private final IMessageEditor requestEditor;
    @NotNull
    private final IMessageEditor responseEditor;
    @NotNull
    private final JSplitPane bottomSplit;
    @NotNull
    private final JScrollPane requestListView;
    @NotNull
    private final MessageEditorController controller;
    @Nullable
    private Request currentRequest;
    private boolean firstEntry;
    @NotNull
    private final Object lock;

    public RequestTable(@NotNull IHttpService service, @NotNull AttackHandler handler2) {
        Intrinsics.checkNotNullParameter(service, "service");
        Intrinsics.checkNotNullParameter(handler2, "handler");
        this.service = service;
        this.handler = handler2;
        this.requests = new ArrayList();
        this.model = new RequestTableModel(this);
        this.issueTable = new JTable(this.model);
        this.controller = new MessageEditorController();
        this.firstEntry = true;
        this.lock = new Object();
        this.issueTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>(this.model));
        this.issueTable.setAutoResizeMode(0);
        this.issueTable.getSelectionModel().addListSelectionListener(arg_0 -> RequestTable._init_$lambda-0(this, arg_0));
        this.requestListView = new JScrollPane(this.issueTable);
        Dimension turboSize = Utils.getTurboSize();
        IMessageEditor iMessageEditor = Utils.callbacks.createMessageEditor(this.controller, false);
        Intrinsics.checkNotNullExpressionValue(iMessageEditor, "callbacks.createMessageEditor(controller, false)");
        this.requestEditor = iMessageEditor;
        iMessageEditor = Utils.callbacks.createMessageEditor(this.controller, false);
        Intrinsics.checkNotNullExpressionValue(iMessageEditor, "callbacks.createMessageEditor(controller, false)");
        this.responseEditor = iMessageEditor;
        this.bottomSplit = new JSplitPane(1, this.requestEditor.getComponent(), this.responseEditor.getComponent());
        this.bottomSplit.setResizeWeight(0.5);
        this.bottomSplit.setPreferredSize(new Dimension(turboSize.width, turboSize.height / 2));
        JSplitPane splitPane = new JSplitPane(0, this.requestListView, this.bottomSplit);
        this.requestListView.setPreferredSize(new Dimension(turboSize.width, turboSize.height / 2));
        splitPane.setDividerLocation(0.2);
        splitPane.setPreferredSize(new Dimension(turboSize.width, turboSize.height));
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.5);
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new BevelBorder(1));
        this.add((Component)statusPanel, "South");
        statusPanel.setPreferredSize(new Dimension(this.getWidth(), 30));
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        JLabel statusLabel = new JLabel("");
        statusLabel.setHorizontalAlignment(2);
        statusPanel.add(statusLabel);
        UpdateStatusbar updateStatusbar = new UpdateStatusbar(statusLabel, this.handler);
        Timer panelUpdater = new Timer(1000, updateStatusbar);
        updateStatusbar.setTimer(panelUpdater);
        panelUpdater.start();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem addToSitemap = new JMenuItem("Add to sitemap");
        addToSitemap.addActionListener(arg_0 -> RequestTable._init_$lambda-1(this, arg_0));
        menu.add(addToSitemap);
        JMenuItem createIssueButton = new JMenuItem("Report as issue");
        createIssueButton.addActionListener(arg_0 -> RequestTable._init_$lambda-2(this, menu, statusLabel, arg_0));
        menu.add(createIssueButton);
        this.issueTable.setComponentPopupMenu(menu);
        Utils.callbacks.customizeUiComponent(this);
        Utils.callbacks.customizeUiComponent(this.issueTable);
    }

    @NotNull
    public final IHttpService getService() {
        return this.service;
    }

    @NotNull
    public final AttackHandler getHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public List<Request> getRequests() {
        return this.requests;
    }

    @Override
    public void setRequests(@NotNull List<Request> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.requests = list;
    }

    @NotNull
    public final RequestTableModel getModel() {
        return this.model;
    }

    @NotNull
    public final JTable getIssueTable() {
        return this.issueTable;
    }

    @NotNull
    public final IMessageEditor getRequestEditor() {
        return this.requestEditor;
    }

    @NotNull
    public final IMessageEditor getResponseEditor() {
        return this.responseEditor;
    }

    @NotNull
    public final JSplitPane getBottomSplit() {
        return this.bottomSplit;
    }

    @NotNull
    public final JScrollPane getRequestListView() {
        return this.requestListView;
    }

    public final void setCurrentRequest(@Nullable Request req) {
        Request request = req;
        Intrinsics.checkNotNull(request);
        this.currentRequest = request;
        this.requestEditor.setMessage(req.getRequestAsBytes(), true);
        this.responseEditor.setMessage(Utilities.replaceFirst(req.getResponseAsBytes(), "Content-Encoding: gzip", "X-Content-Encoding: gz"), false);
    }

    private final ArrayList<Request> getSelectedRequests() {
        ArrayList<Request> requests = new ArrayList<Request>();
        TableModel tableModel = this.issueTable.getModel();
        if (tableModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type burp.RequestTableModel");
        }
        RequestTableModel table = (RequestTableModel)tableModel;
        int[] nArray = this.issueTable.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue(nArray, "issueTable.selectedRows");
        for (Object index : (TableModel)nArray) {
            Request req = table.getRequest(this.issueTable.convertRowIndexToModel((int)index));
            if (req == null) continue;
            requests.add(req);
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NotNull Request req) {
        Intrinsics.checkNotNullParameter(req, "req");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.save(req);
            this.getModel().fireTableRowsInserted(CollectionsKt.getLastIndex(this.getRequests()), CollectionsKt.getLastIndex(this.getRequests()));
            if (this.firstEntry) {
                this.getIssueTable().changeSelection(0, 0, false, false);
                this.getIssueTable().requestFocusInWindow();
                this.firstEntry = false;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void save(@NotNull Request req) {
        OutputHandler.DefaultImpls.save(this, req);
    }

    private static final void _init_$lambda-0(RequestTable this$0, ListSelectionEvent it) {
        Request req;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Request request = req = this$0.getModel().getRequest(this$0.getIssueTable().convertRowIndexToModel(this$0.getIssueTable().getSelectedRow()));
        Intrinsics.checkNotNull(request);
        this$0.setCurrentRequest(request);
    }

    private static final void _init_$lambda-1(RequestTable this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        for (Request req : this$0.getSelectedRequests()) {
            Utils.callbacks.addToSiteMap(req.getBurpRequest());
        }
    }

    private static final void _init_$lambda-2(RequestTable this$0, JPopupMenu $menu, JLabel $statusLabel, ActionEvent it) {
        IHttpRequestResponse[] p0;
        Iterator<Request> $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($menu, "$menu");
        Intrinsics.checkNotNullParameter($statusLabel, "$statusLabel");
        Iterable $this$map$iv = this$0.getSelectedRequests();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IHttpRequestResponse iHttpRequestResponse = p0.getBurpRequest();
            collection.add(iHttpRequestResponse);
        }
        List reqs = (List)destination$iv$iv;
        String $i$f$map22 = JOptionPane.showInputDialog($menu, "Comment", "", -1);
        if ($i$f$map22 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String comment = $i$f$map22;
        StringBuilder htmlTable = new StringBuilder();
        htmlTable.append("<table>");
        htmlTable.append("<tr><td>Payload</td><td>Status</td><td>Time</td><td>Arrival</td><td>Label</td><td>Queue ID</td><td>Connection ID</td></tr>");
        for (Request req : this$0.getSelectedRequests()) {
            htmlTable.append("<tr><td>");
            Collection $i$f$mapTo2 = req.getWords();
            boolean bl = false;
            if (!$i$f$mapTo2.isEmpty()) {
                htmlTable.append(req.getWords().get(0));
            }
            htmlTable.append("</td><td>");
            htmlTable.append(req.getStatus());
            htmlTable.append("</td><td>");
            htmlTable.append(req.getTime());
            htmlTable.append("</td><td>");
            htmlTable.append(req.getArrival());
            htmlTable.append("</td><td>");
            htmlTable.append(req.getLabel());
            htmlTable.append("</td><td>");
            htmlTable.append(req.getOrder());
            htmlTable.append("</td><td>");
            htmlTable.append(req.getConnectionID());
            htmlTable.append("</td></tr>");
        }
        htmlTable.append("</table>");
        IHttpService service = ((IHttpRequestResponse)reqs.get(0)).getHttpService();
        byte[] $i$f$mapTo2 = Utils.callbacks.getHelpers().stringToBytes(this$0.getHandler().getBaseRequest());
        Intrinsics.checkNotNullExpressionValue($i$f$mapTo2, "callbacks.helpers.string\u2026ytes(handler.baseRequest)");
        Intrinsics.checkNotNullExpressionValue(service, "service");
        StubRequest baseReq = new StubRequest($i$f$mapTo2, service);
        URL url = new URL(service.getProtocol() + "://" + service.getHost() + ':' + service.getPort());
        String detail = "<b>Comment: " + comment + "</b><br/><br/><b>Status:</b> " + $statusLabel.getText() + "<br/><br/>\n<pre>" + StringsKt.replace$default(this$0.getHandler().getCode(), "<", "&lt;", false, 4, null) + "</pre>\n" + htmlTable;
        p0 = new IHttpRequestResponse[]{baseReq};
        Collection $this$toTypedArray$iv = reqs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IHttpRequestResponse[] iHttpRequestResponseArray = thisCollection$iv.toArray(new IHttpRequestResponse[0]);
        if (iHttpRequestResponseArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        TurboScanIssue issue = new TurboScanIssue(service, url, ArraysKt.plus(p0, iHttpRequestResponseArray), "Turbo Intruder Attack", detail, "Information", "Certain", "");
        Utils.callbacks.addScanIssue(issue);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lburp/RequestTable$MessageEditorController;", "Lburp/IMessageEditorController;", "(Lburp/RequestTable;)V", "getHttpService", "Lburp/IHttpService;", "getRequest", "", "getResponse", "turbo-intruder"})
    public final class MessageEditorController
    implements IMessageEditorController {
        public MessageEditorController() {
            Intrinsics.checkNotNullParameter(RequestTable.this, "this$0");
        }

        @Override
        @Nullable
        public IHttpService getHttpService() {
            return RequestTable.this.getService();
        }

        @Override
        @Nullable
        public byte[] getRequest() {
            Request request = RequestTable.this.currentRequest;
            return request == null ? null : request.getRequestAsBytes();
        }

        @Override
        @Nullable
        public byte[] getResponse() {
            Request request = RequestTable.this.currentRequest;
            return request == null ? null : request.getResponseAsBytes();
        }
    }
}

