/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.Floodgate;
import burp.IExtensionStateListener;
import burp.IResponseVariations;
import burp.OutputHandler;
import burp.Request;
import burp.RequestTable;
import burp.SafeResponseVariations;
import burp.ThreadedRequestEngine;
import burp.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0013\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010V\u001a\u00020\f2\u0006\u0010W\u001a\u00020 2\u000e\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0Y2\b\u0010Z\u001a\u0004\u0018\u00010\u001c2\b\u0010[\u001a\u0004\u0018\u00010 H&\u00a2\u0006\u0002\u0010\\J\u0006\u0010]\u001a\u00020^J\u0006\u0010_\u001a\u00020^J\b\u0010`\u001a\u00020^H\u0016J\u0018\u0010a\u001a\u00020\r2\u0006\u0010b\u001a\u00020\t2\u0006\u0010c\u001a\u00020dH\u0002J\u0016\u0010e\u001a\u00020^2\u0006\u0010f\u001a\u00020\f2\u0006\u0010g\u001a\u00020\rJ\u0010\u0010h\u001a\u00020^2\u0006\u0010i\u001a\u00020 H\u0016J\u0016\u0010j\u001a\u00020\r2\u0006\u0010f\u001a\u00020\f2\u0006\u0010k\u001a\u00020lJ\u000e\u0010m\u001a\u00020^2\u0006\u0010f\u001a\u00020 J\u0016\u0010m\u001a\u00020^2\u0006\u0010f\u001a\u00020 2\u0006\u0010n\u001a\u00020TJ\u001e\u0010m\u001a\u00020^2\u0006\u0010W\u001a\u00020 2\u000e\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0YJ\u009a\u0001\u0010m\u001a\u00020^2\u0006\u0010W\u001a\u00020 2\u0010\b\u0002\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0Y2\b\b\u0002\u0010Z\u001a\u00020\u001c2\u001c\b\u0002\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\n\b\u0002\u0010i\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010[\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010o\u001a\u00020\u001c2\b\b\u0002\u0010p\u001a\u00020\u001c2\u000e\b\u0002\u0010q\u001a\b\u0012\u0004\u0012\u00020 0Y2\b\b\u0002\u0010r\u001a\u00020$2\n\b\u0002\u0010s\u001a\u0004\u0018\u00010TJ\u0006\u0010t\u001a\u00020^J\u000e\u0010u\u001a\u00020^2\u0006\u00101\u001a\u000202J\u0006\u0010v\u001a\u00020\rJ\u000e\u0010w\u001a\u00020\r2\u0006\u0010f\u001a\u00020\fJ\u0012\u0010x\u001a\u00020^2\b\b\u0002\u0010y\u001a\u00020\u001cH\u0016J\u0006\u0010z\u001a\u00020^J\u0012\u0010G\u001a\u00020^2\b\b\u0002\u0010y\u001a\u00020\u001cH&J\u0006\u0010{\u001a\u00020 J\u000e\u0010|\u001a\u00020^2\u0006\u0010}\u001a\u00020 J\u0006\u0010~\u001a\u00020^R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0018\u0010#\u001a\u00020$X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u0011\u0010,\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0006R\u0012\u0010.\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0011\u00107\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R&\u00109\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\r\u0018\u00010:X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R \u0010?\u001a\b\u0012\u0004\u0012\u00020\f0@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0006R\u001a\u0010G\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010&\"\u0004\bI\u0010(R\u001a\u0010J\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0006\"\u0004\bL\u0010\u0019R\u001a\u0010M\u001a\u00020NX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001d\u0010S\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020T0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u001e\u00a8\u0006\u007f"}, d2={"Lburp/RequestEngine;", "Lburp/IExtensionStateListener;", "()V", "attackState", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAttackState", "()Ljava/util/concurrent/atomic/AtomicInteger;", "baselines", "Ljava/util/LinkedList;", "Lburp/SafeResponseVariations;", "callback", "Lkotlin/Function2;", "Lburp/Request;", "", "getCallback", "()Lkotlin/jvm/functions/Function2;", "completedLatch", "Ljava/util/concurrent/CountDownLatch;", "getCompletedLatch", "()Ljava/util/concurrent/CountDownLatch;", "setCompletedLatch", "(Ljava/util/concurrent/CountDownLatch;)V", "connections", "getConnections", "setConnections", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "failedWords", "Ljava/util/HashMap;", "", "getFailedWords", "()Ljava/util/HashMap;", "floodgates", "", "Lburp/Floodgate;", "getFloodgates", "idleTimeout", "", "getIdleTimeout", "()J", "setIdleTimeout", "(J)V", "lastLife", "getLastLife", "setLastLife", "lastRequestID", "getLastRequestID", "maxRetriesPerRequest", "getMaxRetriesPerRequest", "()I", "outputHandler", "Lburp/OutputHandler;", "getOutputHandler", "()Lburp/OutputHandler;", "setOutputHandler", "(Lburp/OutputHandler;)V", "permaFails", "getPermaFails", "readCallback", "Lkotlin/Function1;", "getReadCallback", "()Lkotlin/jvm/functions/Function1;", "setReadCallback", "(Lkotlin/jvm/functions/Function1;)V", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "getRequestQueue", "()Ljava/util/concurrent/LinkedBlockingQueue;", "setRequestQueue", "(Ljava/util/concurrent/LinkedBlockingQueue;)V", "retries", "getRetries", "start", "getStart", "setStart", "successfulRequests", "getSuccessfulRequests", "setSuccessfulRequests", "target", "Ljava/net/URL;", "getTarget", "()Ljava/net/URL;", "setTarget", "(Ljava/net/URL;)V", "userState", "", "getUserState", "buildRequest", "template", "payloads", "", "learnBoring", "label", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;)Lburp/Request;", "cancel", "", "clearErrors", "extensionUnloaded", "invariantsMatch", "base", "resp", "Lburp/IResponseVariations;", "invokeCallback", "req", "interesting", "openGate", "gateName", "processResponse", "response", "", "queue", "payload", "pauseBefore", "pauseTime", "pauseMarkers", "delay", "pythonEngine", "reinvokeCallbacks", "setOutput", "shouldAbandonAttack", "shouldRetry", "showStats", "timeout", "showSummary", "statusString", "triggerReadCallback", "data", "updateLastLife", "turbo-intruder"})
public abstract class RequestEngine
implements IExtensionStateListener {
    private long start = System.nanoTime();
    @NotNull
    private final HashMap<Integer, AtomicInteger> failedWords = new HashMap();
    @NotNull
    private AtomicInteger successfulRequests = new AtomicInteger(0);
    @NotNull
    private final HashMap<String, Object> userState = new HashMap();
    @NotNull
    private final AtomicInteger lastRequestID = new AtomicInteger(0);
    @NotNull
    private AtomicInteger connections = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger attackState = new AtomicInteger(0);
    public CountDownLatch completedLatch;
    @NotNull
    private final LinkedList<SafeResponseVariations> baselines = new LinkedList();
    @NotNull
    private final AtomicInteger retries = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger permaFails = new AtomicInteger(0);
    public OutputHandler outputHandler;
    public LinkedBlockingQueue<Request> requestQueue;
    public URL target;
    @NotNull
    private final HashMap<String, Floodgate> floodgates = new HashMap();
    private long lastLife = System.currentTimeMillis();

    public RequestEngine() {
        if (this.attackState.get() == 3) {
            throw new Exception("You cannot create a new request engine for a cancelled attack");
        }
        if (Utils.gotBurp) {
            Utils.callbacks.registerExtensionStateListener(this);
        }
    }

    public final long getStart() {
        return this.start;
    }

    public final void setStart(long l) {
        this.start = l;
    }

    @NotNull
    public final HashMap<Integer, AtomicInteger> getFailedWords() {
        return this.failedWords;
    }

    @NotNull
    public final AtomicInteger getSuccessfulRequests() {
        return this.successfulRequests;
    }

    public final void setSuccessfulRequests(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter(atomicInteger, "<set-?>");
        this.successfulRequests = atomicInteger;
    }

    @NotNull
    public final HashMap<String, Object> getUserState() {
        return this.userState;
    }

    @NotNull
    public final AtomicInteger getLastRequestID() {
        return this.lastRequestID;
    }

    @NotNull
    public final AtomicInteger getConnections() {
        return this.connections;
    }

    public final void setConnections(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter(atomicInteger, "<set-?>");
        this.connections = atomicInteger;
    }

    @NotNull
    public final AtomicInteger getAttackState() {
        return this.attackState;
    }

    @NotNull
    public final CountDownLatch getCompletedLatch() {
        CountDownLatch countDownLatch = this.completedLatch;
        if (countDownLatch != null) {
            return countDownLatch;
        }
        Intrinsics.throwUninitializedPropertyAccessException("completedLatch");
        return null;
    }

    public final void setCompletedLatch(@NotNull CountDownLatch countDownLatch) {
        Intrinsics.checkNotNullParameter(countDownLatch, "<set-?>");
        this.completedLatch = countDownLatch;
    }

    @NotNull
    public final AtomicInteger getRetries() {
        return this.retries;
    }

    @NotNull
    public final AtomicInteger getPermaFails() {
        return this.permaFails;
    }

    @NotNull
    public final OutputHandler getOutputHandler() {
        OutputHandler outputHandler = this.outputHandler;
        if (outputHandler != null) {
            return outputHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("outputHandler");
        return null;
    }

    public final void setOutputHandler(@NotNull OutputHandler outputHandler) {
        Intrinsics.checkNotNullParameter(outputHandler, "<set-?>");
        this.outputHandler = outputHandler;
    }

    @NotNull
    public final LinkedBlockingQueue<Request> getRequestQueue() {
        LinkedBlockingQueue<Request> linkedBlockingQueue = this.requestQueue;
        if (linkedBlockingQueue != null) {
            return linkedBlockingQueue;
        }
        Intrinsics.throwUninitializedPropertyAccessException("requestQueue");
        return null;
    }

    public final void setRequestQueue(@NotNull LinkedBlockingQueue<Request> linkedBlockingQueue) {
        Intrinsics.checkNotNullParameter(linkedBlockingQueue, "<set-?>");
        this.requestQueue = linkedBlockingQueue;
    }

    @NotNull
    public abstract Function2<Request, Boolean, Boolean> getCallback();

    @Nullable
    public abstract Function1<String, Boolean> getReadCallback();

    public abstract void setReadCallback(@Nullable Function1<? super String, Boolean> var1);

    public abstract int getMaxRetriesPerRequest();

    @NotNull
    public final URL getTarget() {
        URL uRL = this.target;
        if (uRL != null) {
            return uRL;
        }
        Intrinsics.throwUninitializedPropertyAccessException("target");
        return null;
    }

    public final void setTarget(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter(uRL, "<set-?>");
        this.target = uRL;
    }

    @NotNull
    public final HashMap<String, Floodgate> getFloodgates() {
        return this.floodgates;
    }

    public final long getLastLife() {
        return this.lastLife;
    }

    public final void setLastLife(long l) {
        this.lastLife = l;
    }

    public abstract long getIdleTimeout();

    public abstract void setIdleTimeout(long var1);

    @Override
    public void extensionUnloaded() {
        this.cancel();
    }

    public final void invokeCallback(@NotNull Request req, boolean interesting) {
        Intrinsics.checkNotNullParameter(req, "req");
        this.updateLastLife();
        try {
            req.invokeCallback(interesting);
        }
        catch (Exception ex) {
            Utils.out(Intrinsics.stringPlus("Error in user-defined callback: ", ex));
            this.permaFails.incrementAndGet();
        }
    }

    public abstract void start(int var1);

    public static /* synthetic */ void start$default(RequestEngine requestEngine, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n2 & 1) != 0) {
            n = 10;
        }
        requestEngine.start(n);
    }

    @NotNull
    public abstract Request buildRequest(@NotNull String var1, @NotNull List<String> var2, @Nullable Integer var3, @Nullable String var4);

    public final void triggerReadCallback(@NotNull String data) {
        Intrinsics.checkNotNullParameter(data, "data");
        Function1<String, Boolean> function1 = this.getReadCallback();
        if (function1 != null) {
            function1.invoke(data);
        }
    }

    public final void queue(@NotNull String req) {
        Intrinsics.checkNotNullParameter(req, "req");
        this.queue(req, CollectionsKt.emptyList());
    }

    public final void queue(@NotNull String req, @NotNull Object payload) {
        Intrinsics.checkNotNullParameter(req, "req");
        Intrinsics.checkNotNullParameter(payload, "payload");
        RequestEngine.queue$default(this, req, CollectionsKt.listOf(payload), 0, null, null, null, 0, 0, null, 0L, null, 2040, null);
    }

    public final void queue(@NotNull String template, @NotNull List<? extends Object> payloads) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(payloads, "payloads");
        RequestEngine.queue$default(this, template, payloads, 0, null, null, null, 0, 0, null, 0L, null, 2032, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void queue(@NotNull String template, @NotNull List<? extends Object> payloads, int learnBoring, @Nullable Function2<? super Request, ? super Boolean, Boolean> callback, @Nullable String gateName, @Nullable String label, int pauseBefore, int pauseTime, @NotNull List<String> pauseMarkers, long delay, @Nullable Object pythonEngine) {
        long attempt;
        int state;
        Unit $this$mapTo$iv$iv2;
        boolean noMarker;
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(payloads, "payloads");
        Intrinsics.checkNotNullParameter(pauseMarkers, "pauseMarkers");
        this.updateLastLife();
        boolean noPayload = payloads.isEmpty();
        boolean bl = noMarker = !StringsKt.contains$default((CharSequence)template, "%s", false, 2, null);
        if (noMarker && !noPayload) {
            throw new Exception("The request has payloads specified, but no %s injection markers");
        }
        if (!noMarker && noPayload) {
            int bad = StringsKt.indexOf$default((CharSequence)template, "%s", 0, false, 6, null);
            int n = bad - 5;
            int n2 = 0;
            boolean bl2 = false;
            int n3 = Math.max(n, n2);
            n = bad + 5;
            n2 = template.length();
            bl2 = false;
            String context = StringsKt.slice(template, new IntRange(n3, Math.min(n, n2)));
            throw new Exception("The request has a %s injection point, but no payloads specified: '" + context + '\'');
        }
        Iterable $this$map$iv = payloads;
        boolean $i$f$map222 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        Object object = $this$mapTo$iv$iv2.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = object.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String string2 = String.valueOf(it);
            collection.add(string2);
        }
        List payloadsAsStrings = (List)destination$iv$iv;
        if (learnBoring != 0 && !Utils.gotBurp) {
            throw new Exception("Automatic interesting response detection using 'learn=X' isn't support in command line mode.");
        }
        String $i$f$map222 = RandomStringUtils.randomAlphanumeric(8);
        Intrinsics.checkNotNullExpressionValue($i$f$map222, "randomAlphanumeric(8)");
        Request request = this.buildRequest(StringsKt.replace(template, "$randomplz", $i$f$map222, true), payloadsAsStrings, learnBoring, label);
        request.set_engine(this);
        if (pythonEngine != null) {
            request.setEngine(pythonEngine);
        } else {
            request.setEngine(this);
        }
        request.setId(this.lastRequestID.incrementAndGet());
        request.setCallback(callback);
        request.setPauseBefore(pauseBefore);
        request.setPauseTime(pauseTime);
        request.setPauseMarkers(pauseMarkers);
        request.setDelayCompletion(delay);
        if (gateName != null) {
            boolean $i$f$map222 = false;
            boolean $this$mapTo$iv$iv2 = false;
            synchronized (gateName) {
                boolean bl4 = false;
                Object $i$f$mapTo2 = this.getFloodgates().get(gateName);
                request.setGate((Floodgate)($i$f$mapTo2 == null ? new Floodgate(gateName, this) : $i$f$mapTo2));
                if (this.getFloodgates().containsKey(gateName)) {
                    Floodgate floodgate = this.getFloodgates().get(gateName);
                    Intrinsics.checkNotNull(floodgate);
                    floodgate.addWaiter();
                } else {
                    $i$f$mapTo2 = this.getFloodgates();
                    Floodgate floodgate = request.getGate();
                    Intrinsics.checkNotNull(floodgate);
                    object = floodgate;
                    boolean bl5 = false;
                    $i$f$mapTo2.put(gateName, object);
                }
                if (this instanceof ThreadedRequestEngine) {
                    Floodgate floodgate = request.getGate();
                    Intrinsics.checkNotNull(floodgate);
                    if (floodgate.remaining.get() > ((ThreadedRequestEngine)this).getThreads()) {
                        throw new Exception("You have queued more gated requests than concurrentConnections, so your attack will deadlock. Consider increasing concurrentConnections");
                    }
                }
                $this$mapTo$iv$iv2 = Unit.INSTANCE;
            }
        }
        if ((state = this.attackState.get()) > 2) {
            throw new IllegalStateException("Cannot queue any more items - the attack has finished");
        }
        long timeout = 1800L;
        if (state == 0) {
            timeout = 1L;
        }
        boolean queued = false;
        for (attempt = 0L; !queued && this.attackState.get() <= 2 && attempt < timeout; ++attempt) {
            queued = this.getRequestQueue().offer(request, 1L, TimeUnit.SECONDS);
        }
        if (!queued) {
            if (state == 0 && this.getRequestQueue().size() == 100) {
                Utils.out("Looks like a non-streaming attack, unlimiting the queue");
                this.setRequestQueue(new LinkedBlockingQueue<Request>((Collection)this.getRequestQueue()));
            } else if (attempt == timeout) {
                Utils.out("Timeout queuing request. Aborting.");
                this.cancel();
            }
        }
    }

    public static /* synthetic */ void queue$default(RequestEngine requestEngine, String string2, List list, int n, Function2 function2, String string3, String string4, int n2, int n3, List list2, long l, Object object, int n4, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: queue");
        }
        if ((n4 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            function2 = null;
        }
        if ((n4 & 0x10) != 0) {
            string3 = null;
        }
        if ((n4 & 0x20) != 0) {
            string4 = null;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 1000;
        }
        if ((n4 & 0x100) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n4 & 0x200) != 0) {
            l = 0L;
        }
        if ((n4 & 0x400) != 0) {
            object = null;
        }
        requestEngine.queue(string2, list, n, function2, string3, string4, n2, n3, list2, l, object);
    }

    public void openGate(@NotNull String gateName) {
        Intrinsics.checkNotNullParameter(gateName, "gateName");
        if (!this.floodgates.containsKey(gateName)) {
            throw new Exception("Unrecognised gate name in openGate() invocation");
        }
        Floodgate floodgate = this.floodgates.get(gateName);
        Intrinsics.checkNotNull(floodgate);
        floodgate.open();
    }

    public final boolean shouldAbandonAttack() {
        if (Utils.unloaded) {
            return true;
        }
        if (this.attackState.get() >= 3) {
            return true;
        }
        if (this.getIdleTimeout() > 0L && System.currentTimeMillis() > this.lastLife + this.getIdleTimeout()) {
            Utils.out("Advising to abandon attack due to timeout");
            this.cancel();
            return true;
        }
        return false;
    }

    public final void updateLastLife() {
        if (this.getIdleTimeout() == 0L) {
            return;
        }
        this.lastLife = System.currentTimeMillis();
    }

    public void showStats(int timeout) {
        if (this.attackState.get() == 3) {
            return;
        }
        boolean success = true;
        this.attackState.set(2);
        if (timeout > 0) {
            success = this.getCompletedLatch().await(timeout, TimeUnit.SECONDS);
        } else {
            while (this.getCompletedLatch().getCount() > 0L && !Utils.unloaded && this.attackState.get() < 3) {
                this.getCompletedLatch().await(10L, TimeUnit.SECONDS);
            }
        }
        if (this.attackState.get() == 3) {
            return;
        }
        if (!success) {
            Utils.out("Aborting attack due to timeout");
            this.attackState.set(3);
        } else {
            Utils.err(Intrinsics.stringPlus("Completed attack on ", this.getTarget()));
            this.attackState.set(4);
        }
        this.showSummary();
    }

    public static /* synthetic */ void showStats$default(RequestEngine requestEngine, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showStats");
        }
        if ((n2 & 1) != 0) {
            n = -1;
        }
        requestEngine.showStats(n);
    }

    public final void cancel() {
        if (Utils.gotBurp && !Utils.unloaded) {
            Utils.callbacks.removeExtensionStateListener(this);
        }
        if (this.attackState.get() != 3) {
            this.attackState.set(3);
            Utils.out("Cancelled attack");
            this.showSummary();
        }
    }

    public final void showSummary() {
        if (Utils.gotBurp && !Utils.unloaded) {
            Utils.callbacks.removeExtensionStateListener(this);
        }
        float duration = (float)System.nanoTime() - (float)this.start;
        float requests = this.successfulRequests.get();
        Utils.err("Sent " + (int)requests + " requests over " + this.connections.intValue() + " connections in " + duration / (float)1000000000 + " seconds");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "RPS: %.0f\n";
        Object[] objectArray = new Object[1];
        double d = duration / (float)1000000000;
        boolean bl = false;
        objectArray[0] = (double)requests / Math.ceil(d);
        boolean bl2 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        Utils.err(string3);
    }

    @NotNull
    public final String statusString() {
        Object object;
        double d = ((float)System.nanoTime() - (float)this.start) / (float)1000000000;
        boolean bl = false;
        int duration = (int)Math.ceil(d);
        float requests = this.successfulRequests.get();
        Request request = this.getRequestQueue().peek();
        String nextWord = request == null ? null : ((object = request.getWords()) == null ? null : CollectionsKt.joinToString$default((Iterable)object, "/", null, null, 0, null, null, 62, null));
        object = StringCompanionObject.INSTANCE;
        String string2 = "Reqs: %d | Queued: %d | Duration: %d | RPS: %.0f | Connections: %d | Retries: %d | Fails: %d | Next: %s";
        Object[] objectArray = new Object[8];
        objectArray[0] = (int)requests;
        Collection collection = this.getRequestQueue();
        boolean bl2 = false;
        objectArray[1] = collection.size();
        objectArray[2] = duration;
        objectArray[3] = Float.valueOf(requests / (float)duration);
        objectArray[4] = this.connections.get();
        objectArray[5] = this.retries.get();
        objectArray[6] = this.permaFails.get();
        objectArray[7] = nextWord;
        boolean bl3 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
        String statusString = string3;
        int state = this.attackState.get();
        return state < 3 ? statusString : (state == 3 ? Intrinsics.stringPlus(statusString, " | Cancelled") : Intrinsics.stringPlus(statusString, " | Completed"));
    }

    public final void reinvokeCallbacks() {
        OutputHandler reqTable = this.getOutputHandler();
        if (reqTable instanceof RequestTable) {
            List<Request> requestsFromTable = reqTable.getRequests();
            if (requestsFromTable.size() == 0) {
                return;
            }
            ArrayList<Request> copy2 = new ArrayList<Request>(requestsFromTable.size());
            for (Request tableReq : requestsFromTable) {
                copy2.add(tableReq);
            }
            requestsFromTable.clear();
            for (Request request : copy2) {
                Intrinsics.checkNotNullExpressionValue(request, "request");
                byte[] byArray = request.getResponseAsBytes();
                Intrinsics.checkNotNull(byArray);
                boolean interesting = this.processResponse(request, byArray);
                this.getCallback().invoke(request, interesting);
            }
            ((RequestTable)reqTable).getModel().fireTableDataChanged();
        }
    }

    public final void setOutput(@NotNull OutputHandler outputHandler) {
        Intrinsics.checkNotNullParameter(outputHandler, "outputHandler");
        this.setOutputHandler(outputHandler);
    }

    public final boolean processResponse(@NotNull Request req, @NotNull byte[] response) {
        Intrinsics.checkNotNullParameter(req, "req");
        Intrinsics.checkNotNullParameter(response, "response");
        if (!Utils.gotBurp) {
            return false;
        }
        Object object = new byte[][]{response};
        IResponseVariations resp = Utils.callbacks.getHelpers().analyzeResponseVariations((byte[][])object);
        object = this.baselines.iterator();
        while (object.hasNext()) {
            SafeResponseVariations base2 = (SafeResponseVariations)object.next();
            Intrinsics.checkNotNullExpressionValue(base2, "base");
            Intrinsics.checkNotNullExpressionValue(resp, "resp");
            if (!this.invariantsMatch(base2, resp)) continue;
            return false;
        }
        if (req.getLearnBoring() != 0) {
            SafeResponseVariations base3 = (SafeResponseVariations)CollectionsKt.getOrNull((List)this.baselines, req.getLearnBoring() - 1);
            if (base3 == null) {
                base3 = new SafeResponseVariations();
                this.baselines.add(base3);
            }
            base3.updateWith(response);
            this.reinvokeCallbacks();
            return false;
        }
        if (this.baselines.isEmpty()) {
            return true;
        }
        return true;
    }

    public final boolean shouldRetry(@NotNull Request req) {
        Intrinsics.checkNotNullParameter(req, "req");
        if (this.getMaxRetriesPerRequest() < 1) {
            this.permaFails.getAndIncrement();
            return false;
        }
        int reqID = req.getId();
        AtomicInteger fails = this.failedWords.get(reqID);
        if (fails == null) {
            Map map = this.failedWords;
            Integer n = reqID;
            AtomicInteger atomicInteger = new AtomicInteger(1);
            boolean bl = false;
            map.put(n, atomicInteger);
        } else if (fails.incrementAndGet() > this.getMaxRetriesPerRequest()) {
            this.permaFails.getAndIncrement();
            Utils.out(Intrinsics.stringPlus("Skipping word due to multiple failures: ", reqID));
            return false;
        }
        this.retries.getAndIncrement();
        return true;
    }

    public final void clearErrors() {
        this.failedWords.clear();
    }

    private final boolean invariantsMatch(SafeResponseVariations base2, IResponseVariations resp) {
        List<String> invariants = base2.getInvariantAttributes();
        for (String attribute : invariants) {
            if (base2.getAttributeValue(attribute) == resp.getAttributeValue(attribute, 0)) continue;
            return false;
        }
        return true;
    }
}

