/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.BurpRequest;
import burp.Floodgate;
import burp.IHttpRequestResponse;
import burp.IResponseVariations;
import burp.RequestEngine;
import burp.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010i\u001a\u00020\tJ\u000e\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020kJ\u000e\u0010j\u001a\u00020\u00032\u0006\u0010l\u001a\u00020\u0003J\u0010\u0010m\u001a\u0004\u0018\u00010\u00012\u0006\u0010n\u001a\u00020\u0003J\u0006\u0010o\u001a\u00020pJ\u0016\u0010q\u001a\u00020r2\u0006\u0010l\u001a\u00020k2\u0006\u0010s\u001a\u00020\u0003J\u0006\u0010t\u001a\u00020\u0003J\u0006\u0010u\u001a\u00020kJ\b\u0010v\u001a\u0004\u0018\u00010kJ\u000e\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020\u001eJ\u001e\u0010z\u001a\u00020k2\u0006\u0010l\u001a\u00020k2\u0006\u0010s\u001a\u00020\u00032\u0006\u0010{\u001a\u00020\u0003J\u0010\u0010|\u001a\u00020k2\b\u0010}\u001a\u0004\u0018\u00010\u0003R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u001aj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001`\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0016\"\u0004\b.\u0010\u0018R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010%\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010%R\u0011\u0010M\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010%R\u001a\u0010O\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010%\"\u0004\bQ\u0010CR\u001a\u0010R\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010%\"\u0004\bT\u0010CR \u0010U\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010%\"\u0004\b\\\u0010CR\u001c\u0010]\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010J\"\u0004\b_\u0010\u0004R\u0011\u0010`\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010JR\u001a\u0010c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u0016\"\u0004\be\u0010\u0018R\u0011\u0010f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010%R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010W\u00a8\u0006~"}, d2={"Lburp/Request;", "", "template", "", "(Ljava/lang/String;)V", "words", "", "(Ljava/lang/String;Ljava/util/List;)V", "learnBoring", "", "(Ljava/lang/String;Ljava/util/List;I)V", "label", "(Ljava/lang/String;Ljava/util/List;ILjava/lang/String;)V", "_engine", "Lburp/RequestEngine;", "get_engine", "()Lburp/RequestEngine;", "set_engine", "(Lburp/RequestEngine;)V", "arrival", "", "getArrival", "()J", "setArrival", "(J)V", "attributes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "callback", "Lkotlin/Function2;", "", "getCallback", "()Lkotlin/jvm/functions/Function2;", "setCallback", "(Lkotlin/jvm/functions/Function2;)V", "code", "getCode", "()I", "connectionID", "getConnectionID", "()Ljava/lang/Integer;", "setConnectionID", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "delayCompletion", "getDelayCompletion", "setDelayCompletion", "details", "Lburp/IResponseVariations;", "getDetails", "()Lburp/IResponseVariations;", "setDetails", "(Lburp/IResponseVariations;)V", "engine", "getEngine", "()Ljava/lang/Object;", "setEngine", "(Ljava/lang/Object;)V", "gate", "Lburp/Floodgate;", "getGate", "()Lburp/Floodgate;", "setGate", "(Lburp/Floodgate;)V", "id", "getId", "setId", "(I)V", "interesting", "getInteresting", "()Z", "setInteresting", "(Z)V", "getLabel", "()Ljava/lang/String;", "setLabel", "getLearnBoring", "length", "getLength", "order", "getOrder", "setOrder", "pauseBefore", "getPauseBefore", "setPauseBefore", "pauseMarkers", "getPauseMarkers", "()Ljava/util/List;", "setPauseMarkers", "(Ljava/util/List;)V", "pauseTime", "getPauseTime", "setPauseTime", "response", "getResponse", "setResponse", "status", "getStatus", "getTemplate", "time", "getTime", "setTime", "wordcount", "getWordcount", "getWords", "calculateCode", "fixContentLength", "", "request", "getAttribute", "name", "getBurpRequest", "Lburp/IHttpRequestResponse;", "getHeaderOffsets", "", "header", "getRequest", "getRequestAsBytes", "getResponseAsBytes", "invokeCallback", "", "isinteresting", "setHeader", "value", "stringToBytes", "string", "turbo-intruder"})
public class Request {
    @NotNull
    private final String template;
    @NotNull
    private final List<String> words;
    private final int learnBoring;
    @Nullable
    private String label;
    @Nullable
    private String response;
    @Nullable
    private IResponseVariations details;
    private boolean interesting;
    @Nullable
    private RequestEngine _engine;
    @Nullable
    private Object engine;
    @Nullable
    private Integer connectionID;
    @Nullable
    private Function2<? super Request, ? super Boolean, Boolean> callback;
    @Nullable
    private Floodgate gate;
    private int order;
    private long time;
    private long arrival;
    private int id;
    private int pauseBefore;
    private int pauseTime;
    @NotNull
    private List<String> pauseMarkers;
    private long delayCompletion;
    @NotNull
    private final HashMap<String, Object> attributes;

    public Request(@NotNull String template, @NotNull List<String> words, int learnBoring, @Nullable String label) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(words, "words");
        this.template = template;
        this.words = words;
        this.learnBoring = learnBoring;
        this.label = label;
        this.id = -1;
        this.pauseTime = 1000;
        this.pauseMarkers = CollectionsKt.emptyList();
        this.attributes = new HashMap();
    }

    @NotNull
    public final String getTemplate() {
        return this.template;
    }

    @NotNull
    public final List<String> getWords() {
        return this.words;
    }

    public final int getLearnBoring() {
        return this.learnBoring;
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@Nullable String string2) {
        this.label = string2;
    }

    @Nullable
    public final String getResponse() {
        return this.response;
    }

    public final void setResponse(@Nullable String string2) {
        this.response = string2;
    }

    @Nullable
    public final IResponseVariations getDetails() {
        return this.details;
    }

    public final void setDetails(@Nullable IResponseVariations iResponseVariations) {
        this.details = iResponseVariations;
    }

    public final boolean getInteresting() {
        return this.interesting;
    }

    public final void setInteresting(boolean bl) {
        this.interesting = bl;
    }

    @Nullable
    public final RequestEngine get_engine() {
        return this._engine;
    }

    public final void set_engine(@Nullable RequestEngine requestEngine) {
        this._engine = requestEngine;
    }

    @Nullable
    public final Object getEngine() {
        return this.engine;
    }

    public final void setEngine(@Nullable Object object) {
        this.engine = object;
    }

    @Nullable
    public final Integer getConnectionID() {
        return this.connectionID;
    }

    public final void setConnectionID(@Nullable Integer n) {
        this.connectionID = n;
    }

    @Nullable
    public final Function2<Request, Boolean, Boolean> getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable Function2<? super Request, ? super Boolean, Boolean> function2) {
        this.callback = function2;
    }

    @Nullable
    public final Floodgate getGate() {
        return this.gate;
    }

    public final void setGate(@Nullable Floodgate floodgate) {
        this.gate = floodgate;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int n) {
        this.order = n;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final long getArrival() {
        return this.arrival;
    }

    public final void setArrival(long l) {
        this.arrival = l;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final int getPauseBefore() {
        return this.pauseBefore;
    }

    public final void setPauseBefore(int n) {
        this.pauseBefore = n;
    }

    public final int getPauseTime() {
        return this.pauseTime;
    }

    public final void setPauseTime(int n) {
        this.pauseTime = n;
    }

    @NotNull
    public final List<String> getPauseMarkers() {
        return this.pauseMarkers;
    }

    public final void setPauseMarkers(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.pauseMarkers = list;
    }

    public final long getDelayCompletion() {
        return this.delayCompletion;
    }

    public final void setDelayCompletion(long l) {
        this.delayCompletion = l;
    }

    public final int getCode() {
        Object object = this.getAttribute("code");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    public final int getStatus() {
        return this.getCode();
    }

    public final int getLength() {
        Object object = this.getAttribute("length");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    public final int getWordcount() {
        Object object = this.getAttribute("wordcount");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object;
    }

    public final void invokeCallback(boolean isinteresting) {
        if (this.callback != null) {
            Function2<? super Request, ? super Boolean, Boolean> function2 = this.callback;
            Intrinsics.checkNotNull(function2);
            function2.invoke(this, (Boolean)isinteresting);
        } else {
            RequestEngine requestEngine = this._engine;
            Intrinsics.checkNotNull(requestEngine);
            requestEngine.getCallback().invoke(this, isinteresting);
        }
    }

    @Nullable
    public final Object getAttribute(@NotNull String name) {
        Object object;
        block15: {
            Object value$iv;
            block13: {
                Object object2;
                Intrinsics.checkNotNullParameter(name, "name");
                Map $this$getOrPut$iv = this.attributes;
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(name);
                if (value$iv != null) break block13;
                boolean bl = false;
                switch (name) {
                    case "length": {
                        int n;
                        String string2 = this.getResponse();
                        object2 = string2 == null ? 0 : (n = string2.length());
                        break;
                    }
                    case "wordcount": {
                        CharSequence charSequence = this.getResponse();
                        charSequence = charSequence == null ? "" : charSequence;
                        Regex regex = new Regex("[^a-zA-Z0-9]");
                        int n = 0;
                        boolean bl2 = false;
                        object2 = regex.split(charSequence, n).size();
                        break;
                    }
                    case "code": {
                        object2 = this.calculateCode();
                        break;
                    }
                    default: {
                        object2 = "Unknown attribute";
                    }
                }
                String answer$iv = object2;
                $this$getOrPut$iv.put(name, answer$iv);
                object = answer$iv;
                break block15;
            }
            object = value$iv;
        }
        return object;
    }

    public final int calculateCode() {
        if (this.response == null) {
            return 0;
        }
        try {
            String string2;
            String string3 = this.response;
            Intrinsics.checkNotNull(string3);
            if (StringsKt.startsWith$default(string3, ":status", false, 2, null)) {
                String string4 = this.response;
                Intrinsics.checkNotNull(string4);
                String[] stringArray = new String[]{" ", "\r", "\n"};
                return Integer.parseInt((String)StringsKt.split$default((CharSequence)string4, stringArray, false, 3, 2, null).get(1));
            }
            String string5 = this.response;
            if (string5 == null) {
                string2 = null;
            } else {
                String[] stringArray = new String[]{" "};
                List<String> list = StringsKt.split((CharSequence)string5, stringArray, false, 3);
                string2 = list == null ? null : list.get(1);
            }
            return Integer.parseInt(string2);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Request(@NotNull String template) {
        Intrinsics.checkNotNullParameter(template, "template");
        this(template, CollectionsKt.emptyList(), 0, null);
    }

    public Request(@NotNull String template, @NotNull List<String> words) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(words, "words");
        this(template, words, 0, null);
    }

    public Request(@NotNull String template, @NotNull List<String> words, int learnBoring) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(words, "words");
        this(template, words, learnBoring, null);
    }

    @NotNull
    public final IHttpRequestResponse getBurpRequest() {
        return new BurpRequest(this);
    }

    @NotNull
    public final String getRequest() {
        if (this.words.isEmpty()) {
            return this.fixContentLength(this.template);
        }
        if (!StringsKt.contains$default((CharSequence)this.template, "%s", false, 2, null)) {
            Utils.out("Bad base request - nowhere to inject payload");
        }
        String req = this.template;
        for (String w : this.words) {
            req = StringsKt.replaceFirst(req, "%s", String.valueOf(w), false);
        }
        if (StringsKt.contains$default((CharSequence)req, "%s", false, 2, null)) {
            Utils.out("Bad base request " + this.words.size() + " words and more %s");
        }
        return this.fixContentLength(req);
    }

    @NotNull
    public final byte[] stringToBytes(@Nullable String string2) {
        byte[] byArray;
        if (Utils.helpers != null) {
            byte[] byArray2 = Utils.helpers.stringToBytes(string2);
            Intrinsics.checkNotNullExpressionValue(byArray2, "helpers.stringToBytes(string)");
            return byArray2;
        }
        String string3 = string2;
        if (string3 == null) {
            byArray = null;
        } else {
            String string4 = string3;
            Charset charset2 = Charsets.ISO_8859_1;
            boolean bl = false;
            byte[] byArray3 = string4.getBytes(charset2);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue(byArray3, "(this as java.lang.String).getBytes(charset)");
        }
        byte[] byArray4 = byArray;
        return byArray4 == null ? new byte[]{} : byArray4;
    }

    @NotNull
    public final byte[] getRequestAsBytes() {
        return this.fixContentLength(this.stringToBytes(this.getRequest()));
    }

    @Nullable
    public final byte[] getResponseAsBytes() {
        return this.stringToBytes(this.response);
    }

    @NotNull
    public final String fixContentLength(@NotNull String request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Object object = request;
        Charset charset2 = Charsets.ISO_8859_1;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        object = this.fixContentLength(byArray);
        boolean bl2 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    @NotNull
    public final byte[] fixContentLength(@NotNull byte[] request) {
        Intrinsics.checkNotNullParameter(request, "request");
        boolean bl = false;
        String string2 = Utils.getHeaders(new String(request, Charsets.UTF_8));
        Intrinsics.checkNotNullExpressionValue(string2, "getHeaders(String(request))");
        if (StringsKt.contains$default((CharSequence)string2, "Content-Length: ", false, 2, null)) {
            int start = Utils.getBodyStart(request);
            int contentLength = request.length - start;
            try {
                String string3 = Integer.toString(contentLength);
                Intrinsics.checkNotNullExpressionValue(string3, "toString(contentLength)");
                return this.setHeader(request, "Content-Length", string3);
            }
            catch (RuntimeException e) {
                return request;
            }
        }
        return request;
    }

    @NotNull
    public final byte[] setHeader(@NotNull byte[] request, @NotNull String header2, @NotNull String value) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(header2, "header");
        Intrinsics.checkNotNullParameter(value, "value");
        int[] offsets = this.getHeaderOffsets(request, header2);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(Arrays.copyOfRange(request, 0, offsets[1]));
            Object object = value;
            Charset charset2 = Charsets.ISO_8859_1;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            outputStream.write(byArray);
            outputStream.write(Arrays.copyOfRange(request, offsets[2], request.length));
            object = outputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue(object, "outputStream.toByteArray()");
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("Request creation unexpectedly failed");
        }
        catch (NullPointerException e) {
            Utils.out(Intrinsics.stringPlus("header locating fail: ", header2));
            throw new RuntimeException("Can't find the header");
        }
    }

    @NotNull
    public final int[] getHeaderOffsets(@NotNull byte[] request, @NotNull String header2) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(header2, "header");
        int i = 0;
        int end = request.length;
        while (i < end) {
            int line_start = i;
            int n = 32;
            boolean bl = false;
            if (request[i] == (byte)n) {
                n = i;
                i = n + 1;
            }
            while (i < end) {
                n = i;
                i = n + 1;
                byte by = request[n];
                n = 32;
                bl = false;
                if (by != (byte)n) continue;
            }
            byte[] byArray = request;
            int n2 = i - 2;
            int n3 = 0;
            byte[] header_name = ArraysKt.copyOfRange(byArray, line_start, n2);
            int headerValueStart = i;
            while (i < end) {
                n2 = i;
                i = n2 + 1;
                byte by = request[n2];
                n2 = 10;
                n3 = 0;
                if (by != (byte)n2) continue;
            }
            if (i == end) break;
            n3 = 0;
            String header_str = new String(header_name, Charsets.UTF_8);
            if (Intrinsics.areEqual(header2, header_str)) {
                int[] nArray = new int[]{line_start, headerValueStart, i - 2};
                return nArray;
            }
            if (i + 2 >= end) continue;
            n3 = 13;
            boolean bl2 = false;
            if (request[i] != (byte)n3) continue;
            n3 = 10;
            bl2 = false;
            if (request[i + 1] != (byte)n3) continue;
        }
        throw new RuntimeException("Couldn't find header: '" + header2 + '\'');
    }
}

