/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.H2Connection;
import burp.Request;
import burp.RequestEngine;
import burp.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\f\u0012\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J9\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u00032\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030(2\b\u0010)\u001a\u0004\u0018\u00010\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0005H\u0016R&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001c\"\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001c\u00a8\u00060"}, d2={"Lburp/HTTP2RequestEngine;", "Lburp/RequestEngine;", "url", "", "threads", "", "maxQueueSize", "requestsPerConnection", "maxRetriesPerRequest", "idleTimeout", "", "callback", "Lkotlin/Function2;", "Lburp/Request;", "", "readCallback", "Lkotlin/Function1;", "(Ljava/lang/String;IIIIJLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function2;", "connectionPool", "Ljava/util/ArrayList;", "Lburp/H2Connection;", "getIdleTimeout", "()J", "setIdleTimeout", "(J)V", "getMaxRetriesPerRequest", "()I", "getReadCallback", "()Lkotlin/jvm/functions/Function1;", "setReadCallback", "(Lkotlin/jvm/functions/Function1;)V", "getRequestsPerConnection", "setRequestsPerConnection", "(I)V", "getThreads", "buildRequest", "template", "payloads", "", "learnBoring", "label", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;)Lburp/Request;", "manageConnections", "", "start", "timeout", "turbo-intruder"})
public class HTTP2RequestEngine
extends RequestEngine {
    private final int threads;
    private int requestsPerConnection;
    private final int maxRetriesPerRequest;
    private long idleTimeout;
    @NotNull
    private final Function2<Request, Boolean, Boolean> callback;
    @Nullable
    private Function1<? super String, Boolean> readCallback;
    @NotNull
    private final ArrayList<H2Connection> connectionPool;

    public HTTP2RequestEngine(@NotNull String url, int threads, int maxQueueSize, int requestsPerConnection, int maxRetriesPerRequest, long idleTimeout, @NotNull Function2<? super Request, ? super Boolean, Boolean> callback, @Nullable Function1<? super String, Boolean> readCallback) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.threads = threads;
        this.requestsPerConnection = requestsPerConnection;
        this.maxRetriesPerRequest = maxRetriesPerRequest;
        this.idleTimeout = idleTimeout;
        this.callback = callback;
        this.readCallback = readCallback;
        this.connectionPool = new ArrayList(this.threads);
        this.setRequestQueue(maxQueueSize > 0 ? new LinkedBlockingQueue<Request>(maxQueueSize) : new LinkedBlockingQueue());
        this.setTarget(new URL(url));
        this.setCompletedLatch(new CountDownLatch(this.threads));
        int n = 1;
        int n2 = this.threads;
        if (n <= n2) {
            int j;
            do {
                j = n++;
                this.getConnections().incrementAndGet();
                this.connectionPool.add(new H2Connection(this.getTarget(), new LinkedBlockingQueue(1), this.getRequestQueue(), this.requestsPerConnection, this));
            } while (j != n2);
        }
        ThreadsKt.thread$default(false, false, null, null, 1, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.manageConnections();
            }
        }, 15, null);
    }

    public /* synthetic */ HTTP2RequestEngine(String string2, int n, int n2, int n3, int n4, long l, Function2 function2, Function1 function1, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x20) != 0) {
            l = 0L;
        }
        this(string2, n, n2, n3, n4, l, function2, function1);
    }

    public final int getThreads() {
        return this.threads;
    }

    public final int getRequestsPerConnection() {
        return this.requestsPerConnection;
    }

    public final void setRequestsPerConnection(int n) {
        this.requestsPerConnection = n;
    }

    @Override
    public int getMaxRetriesPerRequest() {
        return this.maxRetriesPerRequest;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long l) {
        this.idleTimeout = l;
    }

    @Override
    @NotNull
    public Function2<Request, Boolean, Boolean> getCallback() {
        return this.callback;
    }

    @Override
    @Nullable
    public Function1<String, Boolean> getReadCallback() {
        return this.readCallback;
    }

    @Override
    public void setReadCallback(@Nullable Function1<? super String, Boolean> function1) {
        this.readCallback = function1;
    }

    private final void manageConnections() {
        H2Connection.Companion.debug("Connection management thread starting");
        while (this.getAttackState().get() < 3) {
            int n = 1;
            int n2 = this.threads;
            if (n <= n2) {
                int i;
                do {
                    i = n++;
                    H2Connection h2Connection = this.connectionPool.get(i - 1);
                    Intrinsics.checkNotNullExpressionValue(h2Connection, "connectionPool[i - 1]");
                    H2Connection con = h2Connection;
                    if (con.getDone() || con.getState() != 4 || !con.hasInflightRequests() && con.getSeedQueue().size() <= 0 && this.getAttackState().get() >= 3) continue;
                    LinkedBlockingQueue seedQueue = new LinkedBlockingQueue();
                    if (con.hasInflightRequests()) {
                        List<Request> inflight = con.getInflightRequests();
                        if (this.getRetries().get() < this.getMaxRetriesPerRequest()) {
                            seedQueue.addAll(inflight);
                            this.getRetries().getAndIncrement();
                            Utils.out("Connection died, re-queueing " + inflight.size() + " unanswered requests.");
                        } else {
                            this.getPermaFails().addAndGet(inflight.size());
                        }
                    }
                    seedQueue.addAll(con.getSeedQueue());
                    this.getConnections().incrementAndGet();
                    this.connectionPool.set(i - 1, new H2Connection(this.getTarget(), seedQueue, this.getRequestQueue(), this.requestsPerConnection, this));
                } while (i != n2);
            }
            Thread.sleep(10L);
        }
        H2Connection.Companion.debug("Connection management thread exiting");
    }

    @Override
    public void start(int timeout) {
        this.getAttackState().set(1);
        this.setStart(System.nanoTime());
    }

    @Override
    @NotNull
    public Request buildRequest(@NotNull String template, @NotNull List<String> payloads, @Nullable Integer learnBoring, @Nullable String label) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(payloads, "payloads");
        Integer n = learnBoring;
        return new Request(template, payloads, n == null ? 0 : n, label);
    }
}

