/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.Frame;
import burp.HTTP2Request;
import burp.HTTP2RequestEngine;
import burp.HTTP2Utils;
import burp.Request;
import burp.Stream;
import burp.Utils;
import com.twitter.hpack.Decoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 P2\u00020\u0001:\u0002PQB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u0006H\u0002J\b\u0010>\u001a\u00020\nH\u0002J\u0006\u0010?\u001a\u00020@J\b\u0010A\u001a\u00020@H\u0002J\b\u0010B\u001a\u00020CH\u0002J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00060EJ\u0006\u0010F\u001a\u00020\u0013J\u0010\u0010G\u001a\u00020@2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020@H\u0002J\u0010\u0010=\u001a\u00020@2\u0006\u0010=\u001a\u00020\u0006H\u0002J\u000e\u0010K\u001a\u00020@2\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020@J\b\u0010O\u001a\u00020@H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u000e\u0010\"\u001a\u00020#X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001c\"\u0004\b,\u0010\u001eR\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R-\u00101\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020302j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000203`4\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001a\u00109\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001c\"\u0004\b;\u0010\u001e\u00a8\u0006R"}, d2={"Lburp/H2Connection;", "", "target", "Ljava/net/URL;", "seedQueue", "Ljava/util/Queue;", "Lburp/Request;", "requestQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "requestsPerConnection", "", "engine", "Lburp/HTTP2RequestEngine;", "(Ljava/net/URL;Ljava/util/Queue;Ljava/util/concurrent/LinkedBlockingQueue;ILburp/HTTP2RequestEngine;)V", "decoder", "Lcom/twitter/hpack/Decoder;", "getDecoder", "()Lcom/twitter/hpack/Decoder;", "done", "", "getDone", "()Z", "setDone", "(Z)V", "getEngine", "()Lburp/HTTP2RequestEngine;", "lastCreatedStreamID", "getLastCreatedStreamID", "()I", "setLastCreatedStreamID", "(I)V", "maxConcurrentStreams", "getMaxConcurrentStreams", "setMaxConcurrentStreams", "output", "Ljava/io/OutputStream;", "getRequestsPerConnection", "setRequestsPerConnection", "getSeedQueue", "()Ljava/util/Queue;", "socket", "Ljava/net/Socket;", "state", "getState", "setState", "stateLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getStateLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "streams", "Ljava/util/HashMap;", "Lburp/Stream;", "Lkotlin/collections/HashMap;", "getStreams", "()Ljava/util/HashMap;", "getTarget", "()Ljava/net/URL;", "totalQueuedRequests", "getTotalQueuedRequests", "setTotalQueuedRequests", "addStream", "req", "checkState", "close", "", "connect", "createSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getInflightRequests", "", "hasInflightRequests", "passResponseToStream", "frameBytes", "", "readForever", "sendFrame", "frame", "Lburp/Frame;", "startSendingRequests", "writeForever", "Companion", "TrustingTrustManager", "turbo-intruder"})
public final class H2Connection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL target;
    @NotNull
    private final Queue<Request> seedQueue;
    @NotNull
    private final LinkedBlockingQueue<Request> requestQueue;
    private int requestsPerConnection;
    @NotNull
    private final HTTP2RequestEngine engine;
    private boolean done;
    @NotNull
    private final HashMap<Integer, Stream> streams;
    private int totalQueuedRequests;
    private Socket socket;
    private OutputStream output;
    @NotNull
    private final Decoder decoder;
    private int maxConcurrentStreams;
    @NotNull
    private final ReentrantReadWriteLock stateLock;
    private int state;
    private int lastCreatedStreamID;
    public static final int CONNECTING = 1;
    public static final int ALIVE = 2;
    public static final int HALFCLOSED = 3;
    public static final int CLOSED = 4;
    private static final boolean DEBUG = false;

    public H2Connection(@NotNull URL target, @NotNull Queue<Request> seedQueue, @NotNull LinkedBlockingQueue<Request> requestQueue, int requestsPerConnection, @NotNull HTTP2RequestEngine engine) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(seedQueue, "seedQueue");
        Intrinsics.checkNotNullParameter(requestQueue, "requestQueue");
        Intrinsics.checkNotNullParameter(engine, "engine");
        this.target = target;
        this.seedQueue = seedQueue;
        this.requestQueue = requestQueue;
        this.requestsPerConnection = requestsPerConnection;
        this.engine = engine;
        this.streams = new HashMap();
        this.decoder = new Decoder(4096, 4096);
        this.maxConcurrentStreams = 100;
        this.stateLock = new ReentrantReadWriteLock();
        this.state = 1;
        this.lastCreatedStreamID = -1;
        this.connect();
    }

    @NotNull
    public final URL getTarget() {
        return this.target;
    }

    @NotNull
    public final Queue<Request> getSeedQueue() {
        return this.seedQueue;
    }

    public final int getRequestsPerConnection() {
        return this.requestsPerConnection;
    }

    public final void setRequestsPerConnection(int n) {
        this.requestsPerConnection = n;
    }

    @NotNull
    public final HTTP2RequestEngine getEngine() {
        return this.engine;
    }

    public final boolean getDone() {
        return this.done;
    }

    public final void setDone(boolean bl) {
        this.done = bl;
    }

    @NotNull
    public final HashMap<Integer, Stream> getStreams() {
        return this.streams;
    }

    public final int getTotalQueuedRequests() {
        return this.totalQueuedRequests;
    }

    public final void setTotalQueuedRequests(int n) {
        this.totalQueuedRequests = n;
    }

    @NotNull
    public final Decoder getDecoder() {
        return this.decoder;
    }

    public final int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public final void setMaxConcurrentStreams(int n) {
        this.maxConcurrentStreams = n;
    }

    @NotNull
    public final ReentrantReadWriteLock getStateLock() {
        return this.stateLock;
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getLastCreatedStreamID() {
        return this.lastCreatedStreamID;
    }

    public final void setLastCreatedStreamID(int n) {
        this.lastCreatedStreamID = n;
    }

    private final void connect() {
        Object object;
        Socket socket2;
        Object clientAPs;
        Object sslp;
        Object sslsf;
        int port;
        int n = port = this.target.getPort() == -1 ? this.target.getDefaultPort() : this.target.getPort();
        if (Intrinsics.areEqual(this.target.getProtocol(), "https")) {
            Object object2;
            Object object3;
            Object object4;
            Socket socket3;
            sslsf = this.createSSLSocketFactory();
            this.target.getPort();
            Socket socket4 = ((SocketFactory)sslsf).createSocket(this.target.getHost(), port);
            if (socket4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
            }
            this.socket = (SSLSocket)socket4;
            Socket socket5 = this.socket;
            if (socket5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                socket3 = null;
            } else {
                socket3 = socket5;
            }
            sslp = ((SSLSocket)socket3).getSSLParameters();
            Object object5 = new String[]{"h2"};
            clientAPs = object5;
            ((SSLParameters)sslp).setApplicationProtocols((String[])clientAPs);
            object5 = this.socket;
            if (object5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                object4 = null;
            } else {
                object4 = object5;
            }
            ((SSLSocket)object4).setSSLParameters((SSLParameters)sslp);
            object5 = this.socket;
            if (object5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                object3 = null;
            } else {
                object3 = object5;
            }
            ((SSLSocket)object3).startHandshake();
            object5 = this.socket;
            if (object5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                object2 = null;
            } else {
                object2 = object5;
            }
            ((Socket)object2).setSoTimeout(10000);
        } else {
            Object object6;
            this.socket = new Socket(this.target.getHost(), port);
            sslsf = this.socket;
            if (sslsf == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                object6 = null;
            } else {
                object6 = sslsf;
            }
            ((Socket)object6).setSoTimeout(10000);
        }
        sslp = this.socket;
        if (sslp == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            socket2 = null;
        } else {
            socket2 = sslp;
        }
        sslsf = socket2.getOutputStream();
        Intrinsics.checkNotNullExpressionValue(sslsf, "socket.outputStream");
        this.output = sslsf;
        String message2 = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
        sslp = this.output;
        if (sslp == null) {
            Intrinsics.throwUninitializedPropertyAccessException("output");
            object = null;
        } else {
            object = sslp;
        }
        sslp = message2;
        clientAPs = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = ((String)sslp).getBytes((Charset)clientAPs);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        ((OutputStream)object).write(byArray);
        clientAPs = new byte[24];
        clientAPs[0] = (String)false;
        clientAPs[1] = (String)4;
        clientAPs[2] = (String)127;
        clientAPs[3] = (String)-1;
        clientAPs[4] = (String)-1;
        clientAPs[5] = (String)-1;
        clientAPs[6] = (String)false;
        clientAPs[7] = (String)2;
        clientAPs[8] = (String)false;
        clientAPs[9] = (String)false;
        clientAPs[10] = (String)false;
        clientAPs[11] = (String)false;
        clientAPs[12] = (String)false;
        clientAPs[13] = (String)true;
        clientAPs[14] = (String)false;
        clientAPs[15] = (String)false;
        clientAPs[16] = (String)16;
        clientAPs[17] = (String)false;
        clientAPs[18] = (String)false;
        clientAPs[19] = (String)3;
        clientAPs[20] = (String)false;
        clientAPs[21] = (String)false;
        clientAPs[22] = (String)true;
        clientAPs[23] = (String)false;
        Object settingsPayload = clientAPs;
        Frame initialSettingsFrame = new Frame(4, 0, 0, (byte[])settingsPayload);
        this.sendFrame(initialSettingsFrame);
        Frame flowControlFrame = new Frame(8, 0, 0, HTTP2Utils.Companion.intToFourBytes(0x7FFF0000));
        this.sendFrame(flowControlFrame);
        ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this){
            final /* synthetic */ H2Connection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                H2Connection.access$readForever(this.this$0);
            }
        }, 31, null);
    }

    public final void startSendingRequests() {
        if (this.state != 1) {
            return;
        }
        this.state = 2;
        ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(this){
            final /* synthetic */ H2Connection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                H2Connection.access$writeForever(this.this$0);
            }
        }, 31, null);
    }

    private final int checkState() {
        if (this.engine.getAttackState().get() >= 3) {
            this.close();
        }
        return this.state;
    }

    private final void req(Request req) {
        HTTP2Request parsedRequest = new HTTP2Request(req.getRequest());
        LinkedList<Pair<String, String>> built = Companion.buildReq(parsedRequest);
        HeaderEncoder encoder2 = new HeaderEncoder();
        for (Pair object2 : built) {
            String key = (String)object2.component1();
            String value = (String)object2.component2();
            encoder2.addHeader(key, value);
        }
        int streamID = this.addStream(req);
        if (parsedRequest.getBody() == null || Intrinsics.areEqual(parsedRequest.getBody(), "")) {
            req.setTime(System.nanoTime());
            byte[] byArray = encoder2.getHeaders().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "encoder.headers.toByteArray()");
            this.sendFrame(new Frame(1, 5, streamID, byArray));
        } else {
            byte[] byArray = encoder2.getHeaders().toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "encoder.headers.toByteArray()");
            this.sendFrame(new Frame(1, 4, streamID, byArray));
            req.setTime(System.nanoTime());
            String string2 = parsedRequest.getBody();
            Intrinsics.checkNotNull(string2);
            String string3 = string2;
            Charset charset2 = Charsets.UTF_8;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string4.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue(byArray2, "(this as java.lang.String).getBytes(charset)");
            this.sendFrame(new Frame(0, 1, streamID, byArray2));
        }
    }

    public final void close() {
        Companion.debug("Closing connection...");
        boolean locked = this.stateLock.writeLock().tryLock(5L, TimeUnit.SECONDS);
        if (!locked) {
            throw new Exception(Intrinsics.stringPlus("Deadlock closing connection: ", this.stateLock.getReadLockCount()));
        }
        this.state = 4;
        this.stateLock.writeLock().unlock();
        Companion.debug("Full close complete");
    }

    private final void readForever() {
        try {
            Socket socket2;
            Socket socket3 = this.socket;
            if (socket3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                socket2 = null;
            } else {
                socket2 = socket3;
            }
            InputStream input = socket2.getInputStream();
            while (this.checkState() != 4) {
                if (this.state == 3 && !this.hasInflightRequests()) {
                    Companion.debug("Transitioning halfclosed connection to closed");
                    this.close();
                    return;
                }
                Companion.debug("Reading...");
                if (this.streams.size() == 0 && this.state != 1) {
                    Thread.sleep(100L);
                    continue;
                }
                byte[] sizeBuffer = new byte[3];
                try {
                    int needToRead = 3;
                    int haveRead = 0;
                    while (haveRead < needToRead) {
                        if (this.checkState() == 4) {
                            return;
                        }
                        int justRead = input.read(sizeBuffer, haveRead, needToRead - haveRead);
                        if (justRead == -1) {
                            Thread.sleep(10L);
                            continue;
                        }
                        haveRead += justRead;
                    }
                }
                catch (SocketTimeoutException ex) {
                    if (this.hasInflightRequests()) {
                        Utils.out("Socket read timeout with ~" + this.streams.size() + " inflight requests");
                        Utils.out(this.streams.keySet().toString());
                    }
                    this.close();
                    return;
                }
                catch (SSLProtocolException ex) {
                    Utils.out("Invoking fullClose due to socket read error");
                    this.close();
                    return;
                }
                int size = HTTP2Utils.Companion.threeByteInt(sizeBuffer);
                int needToRead = size + 6;
                byte[] frameBuffer = new byte[needToRead];
                int haveRead = 0;
                while (haveRead < needToRead) {
                    if (this.checkState() == 4) {
                        return;
                    }
                    int justRead = input.read(frameBuffer, haveRead, needToRead - haveRead);
                    if (justRead == -1) {
                        Thread.sleep(10L);
                        continue;
                    }
                    haveRead += justRead;
                }
                this.passResponseToStream(ArraysKt.plus(sizeBuffer, frameBuffer));
            }
        }
        catch (Exception e) {
            Utils.out("Killing read thread");
            this.close();
        }
        Companion.debug("Closing read thread...");
    }

    private final void passResponseToStream(byte[] frameBytes) {
        int streamID = HTTP2Utils.Companion.fourByteInt(ArraysKt.sliceArray(frameBytes, new IntRange(5, 8)));
        if (streamID != 0 && !this.streams.containsKey(streamID)) {
            throw new Exception("Received message on unrecognised or closed stream: " + streamID + " | " + this.lastCreatedStreamID);
        }
        this.streams.putIfAbsent(streamID, new Stream(this, streamID, new Request("dud"), true));
        Stream stream = this.streams.get(streamID);
        Intrinsics.checkNotNull(stream);
        stream.processFrame(frameBytes);
    }

    private final void writeForever() {
        Companion.debug("Starting write thread");
        try {
            boolean completedSeedQueue = false;
            while (this.state == 2 && this.engine.getAttackState().get() < 3) {
                if (this.streams.size() >= this.maxConcurrentStreams) {
                    Thread.sleep(100L);
                    continue;
                }
                if (this.totalQueuedRequests >= this.requestsPerConnection) {
                    this.state = 3;
                    return;
                }
                Request req = null;
                if (completedSeedQueue) {
                    req = this.requestQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (req == null) {
                        if (this.engine.getAttackState().get() != 2 || this.hasInflightRequests()) continue;
                        this.close();
                        this.done = true;
                        this.engine.getCompletedLatch().countDown();
                        return;
                    }
                } else {
                    req = this.seedQueue.poll();
                    if (req == null) {
                        completedSeedQueue = true;
                        continue;
                    }
                }
                if (this.state == 4) {
                    this.requestQueue.put(req);
                    this.close();
                    return;
                }
                try {
                    this.req(req);
                }
                catch (SocketException ex) {
                    this.requestQueue.put(req);
                    this.close();
                }
                catch (SSLProtocolException ex) {
                    this.requestQueue.put(req);
                    this.close();
                }
            }
        }
        catch (Exception e) {
            Utils.out("Killing write thread");
            this.close();
        }
        Companion.debug("Exiting write thread");
    }

    public final boolean hasInflightRequests() {
        if (this.streams.size() == 0) {
            return false;
        }
        if (this.streams.size() > 1) {
            return true;
        }
        return !this.streams.containsKey(0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Request> getInflightRequests() {
        void $this$mapTo$iv$iv;
        if (this.state != 4) {
            throw new Exception("Access to in-flight requests is hazardous on live connections");
        }
        Collection<Stream> collection = this.streams.values();
        Intrinsics.checkNotNullExpressionValue(collection, "streams.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Stream stream = (Stream)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Request request = it.getReq();
            collection2.add(request);
        }
        return (List)destination$iv$iv;
    }

    public final void sendFrame(@NotNull Frame frame) {
        Socket socket2;
        Socket socket3;
        Intrinsics.checkNotNullParameter(frame, "frame");
        Socket socket4 = this.socket;
        if (socket4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            socket3 = null;
        } else {
            socket3 = socket4;
        }
        socket3.getOutputStream().write(frame.asBytes());
        socket4 = this.socket;
        if (socket4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            socket2 = null;
        } else {
            socket2 = socket4;
        }
        socket2.getOutputStream().flush();
    }

    private final int addStream(Request req) {
        if (this.state == 4 || this.totalQueuedRequests > this.requestsPerConnection) {
            throw new SocketException("Attempt to create a stream on a dud connection");
        }
        H2Connection h2Connection = this;
        ++h2Connection.totalQueuedRequests;
        h2Connection = this;
        h2Connection.lastCreatedStreamID += 2;
        Stream stream = new Stream(this, this.lastCreatedStreamID, req, true);
        Map map = this.streams;
        Integer n = this.lastCreatedStreamID;
        boolean bl = false;
        map.put(n, stream);
        Companion.debug(Intrinsics.stringPlus("Sending on stream ", stream.getStreamID()));
        if (stream.getStreamID() % 2 == 0 && !this.streams.containsKey(stream.getStreamID())) {
            throw new Exception(Intrinsics.stringPlus("Client-initiated frames must have an odd ID. Not ", stream.getStreamID()));
        }
        return stream.getStreamID();
    }

    private final SSLSocketFactory createSSLSocketFactory() {
        SSLContext trustingSslContext = SSLContext.getInstance("TLS");
        Object object = new TrustManager[]{new TrustingTrustManager()};
        trustingSslContext.init(null, (TrustManager[])object, null);
        object = trustingSslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(object, "trustingSslContext.socketFactory");
        return object;
    }

    public static final /* synthetic */ void access$readForever(H2Connection $this) {
        $this.readForever();
    }

    public static final /* synthetic */ void access$writeForever(H2Connection $this) {
        $this.writeForever();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u001a\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lburp/H2Connection$Companion;", "", "()V", "ALIVE", "", "CLOSED", "CONNECTING", "DEBUG", "", "HALFCLOSED", "buildReq", "Ljava/util/LinkedList;", "Lkotlin/Pair;", "", "parsedRequest", "Lburp/HTTP2Request;", "transform", "debug", "", "message", "transformHeader", "value", "name", "turbo-intruder"})
    public static final class Companion {
        private Companion() {
        }

        public final void debug(@NotNull String message2) {
            Intrinsics.checkNotNullParameter(message2, "message");
        }

        private final String transformHeader(String value, boolean name) {
            String out = StringsKt.replace$default(value, "^", "\r", false, 4, null);
            out = StringsKt.replace$default(out, "~", "\n", false, 4, null);
            if (name) {
                out = StringsKt.replace$default(out, "`", ":", false, 4, null);
            }
            return out;
        }

        static /* synthetic */ String transformHeader$default(Companion companion, String string2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.transformHeader(string2, bl);
        }

        @NotNull
        public final LinkedList<Pair<String, String>> buildReq(@NotNull HTTP2Request parsedRequest) {
            Intrinsics.checkNotNullParameter(parsedRequest, "parsedRequest");
            return this.buildReq(parsedRequest, true);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LinkedList<Pair<String, String>> buildReq(@NotNull HTTP2Request parsedRequest, boolean transform) {
            String value;
            Object cookiesplit;
            Intrinsics.checkNotNullParameter(parsedRequest, "parsedRequest");
            LinkedHashMap<String, String> pseudoHeaders = new LinkedHashMap<String, String>();
            LinkedList<Pair<String, String>> headers2 = new LinkedList<Pair<String, String>>();
            LinkedList<Pair<String, String>> linkedList = new LinkedList<Pair<String, String>>();
            String host = "";
            for (String header2 : parsedRequest.getHeaders()) {
                String string2;
                void var9_18;
                void var9_16;
                void var9_14;
                Object object;
                Object var9_11 = null;
                String value2 = "";
                if (StringsKt.contains$default((CharSequence)header2, ": ", false, 2, null)) {
                    object = new String[]{": "};
                    List split = StringsKt.split$default((CharSequence)header2, (String[])object, false, 2, 2, null);
                    String string3 = (String)split.get(0);
                    value2 = (String)split.get(1);
                } else {
                    String string4 = header2;
                }
                if (Intrinsics.areEqual(var9_14, "Connection")) continue;
                if (Intrinsics.areEqual(var9_14, ":connection")) {
                    String string5 = "Connection";
                }
                if (Intrinsics.areEqual(var9_16, "Host") && Intrinsics.areEqual(host, "")) {
                    host = value2;
                }
                if (Intrinsics.areEqual(var9_16, "Cookie")) {
                    object = new String[]{";"};
                    cookiesplit = StringsKt.split$default((CharSequence)value2, (String[])object, false, 0, 6, null);
                    object = cookiesplit.iterator();
                    while (object.hasNext()) {
                        String cookie = (String)object.next();
                        if (Intrinsics.areEqual(cookie, "")) continue;
                        String fixed = cookie;
                        if (transform) {
                            fixed = burp.H2Connection$Companion.transformHeader$default(this, cookie, false, 2, null);
                        }
                        headers2.add(new Pair<String, String>("cookie", fixed));
                    }
                    continue;
                }
                if (transform) {
                    String string6 = this.transformHeader((String)var9_16, true);
                    value2 = this.transformHeader(value2, false);
                }
                cookiesplit = var9_18;
                boolean bl = false;
                Map.Entry entry = cookiesplit;
                if (entry == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue(((String)((Object)entry)).toLowerCase(Locale.ROOT), "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (StringsKt.startsWith$default(string2, ":", false, 2, null)) {
                    if (pseudoHeaders.containsKey(string2)) {
                        headers2.add(new Pair<String, String>(string2, value2));
                        continue;
                    }
                    pseudoHeaders.put(string2, value2);
                    continue;
                }
                headers2.add(new Pair<String, String>(string2, value2));
            }
            boolean stripHost = false;
            if (!pseudoHeaders.containsKey(":scheme")) {
                linkedList.add(new Pair<String, String>(":scheme", "https"));
            }
            if (!pseudoHeaders.containsKey(":method")) {
                linkedList.add(new Pair<String, String>(":method", parsedRequest.getMethod()));
            }
            if (!pseudoHeaders.containsKey(":path")) {
                linkedList.add(new Pair<String, String>(":path", parsedRequest.getPath()));
            }
            if (!pseudoHeaders.containsKey(":authority")) {
                linkedList.add(new Pair<String, String>(":authority", host));
                stripHost = true;
            }
            Map map = pseudoHeaders;
            boolean value2 = false;
            for (Map.Entry entry : map.entrySet()) {
                cookiesplit = entry;
                boolean bl = false;
                String key = (String)cookiesplit.getKey();
                Map.Entry entry2 = entry;
                boolean bl2 = false;
                value = (String)entry2.getValue();
                linkedList.add(new Pair<String, String>(key, value));
            }
            for (Pair pair : headers2) {
                String key = (String)pair.component1();
                value = (String)pair.component2();
                if (stripHost && key.equals("host")) {
                    stripHost = false;
                    continue;
                }
                linkedList.add(new Pair<String, String>(key, value));
            }
            return linkedList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ#\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lburp/H2Connection$TrustingTrustManager;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "turbo-intruder"})
    private static final class TrustingTrustManager
    implements X509TrustManager {
        @Override
        @Nullable
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(@NotNull X509Certificate[] chain2, @NotNull String authType) {
            Intrinsics.checkNotNullParameter(chain2, "chain");
            Intrinsics.checkNotNullParameter(authType, "authType");
        }

        @Override
        public void checkServerTrusted(@NotNull X509Certificate[] chain2, @NotNull String authType) {
            Intrinsics.checkNotNullParameter(chain2, "chain");
            Intrinsics.checkNotNullParameter(authType, "authType");
        }
    }
}

