/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.ConfigListener;
import burp.Utilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.NumberFormatter;

class ConfigurableSettings {
    private static LinkedHashMap<String, String> settings = new LinkedHashMap();
    private static LinkedHashMap<String, String> settingDescriptions = new LinkedHashMap();
    private static LinkedHashMap<String, String> defaultSettings = new LinkedHashMap();
    private NumberFormatter onlyInt;
    private HashMap<String, ConfigListener> callbacks = new HashMap();

    public void registerListener(String key, ConfigListener listener) {
        this.callbacks.put(key, listener);
    }

    void registerSetting(String key, Object value) {
        this.registerSetting(key, value, null);
    }

    void registerSetting(String key, Object value, String description) {
        if (description != null && !settingDescriptions.containsKey(key)) {
            settingDescriptions.put(key, description);
        }
        if (settings.containsKey(key)) {
            return;
        }
        defaultSettings.put(key, this.encode(value));
        String oldValue = Utilities.callbacks.loadExtensionSetting(key);
        if (oldValue != null) {
            this.putRaw(key, oldValue);
            return;
        }
        this.putRaw(key, this.encode(value));
    }

    ConfigurableSettings(HashMap<String, Object> inputSettings) {
        for (String key : inputSettings.keySet()) {
            this.registerSetting(key, inputSettings.get(key));
        }
        for (String key : settings.keySet()) {
            String value = Utilities.callbacks.loadExtensionSetting(key);
            if (Utilities.callbacks.loadExtensionSetting(key) == null) continue;
            this.putRaw(key, value);
        }
        NumberFormat format = NumberFormat.getInstance();
        this.onlyInt = new NumberFormatter(format);
        this.onlyInt.setValueClass(Integer.class);
        this.onlyInt.setMinimum(Integer.valueOf(-1));
        this.onlyInt.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
        this.onlyInt.setAllowsInvalid(false);
    }

    public void setDefaultSettings() {
        for (String key : settings.keySet()) {
            this.putRaw(key, defaultSettings.get(key));
        }
    }

    private ConfigurableSettings(ConfigurableSettings base2) {
        settings = new LinkedHashMap<String, String>(settings);
        this.onlyInt = base2.onlyInt;
    }

    void printSettings() {
        for (String key : settings.keySet()) {
            Utilities.out(key + ": " + settings.get(key));
        }
    }

    static JFrame getBurpFrame() {
        for (Frame f : Frame.getFrames()) {
            if (!f.isVisible() || !f.getTitle().startsWith("Burp Suite")) continue;
            return (JFrame)f;
        }
        return null;
    }

    private String encode(Object value) {
        Object encoded = value instanceof Boolean ? String.valueOf(value) : (value instanceof Integer ? String.valueOf(value) : "\"" + ((String)value).replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
        return encoded;
    }

    private void putRaw(String key, String value) {
        settings.put(key, value);
        ConfigListener callback = this.callbacks.getOrDefault(key, null);
        if (callback != null) {
            callback.valueUpdated(value);
        }
    }

    private void put(String key, Object value) {
        this.putRaw(key, this.encode(value));
    }

    String getString(String key) {
        String decoded = settings.get(key);
        decoded = decoded.substring(1, decoded.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");
        return decoded;
    }

    int getInt(String key) {
        return Integer.parseInt(settings.get(key));
    }

    boolean getBoolean(String key) {
        String val = settings.get(key);
        if ("true".equals(val)) {
            return true;
        }
        if ("false".equals(val)) {
            return false;
        }
        throw new RuntimeException();
    }

    private String getType(String key) {
        String val = settings.get(key);
        if (val.equals("true") || val.equals("false")) {
            return "boolean";
        }
        if (val.startsWith("\"")) {
            return "string";
        }
        return "number";
    }

    ConfigurableSettings showSettings() {
        return this.showSettings(new ArrayList<String>(settings.keySet()));
    }

    ConfigurableSettings showSettings(final ArrayList<String> settingsToShow) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 6));
        panel.setSize(800, 800);
        HashMap<String, JComponent> configured = new HashMap<String, JComponent>();
        JButton buttonResetSettings = new JButton("Reset Visible Settings");
        for (String key : settingsToShow) {
            JComponent box;
            String type = this.getType(key);
            JLabel label = new JLabel("\n" + key + ": ");
            label.setToolTipText(settingDescriptions.getOrDefault(key, "No description available"));
            if (!settings.get(key).equals(defaultSettings.get(key))) {
                label.setForeground(Color.magenta);
            }
            panel.add(label);
            if (type.equals("boolean")) {
                box = new JCheckBox();
                ((AbstractButton)box).setSelected(this.getBoolean(key));
                panel.add(box);
                configured.put(key, box);
                continue;
            }
            if (type.equals("number")) {
                box = new JFormattedTextField(this.onlyInt);
                ((JTextComponent)box).setText(String.valueOf(this.getInt(key)));
                panel.add(box);
                configured.put(key, box);
                continue;
            }
            String value = this.getString(key);
            JTextField box2 = new JTextField(value, value.length());
            box2.setColumns(1);
            panel.add(box2);
            configured.put(key, box2);
        }
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        panel.add(buttonResetSettings);
        buttonResetSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utilities.out("Discarding settings...");
                for (String key : settingsToShow) {
                    Utilities.callbacks.saveExtensionSetting(key, null);
                }
                ConfigurableSettings.this.setDefaultSettings();
                JComponent comp = (JComponent)e.getSource();
                Window win = SwingUtilities.getWindowAncestor(comp);
                win.dispose();
            }
        });
        int result2 = JOptionPane.showConfirmDialog(Utilities.getBurpFrame(), panel, "Attack Config", 2, -1);
        if (result2 == 0) {
            for (String key : configured.keySet()) {
                Object val = configured.get(key);
                val = val instanceof JCheckBox ? Boolean.valueOf(((JCheckBox)val).isSelected()) : (val instanceof JFormattedTextField ? Integer.valueOf(Integer.parseInt(((JFormattedTextField)val).getText().replaceAll("[^-\\d]", ""))) : ((JTextField)val).getText());
                this.put(key, val);
                Utilities.callbacks.saveExtensionSetting(key, this.encode(val));
            }
            return new ConfigurableSettings(this);
        }
        return null;
    }
}

