/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.BurpRequest;
import burp.Floodgate;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.Request;
import burp.RequestEngine;
import burp.Utilities;
import burp.Utils;
import burp.api.montoya.http.HttpMode;
import burp.api.montoya.http.HttpService;
import burp.api.montoya.http.message.HttpRequestResponse;
import burp.api.montoya.http.message.requests.HttpRequest;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J9\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u00032\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030*2\b\u0010+\u001a\u0004\u0018\u00010\u00052\b\u0010,\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010*H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0002J&\u00104\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0004\u0012\u00020\t052\u0006\u00106\u001a\u0002072\u0006\u00101\u001a\u00020\fH\u0002J\u0010\u00108\u001a\u0002002\u0006\u00106\u001a\u000207H\u0002J\u0010\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020\u0005H\u0016R&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020#0\"j\b\u0012\u0004\u0012\u00020#`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006;"}, d2={"Lburp/BurpRequestEngine;", "Lburp/RequestEngine;", "url", "", "threads", "", "maxQueueSize", "maxRetriesPerRequest", "idleTimeout", "", "callback", "Lkotlin/Function2;", "Lburp/Request;", "", "readCallback", "Lkotlin/Function1;", "useHTTP1", "(Ljava/lang/String;IIIJLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Z)V", "getCallback", "()Lkotlin/jvm/functions/Function2;", "gatedRequests", "Ljava/util/HashMap;", "Ljava/util/LinkedList;", "getIdleTimeout", "()J", "setIdleTimeout", "(J)V", "getMaxRetriesPerRequest", "()I", "getReadCallback", "()Lkotlin/jvm/functions/Function1;", "setReadCallback", "(Lkotlin/jvm/functions/Function1;)V", "threadPool", "Ljava/util/ArrayList;", "Ljava/lang/Thread;", "Lkotlin/collections/ArrayList;", "getUseHTTP1", "()Z", "buildRequest", "template", "payloads", "", "learnBoring", "label", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;)Lburp/Request;", "getGatedRequests", "passToCallback", "", "req", "resp", "Lburp/IHttpRequestResponse;", "request", "Lkotlin/Pair;", "service", "Lburp/IHttpService;", "sendRequests", "start", "timeout", "turbo-intruder"})
public class BurpRequestEngine
extends RequestEngine {
    private final int maxRetriesPerRequest;
    private long idleTimeout;
    @NotNull
    private final Function2<Request, Boolean, Boolean> callback;
    @Nullable
    private Function1<? super String, Boolean> readCallback;
    private final boolean useHTTP1;
    @NotNull
    private final ArrayList<Thread> threadPool;
    @NotNull
    private final HashMap<String, LinkedList<Request>> gatedRequests;

    public BurpRequestEngine(@NotNull String url, int threads, int maxQueueSize, int maxRetriesPerRequest, long idleTimeout, @NotNull Function2<? super Request, ? super Boolean, Boolean> callback, @Nullable Function1<? super String, Boolean> readCallback, boolean useHTTP1) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(callback, "callback");
        this.maxRetriesPerRequest = maxRetriesPerRequest;
        this.idleTimeout = idleTimeout;
        this.callback = callback;
        this.readCallback = readCallback;
        this.useHTTP1 = useHTTP1;
        this.threadPool = new ArrayList();
        this.gatedRequests = new HashMap();
        this.setRequestQueue(maxQueueSize > 0 ? new LinkedBlockingQueue<Request>(maxQueueSize) : new LinkedBlockingQueue());
        this.setCompletedLatch(new CountDownLatch(threads));
        this.setTarget(new URL(url));
        final IHttpService service = Utils.callbacks.getHelpers().buildHttpService(this.getTarget().getHost(), this.getTarget().getPort(), Intrinsics.areEqual(this.getTarget().getProtocol(), "https"));
        int n = 1;
        if (n <= threads) {
            int j;
            do {
                j = n++;
                this.threadPool.add(ThreadsKt.thread$default(false, false, null, null, 0, new Function0<Unit>(){

                    @Override
                    public final void invoke() {
                        IHttpService iHttpService = service;
                        Intrinsics.checkNotNullExpressionValue(iHttpService, "service");
                        this.sendRequests(iHttpService);
                    }
                }, 31, null));
            } while (j != threads);
        }
    }

    public /* synthetic */ BurpRequestEngine(String string2, int n, int n2, int n3, long l, Function2 function2, Function1 function1, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            l = 0L;
        }
        this(string2, n, n2, n3, l, function2, function1, bl);
    }

    @Override
    public int getMaxRetriesPerRequest() {
        return this.maxRetriesPerRequest;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long l) {
        this.idleTimeout = l;
    }

    @Override
    @NotNull
    public Function2<Request, Boolean, Boolean> getCallback() {
        return this.callback;
    }

    @Override
    @Nullable
    public Function1<String, Boolean> getReadCallback() {
        return this.readCallback;
    }

    @Override
    public void setReadCallback(@Nullable Function1<? super String, Boolean> function1) {
        this.readCallback = function1;
    }

    public final boolean getUseHTTP1() {
        return this.useHTTP1;
    }

    @Override
    public void start(int timeout) {
        this.getAttackState().set(1);
        this.setStart(System.nanoTime());
    }

    @Override
    @NotNull
    public Request buildRequest(@NotNull String template, @NotNull List<String> payloads, @Nullable Integer learnBoring, @Nullable String label) {
        Object object;
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(payloads, "payloads");
        String prepared = template;
        if (this.useHTTP1) {
            prepared = StringsKt.replaceFirst$default(StringsKt.replace$default(prepared, "Connection: keep-alive", "Connection: close", false, 4, null), "HTTP/2\r\n", "HTTP/1.1\r\n", false, 4, null);
        } else {
            object = prepared;
            Charset charset2 = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
            if (!Utilities.isHTTP2(byArray)) {
                prepared = StringsKt.replaceFirst$default(prepared, "HTTP/1.1\r\n", "HTTP/2\r\n", false, 4, null);
            }
        }
        object = learnBoring;
        return new Request(prepared, payloads, object == null ? 0 : (Integer)object, label);
    }

    private final Pair<IHttpRequestResponse, Long> request(IHttpService service, Request req) {
        IHttpRequestResponse resp = null;
        long startTime = System.nanoTime();
        long responseTime = 0L;
        if (this.useHTTP1) {
            try {
                resp = Utils.callbacks.makeHttpRequest(service, req.getRequestAsBytes(), true);
                responseTime = System.nanoTime() - startTime;
            }
            catch (NoSuchMethodError e) {
                throw new RuntimeException("Please update Burp Suite");
            }
        } else {
            byte[] respBytes = Utils.h2request(service, req.getRequestAsBytes());
            responseTime = System.nanoTime() - startTime;
            if (respBytes != null) {
                req.setResponse(Utils.helpers.bytesToString(respBytes));
            }
            resp = new BurpRequest(req);
        }
        return new Pair<IHttpRequestResponse, Long>(resp, responseTime / (long)1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Request> getGatedRequests() {
        Set<String> set = this.gatedRequests.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "gatedRequests.keys");
        Set<String> gates = set;
        for (String gate : gates) {
            Intrinsics.checkNotNullExpressionValue(gate, "gate");
            String string2 = gate;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (string2) {
                block5: {
                    AtomicBoolean atomicBoolean;
                    boolean bl3 = false;
                    Floodgate floodgate = this.getFloodgates().get(gate);
                    if (!(floodgate == null ? false : ((atomicBoolean = floodgate.isOpen) == null ? false : atomicBoolean.get()))) break block5;
                    LinkedList<Request> toSend = this.gatedRequests.get(gate);
                    this.gatedRequests.remove(gate);
                    List list = toSend;
                    return list;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return null;
    }

    private final void sendRequests(IHttpService service) {
        while (this.getAttackState().get() < 1) {
            Thread.sleep(10L);
        }
        while (this.getAttackState().get() < 3 && !Utils.unloaded) {
            Object object;
            List<Request> requestGroup = this.getGatedRequests();
            if (requestGroup != null) {
                ArrayList<HttpRequest> preppedRequestBatch = new ArrayList<HttpRequest>();
                HttpService montoyaService = HttpService.httpService(service.getHost(), service.getPort(), "https".equals(service.getProtocol()));
                for (Request req : requestGroup) {
                    HttpRequest montoyaReq = HttpRequest.httpRequest(montoyaService, req.getRequest());
                    preppedRequestBatch.add(montoyaReq);
                }
                HttpMode protocolVersion = null;
                int connectionID = 0;
                if (this.useHTTP1) {
                    this.getConnections().addAndGet(requestGroup.size());
                    protocolVersion = HttpMode.HTTP_1;
                } else {
                    protocolVersion = HttpMode.HTTP_2;
                    connectionID = this.getConnections().incrementAndGet();
                }
                long timer = System.nanoTime();
                List<HttpRequestResponse> responses = Utils.montoyaApi.http().sendRequests((List<HttpRequest>)preppedRequestBatch, protocolVersion);
                int n = 0;
                ArrayList<Request> reqs = new ArrayList<Request>();
                for (HttpRequestResponse resp : responses) {
                    int n2 = n;
                    n = n2 + 1;
                    Request req = requestGroup.get(n2);
                    if (resp.response() == null) {
                        req.setResponse("The server closed the connection without issuing a response.");
                        this.getPermaFails().incrementAndGet();
                    } else {
                        this.getSuccessfulRequests().getAndIncrement();
                        req.setResponse(((Object)resp.response()).toString());
                    }
                    req.setTime(resp.timingData().get().timeBetweenRequestSentAndStartOfResponse().toNanos() / (long)1000);
                    req.setArrival((timer - this.getStart()) / (long)1000 + req.getTime());
                    if (this.useHTTP1) {
                        req.setConnectionID(this.getConnections().incrementAndGet());
                    } else {
                        req.setConnectionID(connectionID);
                    }
                    byte[] byArray = resp.response().toByteArray().getBytes();
                    Intrinsics.checkNotNullExpressionValue(byArray, "resp.response().toByteArray().bytes");
                    req.setInteresting(this.processResponse(req, byArray));
                    reqs.add(req);
                }
                List $this$sortBy$iv = reqs;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    boolean bl = false;
                    CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Request it = (Request)a;
                            boolean bl2 = false;
                            Comparable comparable = Long.valueOf(it.getTime());
                            it = (Request)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            Long l = it.getTime();
                            return ComparisonsKt.compareValues(comparable2, (Comparable)l);
                        }
                    });
                }
                for (Request req : reqs) {
                    Intrinsics.checkNotNullExpressionValue(req, "req");
                    this.invokeCallback(req, req.getInteresting());
                }
                continue;
            }
            Request req = this.getRequestQueue().poll(100L, TimeUnit.MILLISECONDS);
            if (req == null) {
                object = this.gatedRequests;
                boolean protocolVersion = false;
                if (!object.isEmpty() || this.getAttackState().get() != 2) continue;
                this.getCompletedLatch().countDown();
                return;
            }
            if (req.getGate() != null) {
                Floodgate floodgate = req.getGate();
                Intrinsics.checkNotNull(floodgate);
                this.gatedRequests.putIfAbsent(floodgate.name, new LinkedList());
                Floodgate floodgate2 = req.getGate();
                Intrinsics.checkNotNull(floodgate2);
                LinkedList<Request> linkedList = this.gatedRequests.get(floodgate2.name);
                Intrinsics.checkNotNull(linkedList);
                linkedList.add(req);
                Floodgate floodgate3 = req.getGate();
                Intrinsics.checkNotNull(floodgate3);
                floodgate3.remaining.decrementAndGet();
                continue;
            }
            object = this.request(service, req);
            IHttpRequestResponse resp = (IHttpRequestResponse)((Pair)object).component1();
            long time = ((Number)((Pair)object).component2()).longValue();
            this.getConnections().incrementAndGet();
            while (true) {
                IHttpRequestResponse iHttpRequestResponse = resp;
                Intrinsics.checkNotNull(iHttpRequestResponse);
                if (iHttpRequestResponse.getResponse() != null || !this.shouldRetry(req)) break;
                Utils.out(Intrinsics.stringPlus("Retrying ", req.getWords()));
                resp = this.request(service, req).getFirst();
                this.getConnections().incrementAndGet();
                Utils.out(Intrinsics.stringPlus("Retried ", req.getWords()));
            }
            req.setTime(time);
            this.passToCallback(req, resp);
        }
    }

    private final void passToCallback(Request req, IHttpRequestResponse resp) {
        if (resp.getResponse() == null) {
            req.setResponse("The server closed the connection without issuing a response.");
            this.invokeCallback(req, true);
        }
        if (resp.getResponse() != null) {
            this.getSuccessfulRequests().getAndIncrement();
            byte[] byArray = resp.getResponse();
            Intrinsics.checkNotNullExpressionValue(byArray, "resp.response");
            boolean interesting = this.processResponse(req, byArray);
            req.setResponse(Utils.helpers.bytesToString(resp.getResponse()));
            this.invokeCallback(req, interesting);
        }
    }
}

