"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
class ServiceAccount extends base.Resource {
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.resourceType = 'serviceaccounts';
        this._secrets = (_b = props.secrets) !== null && _b !== void 0 ? _b : [];
        this.automountToken = (_c = props.automountToken) !== null && _c !== void 0 ? _c : true;
        this.apiObject = new k8s.KubeServiceAccount(this, 'Resource', {
            metadata: props.metadata,
            secrets: cdk8s_1.Lazy.any({ produce: () => utils_1.undefinedIfEmpty(this._secrets.map(s => ({ name: s.name }))) }),
            automountServiceAccountToken: this.automountToken,
        });
    }
    /**
     * Imports a service account from the cluster as a reference.
     * @param name The name of the service account resource.
     */
    static fromServiceAccountName(name) {
        return {
            apiGroup: '',
            name,
            ...k8s.KubeServiceAccount.GVK,
        };
    }
    /**
     * Allow a secret to be accessed by pods using this service account.
     * @param secr The secret
     */
    addSecret(secr) {
        this._secrets.push(secr);
    }
    /**
     * List of secrets allowed to be used by pods running using this service
     * account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     */
    get secrets() {
        return [...this._secrets];
    }
}
exports.ServiceAccount = ServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccount[_a] = { fqn: "cdk8s-plus-22.ServiceAccount", version: "2.0.0-beta.10" };
//# sourceMappingURL=data:application/json;base64,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