"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const pod = require("./pod");
const workload = require("./workload");
/**
 * A Job creates one or more Pods and ensures that a specified number of them successfully terminate. As pods successfully complete,
 * the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
 * Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
 * The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
 * You can also use a Job to run multiple Pods in parallel.
 */
class Job extends workload.Workload {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            restartPolicy: pod.RestartPolicy.NEVER,
            select: false,
            ...props,
        });
        this.resourceType = 'jobs';
        this.apiObject = new k8s.KubeJob(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.activeDeadline = props.activeDeadline;
        this.backoffLimit = props.backoffLimit;
        this.ttlAfterFinished = props.ttlAfterFinished;
    }
    /**
     * @internal
     */
    _toKube() {
        var _b;
        return {
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            activeDeadlineSeconds: (_b = this.activeDeadline) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            backoffLimit: this.backoffLimit,
            ttlSecondsAfterFinished: this.ttlAfterFinished ? this.ttlAfterFinished.toSeconds() : undefined,
        };
    }
}
exports.Job = Job;
_a = JSII_RTTI_SYMBOL_1;
Job[_a] = { fqn: "cdk8s-plus-22.Job", version: "2.0.0-beta.10" };
//# sourceMappingURL=data:application/json;base64,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