"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
class Resource extends constructs_1.Construct {
    get metadata() {
        return this.apiObject.metadata;
    }
    /**
     * The name of this API object.
     */
    get name() {
        return this.apiObject.name;
    }
    /**
     * The object's API version (e.g. "authorization.k8s.io/v1")
     */
    get apiVersion() {
        return this.apiObject.apiVersion;
    }
    /**
     * The group portion of the API version (e.g. "authorization.k8s.io").
     */
    get apiGroup() {
        return this.apiObject.apiGroup;
    }
    /**
     * The object kind (e.g. "Deployment").
     */
    get kind() {
        return this.apiObject.kind;
    }
    get resourceName() {
        return this.name;
    }
    asApiResource() {
        return this;
    }
    asNonApiResource() {
        return undefined;
    }
}
exports.Resource = Resource;
_a = JSII_RTTI_SYMBOL_1;
Resource[_a] = { fqn: "cdk8s-plus-22.Resource", version: "2.0.0-beta.10" };
//# sourceMappingURL=data:application/json;base64,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