"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRestoreTask = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosRestoreTaskProps`
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the result of the validation.
 */
function RosRestoreTaskPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('startTask', ros.validateBoolean)(properties.startTask));
    errors.collect(ros.propertyValidator('restoreDir', ros.validateString)(properties.restoreDir));
    if (properties.duplicateConflict && (typeof properties.duplicateConflict) !== 'object') {
        errors.collect(ros.propertyValidator('duplicateConflict', ros.validateAllowedValues)({
            data: properties.duplicateConflict,
            allowedValues: ["failure", "renamenew"],
        }));
    }
    errors.collect(ros.propertyValidator('duplicateConflict', ros.validateString)(properties.duplicateConflict));
    errors.collect(ros.propertyValidator('restoreHome', ros.validateString)(properties.restoreHome));
    errors.collect(ros.propertyValidator('destinationEndpointPassword', ros.validateString)(properties.destinationEndpointPassword));
    errors.collect(ros.propertyValidator('destinationEndpointIp', ros.validateString)(properties.destinationEndpointIp));
    errors.collect(ros.propertyValidator('destinationEndpointPort', ros.validateNumber)(properties.destinationEndpointPort));
    errors.collect(ros.propertyValidator('destinationEndpointOracleSid', ros.validateString)(properties.destinationEndpointOracleSid));
    errors.collect(ros.propertyValidator('backupSetId', ros.validateString)(properties.backupSetId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.requiredValidator)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.validateString)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('restoreTime', ros.validateNumber)(properties.restoreTime));
    errors.collect(ros.propertyValidator('destinationEndpointRegion', ros.validateString)(properties.destinationEndpointRegion));
    errors.collect(ros.propertyValidator('destinationEndpointDatabaseName', ros.validateString)(properties.destinationEndpointDatabaseName));
    errors.collect(ros.propertyValidator('destinationEndpointUserName', ros.validateString)(properties.destinationEndpointUserName));
    errors.collect(ros.propertyValidator('restoreObjects', ros.validateString)(properties.restoreObjects));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.requiredValidator)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.validateString)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('backupPlanId', ros.requiredValidator)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupPlanId', ros.validateString)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupGatewayId', ros.validateNumber)(properties.backupGatewayId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceId', ros.validateString)(properties.destinationEndpointInstanceId));
    return errors.wrap('supplied properties not correct for "RosRestoreTaskProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource.
 */
// @ts-ignore TS6133
function rosRestoreTaskPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRestoreTaskPropsValidator(properties).assertSuccess();
    }
    return {
        BackupPlanId: ros.stringToRosTemplate(properties.backupPlanId),
        DestinationEndpointInstanceType: ros.stringToRosTemplate(properties.destinationEndpointInstanceType),
        RestoreTaskName: ros.stringToRosTemplate(properties.restoreTaskName),
        BackupGatewayId: ros.numberToRosTemplate(properties.backupGatewayId),
        BackupSetId: ros.stringToRosTemplate(properties.backupSetId),
        DestinationEndpointDatabaseName: ros.stringToRosTemplate(properties.destinationEndpointDatabaseName),
        DestinationEndpointInstanceID: ros.stringToRosTemplate(properties.destinationEndpointInstanceId),
        DestinationEndpointIP: ros.stringToRosTemplate(properties.destinationEndpointIp),
        DestinationEndpointOracleSID: ros.stringToRosTemplate(properties.destinationEndpointOracleSid),
        DestinationEndpointPassword: ros.stringToRosTemplate(properties.destinationEndpointPassword),
        DestinationEndpointPort: ros.numberToRosTemplate(properties.destinationEndpointPort),
        DestinationEndpointRegion: ros.stringToRosTemplate(properties.destinationEndpointRegion),
        DestinationEndpointUserName: ros.stringToRosTemplate(properties.destinationEndpointUserName),
        DuplicateConflict: ros.stringToRosTemplate(properties.duplicateConflict),
        RestoreDir: ros.stringToRosTemplate(properties.restoreDir),
        RestoreHome: ros.stringToRosTemplate(properties.restoreHome),
        RestoreObjects: ros.stringToRosTemplate(properties.restoreObjects),
        RestoreTime: ros.numberToRosTemplate(properties.restoreTime),
        StartTask: ros.booleanToRosTemplate(properties.startTask),
    };
}
/**
 * A ROS template type:  `ALIYUN::DBS::RestoreTask`
 */
class RosRestoreTask extends ros.RosResource {
    /**
     * Create a new `ALIYUN::DBS::RestoreTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRestoreTask.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRestoreTaskId = this.getAtt('RestoreTaskId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.backupPlanId = props.backupPlanId;
        this.destinationEndpointInstanceType = props.destinationEndpointInstanceType;
        this.restoreTaskName = props.restoreTaskName;
        this.backupGatewayId = props.backupGatewayId;
        this.backupSetId = props.backupSetId;
        this.destinationEndpointDatabaseName = props.destinationEndpointDatabaseName;
        this.destinationEndpointInstanceId = props.destinationEndpointInstanceId;
        this.destinationEndpointIp = props.destinationEndpointIp;
        this.destinationEndpointOracleSid = props.destinationEndpointOracleSid;
        this.destinationEndpointPassword = props.destinationEndpointPassword;
        this.destinationEndpointPort = props.destinationEndpointPort;
        this.destinationEndpointRegion = props.destinationEndpointRegion;
        this.destinationEndpointUserName = props.destinationEndpointUserName;
        this.duplicateConflict = props.duplicateConflict;
        this.restoreDir = props.restoreDir;
        this.restoreHome = props.restoreHome;
        this.restoreObjects = props.restoreObjects;
        this.restoreTime = props.restoreTime;
        this.startTask = props.startTask;
    }
    get rosProperties() {
        return {
            backupPlanId: this.backupPlanId,
            destinationEndpointInstanceType: this.destinationEndpointInstanceType,
            restoreTaskName: this.restoreTaskName,
            backupGatewayId: this.backupGatewayId,
            backupSetId: this.backupSetId,
            destinationEndpointDatabaseName: this.destinationEndpointDatabaseName,
            destinationEndpointInstanceId: this.destinationEndpointInstanceId,
            destinationEndpointIp: this.destinationEndpointIp,
            destinationEndpointOracleSid: this.destinationEndpointOracleSid,
            destinationEndpointPassword: this.destinationEndpointPassword,
            destinationEndpointPort: this.destinationEndpointPort,
            destinationEndpointRegion: this.destinationEndpointRegion,
            destinationEndpointUserName: this.destinationEndpointUserName,
            duplicateConflict: this.duplicateConflict,
            restoreDir: this.restoreDir,
            restoreHome: this.restoreHome,
            restoreObjects: this.restoreObjects,
            restoreTime: this.restoreTime,
            startTask: this.startTask,
        };
    }
    renderProperties(props) {
        return rosRestoreTaskPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRestoreTask = RosRestoreTask;
/**
 * The resource type name for this resource class.
 */
RosRestoreTask.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DBS::RestoreTask";
//# sourceMappingURL=data:application/json;base64,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