"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelineJavaProject = void 0;
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
/**
 * Synthesizes a Java Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-java
 */
class PDKPipelineJavaProject extends awscdk_1.AwsCdkJavaApp {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
            mainClass: options.mainClass !== "org.acme.MyApp"
                ? options.mainClass
                : 'software.aws.Pipeline -Dexec.classpathScope="test"',
        });
        this.addDependency("software.aws.awsprototypingsdk/aws-prototyping-sdk@^0");
        this.testTask.exec("mvn test");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-api@5.7.0");
        this.addTestDependency("org.junit.jupiter/junit-jupiter-engine@5.7.0");
        const mainPackage = this.mainClass
            .split(" ")[0]
            .split(".")
            .slice(0, -1)
            .join(".");
        new projen_1.SampleDir(this, path.join("src", "main", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "main", "java", "software", "aws"),
        });
        new projen_1.SampleDir(this, path.join("src", "test", "java", ...mainPackage.split(".")), {
            sourceDir: path.join(__dirname, "..", "samples", "java", "src", "test", "java", "software", "aws"),
        });
    }
}
exports.PDKPipelineJavaProject = PDKPipelineJavaProject;
//# sourceMappingURL=data:application/json;base64,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