"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticateCognitoAction = void 0;
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
/**
 * A Listener Action to authenticate with Cognito.
 *
 * @stability stable
 */
class AuthenticateCognitoAction extends elbv2.ListenerAction {
    /**
     * Authenticate using an identity provide (IdP) that is compliant with OpenID Connect (OIDC).
     *
     * @stability stable
     */
    constructor(options) {
        var _a;
        super({
            type: 'authenticate-cognito',
            authenticateCognitoConfig: {
                userPoolArn: options.userPool.userPoolArn,
                userPoolClientId: options.userPoolClient.userPoolClientId,
                userPoolDomain: options.userPoolDomain.domainName,
                authenticationRequestExtraParams: options.authenticationRequestExtraParams,
                onUnauthenticatedRequest: options.onUnauthenticatedRequest,
                scope: options.scope,
                sessionCookieName: options.sessionCookieName,
                sessionTimeout: (_a = options.sessionTimeout) === null || _a === void 0 ? void 0 : _a.toSeconds().toString(),
            },
        }, options.next);
    }
}
exports.AuthenticateCognitoAction = AuthenticateCognitoAction;
//# sourceMappingURL=data:application/json;base64,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