<!-- Auto-generated file - do not modify. -->

<!--
    Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
    SPDX-License-Identifier: Apache-2.0
    -->

# AwsPrototyping

>*Disclaimer:* *Security and Compliance is a shared responsibility between AWS and the customer. The topics discussed in this document fall on the customer side of the [shared responsibility model](https://aws.amazon.com/compliance/shared-responsibility-model/). The supplied rule pack is not comprehensive in declaring the security posture of the code in which it validates; it is but one tool that can be used in the development cycle to increase the confidence of the baseline security of what you are building. Note that the provided information and resources are non-contextual to your workload, use case or your security and compliance goals.*

The AWS Prototyping team aim to rapidly assess the viability of solving new and novel business problems for customers using AWS technology. This means that sometimes the prototype is discarded, and others it forms the starting point for the actual workload. A prototype is not a production-grade system, but an enablement tool to catalyse innovation and drive decision making, helping to provide confidence to decision makers that “this is possible” allowing them to start a program of work to build for a production state.

A security program for prototyping is multi-faceted, covering people, process and technology that is optimised for the typical prototyping delivery velocity - which is typically in days or weeks. The aim is to make the job of builders easier by using automation, alongside a trusted security subject-matter expert review, to ensure that a prototype meets an organisation’s security bar. Automation that aids the end-to-end prototyping process can include: vending dedicated AWS accounts that have security guardrails built in, using Infrastructure-as-code (IaC) constructs with pragmatic security defaults, automated static analysis of source code and/or IaC linting.

IaC linting assists by checking for a set of *potentially* undesirable configuration states, the results of these atomic checks help give developers feedback early in the development cycle on non-contextual configurations that *may* require addressing. In addition, it can aid in communication between developers and security reviewers by guiding the creation of [suppression rules](https://github.com/cdklabs/cdk-nag#suppressing-a-rule) that can be reviewed in the context of the prototype goals during the human security review process.

Given the rapid development cycle and that prototypes are not intended for production deployment, certain configuration states relating to operational concerns such as high-availability or observability could be deprioritised (unless they are a key proof point of the prototype) in favour of putting a stronger focus on risks associated with prototyping code that may lack the equivalent depth of security oversight typically associated with production code (e.g. extensive threat modeling, high test coverage, human-led penetration testing). In these scenarios, likelihood of a risk eventuating can be greatly reduced by reducing the exposed attack surface of a prototype to an internet based actor, particular for non-targeted attacks.

The AwsPrototyping NagPack has been designed including specific [CDK_nag rules](https://github.com/cdklabs/cdk-nag/blob/main/RULES.md) with the aim of a prioritising attack surface reduction and check for misconfigurations that expose data directly to internet based actors; and a reduced focus on operational concerns typically associated with production systems - e.g. Multi-AZ RDS deployments, logging etc. The *goal* is that the rules that are at the `ERROR` level are intended to occur very rarely and require suppression rules to be written, whilst those at the `WARNING` level have a higher likelihood of requiring additional human derived context to determine whether they should be fixed, or suppressed given that there is a valid use case.

The AwsPrototyping NagPack has not been designed with specific prototype goals and security requirements in mind. It should be evaluated and modified to best suit your use case, and you should consider the various stages of the software development lifecycle and the data that is available during each phase. Any findings generated by applying the NagPack should have a trusted security subject-matter expert review and interpret them whilst taking into account organisational and project context.

## How to use it

### PDK users

If you use the release >= [0.12.17](https://github.com/aws/aws-prototyping-sdk/releases/tag/v0.12.17) of PDK, you can opt into using the AwsPrototyping pack as follows:

```
import { AwsPrototypingChecks } from "@aws-prototyping-sdk/pdk-nag";

const app = PDKNag.app({ nagPacks: [new AwsPrototypingChecks()] });

// Create stacks
```

### CDK users

If you are not using PDK, but are using CDK you can import the Pack into your CDK project as follows:

1. Install the dependency on pdk-nag.

```
# Installation via yarn
yarn add @aws-prototyping-sdk/pdk-nag

# Installation via npm
npm install @aws-prototyping-sdk/pdk-nag
```

2. Instrument the lint pack into your application.

```
import { AwsPrototypingChecks } from "@aws-prototyping-sdk/pdk-nag";

const app = new cdk.App();
Aspects.of(app).add(new AwsPrototypingChecks());

// Create stacks
```

### Suppressing rules

To suppress rule violations, use the `NagSuppressions.*` methods. Please refer to the cdk-nag [README](https://github.com/cdklabs/cdk-nag#suppressing-a-rule) for examples.

## Rules


### Errors

Total: `35`

| Rule ID | Cause | Explanation |
| ------------------ | ------------------ | ------------------ |
| AutoScalingLaunchConfigPublicIpDisabled | The Auto Scaling launch configuration does not have public IP addresses disabled. | If you configure your Network Interfaces with a public IP address, then the associated resources to those Network Interfaces are reachable from the internet. EC2 resources should not be publicly accessible, as this may allow unintended access to your applications or servers.<br /><br />Example threat: A global internet-based actor can discover EC2 instances that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| Cloud9InstanceNoIngressSystemsManager | The Cloud9 instance does not use a no-ingress EC2 instance with AWS Systems Manager. | SSM adds an additional layer of protection as it allows operators to control access through IAM permissions and does not require opening inbound ports.<br /><br />Example threat: A global internet-based actor can discover Cloud9 EC2 instances that have public IP addresses and that are exposing SSH, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| CloudFrontDistributionGeoRestrictions | The prototypes CloudFront distribution has not been configured with geographic restrictions (GeoRestriction) | Geo restriction should be enabled for the distribution in order to limit the surface area exposed to expected geographies<br /><br />Example threat: A global internet-based actor can discover prototype web assets that are exposed via CloudFront distributions, which may lead to recon and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| CloudFrontDistributionS3OriginAccessIdentity | The CloudFront distribution does not use an origin access identity an S3 origin. | Origin access identities help with security by restricting any direct access to objects through S3 URLs.<br /><br />Example threat: A global internet-based actor can bypass the CloudFront distribution and associated controls (e.g. geo blocking), which may lead to direct access to static assets hosted on the S3 origin possibly impacting the confidentiality, integrity and availability of the data assets hosted on the S3 origin for the prototype |
| CodeBuildProjectEnvVarAwsCred | The CodeBuild environment stores sensitive credentials (such as AWS_ACCESS_KEY_ID and/or AWS_SECRET_ACCESS_KEY) as plaintext environment variables. | Do not store these variables in clear text. Storing these variables in clear text leads to unintended data exposure and unauthorized access.<br /><br />Example threat: An actor who can view the CodeBuild environment variables can obtain the AWS Access Key and Secret Access Key, which may lead to the actor being able to do anything the AWS keys are authorised to do possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| CognitoUserPoolNoUnauthenticatedLogins | The Cognito identity pool allows for unauthenticated logins and does not have a cdk-nag rule suppression with a reason. | Applications do not warrant unauthenticated guest access in many cases. Metadata explaining the use case allows for transparency to operators.<br /><br />Example threat: A global internet-based actor who has discovered a prototype endpoint with Cognito unauthenticated logins can does not need to provide credentials to interact with the endpoint, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| CognitoUserPoolStrongPasswordPolicy | The Cognito user pool does not have a password policy that minimally specify a password length of at least 8 characters, as well as requiring uppercase, numeric, and special characters. | Strong password policies increase system security by encouraging users to create reliable and secure passwords.<br /><br />Example threat: An actor who has discovered a prototype endpoint with Cognito authenticated logins can perform a dictionary or brute force attack to authenticate as an authorized Cognito user, which may lead to the actor being able to do anything the associated Cognito user is authorised to do possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| DMSReplicationNotPublic | The DMS replication instance is public. | DMS replication instances can contain sensitive information and access control is required for such accounts.<br /><br />Example threat: A global internet-based actor can discover DMS instances that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| DocumentDBCredentialsInSecretsManager | The Document DB cluster does not have the username and password stored in Secrets Manager. | Secrets Manager enables operators to replace hardcoded credentials in your code, including passwords, with an API call to Secrets Manager to retrieve the secret programmatically. This helps ensure the secret can't be compromised by someone examining system code, because the secret no longer exists in the code. Also, operators can configure Secrets Manager to automatically rotate the secret for you according to a specified schedule. This enables you to replace long-term secrets with short-term ones, significantly reducing the risk of compromise.<br /><br />Example threat: An actor who can view the DocumentDB configuration can obtain the username and password for the DocumentDB cluster, which may lead to the actor being able to access anything the associated DocumentDB user is authorised to do possibly impacting the confidentiality, integrity and availability of the data assets hosted on the DocumentDB cluster for the prototype |
| EC2InstancesInVPC | The EC2 instance is not within a VPC. | Because of their logical isolation, domains that reside within an Amazon VPC have an extra layer of security when compared to domains that use public endpoints.<br /><br />Example threat: A global internet-based actor can discover EC2 instances that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| EC2RestrictedCommonPorts | The EC2 instance allows unrestricted inbound IPv4 TCP traffic on one or more common ports (by default these ports include 20, 21, 3389, 3309, 3306, 4333). | Not restricting access to ports to trusted sources can lead to attacks against the availability, integrity and confidentiality of systems. By default, common ports which should be restricted include port numbers 20, 21, 3389, 3306, and 4333.<br /><br />Example threat: A global internet-based actor can discover exposed services (e.g. Telnet, SSH, RDS, MySQL) using their common port numbers, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| EC2RestrictedInbound | The Security Group allows for 0.0.0.0/0 or ::/0 inbound access. | Large port ranges, when open, expose instances to unwanted attacks. More than that, they make traceability of vulnerabilities very difficult. For instance, your web servers may only require 80 and 443 ports to be open, but not all. One of the most common mistakes observed is when all ports for 0.0.0.0/0 range are open in a rush to access the instance. EC2 instances must expose only to those ports enabled on the corresponding security group level.<br /><br />Example threat: A global internet-based actor can discover EC2 instances that have public IP addresses and allow ingress to all internet address or move laterally to non-public EC2 instances, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| EC2RestrictedSSH | The Security Group allows unrestricted SSH access. | Not allowing ingress (or remote) traffic from 0.0.0.0/0 or ::/0 to port 22 on your resources helps to restrict remote access.<br /><br />Example threat: A global internet-based actor can discover EC2 instances that have public IP addresses and allow ingress to all internet address to SSH or move laterally to non-public EC2 instances via SSH, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| ECROpenAccess | The ECR Repository allows open access. | Removing * principals in an ECR Repository helps protect against unauthorized access.<br /><br />Example threat: A global internet-based actor who has discovered a ECR repository can access the container images hosted within the repository, which may lead to information disclosure that aids in the intrusion activities being successful against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| EKSClusterNoEndpointPublicAccess | The EKS cluster's Kubernetes API server endpoint has public access enabled. | A cluster's Kubernetes API server endpoint should not be publicly accessible from the Internet in order to avoid exposing private data and minimizing security risks. The API server endpoints should only be accessible from within a AWS Virtual Private Cloud (VPC).<br /><br />Example threat: A global internet-based actor who has discovered a EKS cluster Kubernetes API server endpoint can perform reconnaissance and intrusion activities against the exposed attack surface, which may lead to possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| ElastiCacheClusterInVPC | The ElastiCache cluster is not provisioned in a VPC. | Provisioning the cluster within a VPC allows for better flexibility and control over the cache clusters security, availability, traffic routing and more.<br /><br />Example threat: A global internet-based actor can discover the ElastiCache cluster that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data with the cluster used within the prototype |
| ElasticBeanstalkManagedUpdatesEnabled | The Elastic Beanstalk environment does not have managed updates enabled. | Enable managed platform updates for beanstalk environments in order to receive bug fixes, software updates and new features. Managed platform updates perform immutable environment updates.<br /><br />Example threat: An actor with a network path to the Elastic Beanstalk environment can attempt to take advantage of a known vulnerability in a platform component used by Elastic Beanstalk, which may lead to unknown impacts possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| EventBusOpenAccess | The event bus policy allows for open access. | An open policy ("*" principal without a condition) grants anonymous access to an event bus. Use a condition to limit the permission to accounts that fulfill a certain requirement, such as being a member of a certain AWS organization.<br /><br />Example threat: A global internet-based actor who has discovered the Event Bridge event bus (e.g. Endpoint ID) can put arbitrary events onto the bus, which may lead to which could be processed by the prototype possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| IAMPolicyNoStatementsWithAdminAccess | The IAM policy grants admin access - meaning the policy allows a principal to perform unlimited actions on any service | AWS Identity and Access Management (IAM) can help you incorporate the principles of least privilege and separation of duties with access permissions and authorizations, by ensuring that IAM groups have at least one IAM user. Placing IAM users in groups based on their associated permissions or job function is one way to incorporate least privilege.<br /><br />Example threat: A global internet-based actor who has successfully obtained valid keys or a session associated of the IAM Principal associated with the IAM policy can perform unlimited AWS actions on any AWS service which are exposed via the AWS API/Management Console/CLI, which may lead to broad and unknown impacts possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| LambdaFunctionPublicAccessProhibited | The Lambda function permission grants public access | Public access allows anyone on the internet to perform unauthenticated actions on your function and can potentially lead to degraded availability.<br /><br />Example threat: A global internet-based actor who has discovered the Lambda function name or ARN can invoke/delete/modify the Lambda function without any authentication, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| LambdaFunctionUrlAuth | The Lambda Function URL allows for public, unauthenticated access. | AWS Lambda Function URLs allow you to invoke your function via a HTTPS end-point, setting the authentication to NONE allows anyone on the internet to invoke your function.<br /><br />Example threat: A global internet-based actor who has discovered the Lambda Function URL can invoke the Lambda function without any authentication, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| NeptuneClusterAutomaticMinorVersionUpgrade | The Neptune DB instance does have Auto Minor Version Upgrade enabled. | The Neptune service regularly releases engine updates. Enabling Auto Minor Version Upgrade will allow the service to automatically apply these upgrades to DB Instances.<br /><br />Example threat: An actor with a network path to the Neptune cluster or instance can attempt to take advantage of a known vulnerability in a component exposed by Neptune, which may lead to unknown impacts possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| OpenSearchInVPCOnly | The OpenSearch Service domain is not provisioned inside a VPC. | Provisioning the domain within a VPC enables better flexibility and control over the clusters access and security as this feature keeps all traffic between the VPC and OpenSearch domains within the AWS network instead of going over the public Internet.<br /><br />Example threat: A global internet-based actor can discover the OpenSearch Service domain that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data with the cluster used within the prototype |
| OpenSearchNoUnsignedOrAnonymousAccess | The OpenSearch Service domain does not allow for unsigned requests or anonymous access. | Restricting public access helps prevent unauthorized access and prevents any unsigned requests to be made to the resources.<br /><br />Example threat: An actor with a network path to the OpenSearch Service domain can directly access the domain without authentication, which may lead to allowing access to data hosted within the domain possibly impacting the confidentiality, integrity and availability of the data assets hosted on the OpenSearch Service domain for the prototype |
| RDSAutomaticMinorVersionUpgradeEnabled | The RDS DB instance does not have automatic minor version upgrades enabled. | Enable automatic minor version upgrades on your Amazon Relational Database Service (RDS) instances to ensure the latest minor version updates to the Relational Database Management System (RDBMS) are installed, which may include security patches and bug fixes.<br /><br />Example threat: An actor with a network path to the RDS cluster or instance can attempt to take advantage of a known vulnerability in a component exposed by RDS, which may lead to unknown impacts possibly impacting the confidentiality, integrity and availability of the data assets hosted on the RDS Cluster or instance for the prototype |
| RDSInstancePublicAccess | The RDS DB instance allows public access. | Amazon RDS database instances can contain sensitive information, hence appropriate access control and principles of least privilege should be applied.<br /><br />Example threat: A global internet-based actor who has discovered the RDS DB instance endpoint can perform reconnaissance and intrusion activities (e.g. brute force/dictionary attack to authenticate as a valid user) against the exposed attack surface, which may lead to possibly impacting the confidentiality, integrity and availability of the data assets hosted on the RDS Cluster or instance for the prototype |
| RDSRestrictedInbound | The RDS DB Security Group allows for 0.0.0.0/0 inbound access. | RDS DB security groups should not allow access from 0.0.0.0/0 (i.e. anywhere, every machine that has the ability to establish a connection) in order to reduce the risk of unauthorized access.<br /><br />Example threat: A global internet-based actor can discover RDS DB instances that have public IP addresses and allow ingress to all internet address or move laterally to non-public RDS DB instances, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data assets hosted on the RDS Cluster or instance for the prototype |
| RedshiftClusterInVPC | The Redshift cluster is not provisioned in a VPC. | Provisioning the cluster within a VPC allows for better flexibility and control over the Redshift clusters security, availability, traffic routing and more.<br /><br />Example threat: A global internet-based actor can discover a RedShift cluster that have public IP addresses, which may lead to reconnaissance and intrusion activities (e.g. brute force/dictionary attack to authenticate as a valid user) being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data with the cluster used within the prototype |
| RedshiftClusterPublicAccess | The Redshift cluster allows public access. | Amazon Redshift clusters can contain sensitive information, hence appropriate access control and principles of least privilege should be applied.<br /><br />Example threat: A global internet-based actor who has discovered the Redshift cluster endpoint can perform reconnaissance and intrusion activities (e.g. brute force/dictionary attack to authenticate as a valid user) against the exposed attack surface, which may lead to possibly impacting the confidentiality, integrity and availability of the data assets hosted on the Redshift cluster for the prototype |
| RedshiftClusterVersionUpgrade | The Redshift cluster does not have version upgrade enabled. | Version Upgrade must enabled on the cluster in order to automatically receive upgrades during the maintenance window.<br /><br />Example threat: An actor with a network path to the Redshift cluster can attempt to take advantage of a known vulnerability in a component exposed by Redshift, which may lead to unknown impacts possibly impacting the confidentiality, integrity and availability of the data assets hosted on the Redshift cluster for the prototype |
| S3BucketLevelPublicAccessProhibited | The S3 bucket does not prohibit public access through bucket level settings. | Keep sensitive data safe from unauthorized remote users by preventing public access at the bucket level.<br /><br />Example threat: A global internet-based actor who has discovered a S3 bucket configured for public read or write can read or write data to or from the S3 bucket, which may lead to possibly impacting the confidentiality, integrity and availability of the data assets hosted on the S3 bucket for the prototype |
| S3BucketPublicReadProhibited | The S3 Bucket does not prohibit public read access through its Block Public Access configurations and bucket ACLs. | The management of access should be consistent with the classification of the data.<br /><br />Example threat: A global internet-based actor who has discovered a S3 bucket configured for public read can read data from the S3 bucket, which may lead to possibly impacting the confidentiality of the data assets hosted on the S3 bucket for the prototype |
| S3BucketPublicWriteProhibited | The S3 Bucket does not prohibit public write access through its Block Public Access configurations and bucket ACLs. | The management of access should be consistent with the classification of the data.<br /><br />Example threat: A global internet-based actor who has discovered a S3 bucket configured for public write can write data to, or overwrite data within the S3 bucket, which may lead to possibly impacting the integrity and availability of the data assets hosted on the S3 bucket for the prototype |
| S3WebBucketOAIAccess | The S3 static website bucket either has an open world bucket policy or does not use a CloudFront Origin Access Identity (OAI) in the bucket policy for limited getObject and/or putObject permissions. | An OAI allows you to provide access to content in your S3 static website bucket through CloudFront URLs without enabling public access through an open bucket policy, disabling S3 Block Public Access settings, and/or through object ACLs.<br /><br />Example threat: A global internet-based actor who has discovered a S3 hosted website can discover prototype web assets that are hosted on the website, which may lead to recon and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| VPCSubnetAutoAssignPublicIpDisabled | The subnet auto-assigns public IP addresses. | Manage access to the AWS Cloud by ensuring Amazon Virtual Private Cloud (VPC) subnets are not automatically assigned a public IP address. Amazon Elastic Compute Cloud (EC2) instances that are launched into subnets that have this attribute enabled have a public IP address assigned to their primary network interface.<br /><br />Example threat: A global internet-based actor can discover VPC-attached resources (e.g. EC2 instances) within the subnet in question that have public IP addresses, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |

### Warnings

Total: `74`

| Rule ID | Cause | Explanation |
| ------------------ | ------------------ | ------------------ |
| APIGWAssociatedWithWAF | The REST API stage is not associated with AWS WAFv2 web ACL. | AWS WAFv2 is a web application firewall that helps protect web applications and APIs from attacks by allowing configured rules to allow, block, or monitor (count) web requests based on customizable rules and conditions that are defined. |
| APIGWAuthorization | The API does not implement authorization. | In most cases an API needs to have an authentication and authorization implementation strategy. This includes using such approaches as IAM, Cognito User Pools, Custom authorizer, etc.<br /><br />Example threat: An actor with a network path to an API gateway stage end-point can interact with the API method in question without authorization, which may lead to reconnaissance and intrusion activities being performed against the exposed attack surface possibly impacting the confidentiality, integrity and availability of the data and resource assets associated with the prototype |
| APIGWRequestValidation | The REST API does not have request validation enabled. | The API should have basic request validation enabled. If the API is integrated with a custom source (Lambda, ECS, etc..) in the backend, deeper input validation should be considered for implementation. |
| AthenaWorkgroupEncryptedQueryResults | The Athena workgroup does not encrypt query results. | Encrypting query results stored in S3 helps secure data to meet compliance requirements for data-at-rest encryption. |
| CloudFrontDistributionHttpsViewerNoOutdatedSSL | The CloudFront distribution allows for SSLv3 or TLSv1 for HTTPS viewer connections. | Vulnerabilities have been and continue to be discovered in the deprecated SSL and TLS protocols. Help protect viewer connections by specifying a viewer certificate that enforces a minimum of TLSv1.1 or TLSv1.2 in the security policy. Distributions that use that use the default CloudFront viewer certificate or use 'vip' for the SslSupportMethod are non-compliant with this rule, as the minimum security policy is set to TLSv1 regardless of the specified MinimumProtocolVersion |
| CloudFrontDistributionNoOutdatedSSL | The CloudFront distributions uses SSLv3 or TLSv1 for communication to the origin. | Vulnerabilities have been and continue to be discovered in the deprecated SSL and TLS protocols. Using a security policy with minimum TLSv1.1 or TLSv1.2 and appropriate security ciphers for HTTPS helps protect viewer connections. |
| CloudFrontDistributionWAFIntegration | The CloudFront distribution may require integration with AWS WAF. | The Web Application Firewall can help protect against application-layer attacks that can compromise the security of the system or place unnecessary load on them. |
| CodeBuildProjectKMSEncryptedArtifacts | The CodeBuild project does not use an AWS KMS key for encryption. | Using an AWS KMS key helps follow the standard security advice of granting least privilege to objects generated by the project. |
| CodeBuildProjectManagedImages | The CodeBuild project does not use images provided by the CodeBuild service or have a cdk-nag suppression rule explaining the need for a custom image. | Explaining differences/edits to Docker images helps operators better understand system dependencies. |
| CodeBuildProjectPrivilegedModeDisabled | The CodeBuild project has privileged mode enabled. | Privileged grants elevated rights to the system, which introduces additional risk. Privileged mode should only be set to true only if the build project is used to build Docker images. Otherwise, a build that attempts to interact with the Docker daemon fails. |
| CognitoUserPoolAdvancedSecurityModeEnforced | The Cognito user pool does not have AdvancedSecurityMode set to ENFORCED. | Advanced security features enable the system to detect and act upon malicious sign-in attempts. |
| CognitoUserPoolAPIGWAuthorizer | The API Gateway method does not use a Cognito user pool authorizer. | API Gateway validates the tokens from a successful user pool authentication, and uses them to grant your users access to resources including Lambda functions, or your own API. |
| CognitoUserPoolMFA | The Cognito user pool is not configured to require MFA. | Multi-factor authentication (MFA) increases security for the application by adding another authentication method, and not relying solely on user name and password. |
| DocumentDBClusterEncryptionAtRest | The Document DB cluster does not have encryption at rest enabled. | Encrypting data-at-rest protects data confidentiality and prevents unauthorized users from accessing sensitive information. |
| DocumentDBClusterNonDefaultPort | The Document DB cluster uses the default endpoint port. | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. MongoDB port 27017). |
| DAXEncrypted | The DAX cluster does not have server-side encryption enabled. | Data in cache, configuration data and log files should be encrypted using Server-Side Encryption in order to protect from unauthorized access to the underlying storage. |
| EC2EBSVolumeEncrypted | The EBS volume has encryption disabled. | With EBS encryption, you aren't required to build, maintain, and secure your own key management infrastructure. EBS encryption uses KMS keys when creating encrypted volumes and snapshots. This helps protect data at rest. |
| EC2InstanceNoPublicIp | The EC2 instance is associated with a public IP address. | Amazon EC2 instances can contain sensitive information and access control is required for such resources. |
| EC2InstanceProfileAttached | The EC2 instance does not have an instance profile attached. | EC2 instance profiles pass an IAM role to an EC2 instance. Attaching an instance profile to your instances can assist with least privilege and permissions management. |
| EC2SecurityGroupDescription | The Security Group does not have a description. | Descriptions help simplify operations and remove any opportunities for operator errors. |
| ECSTaskDefinitionContainerLogging | One or more containers in the ECS Task Definition do not have container logging enabled. | Container logging allows operators to view and aggregate the logs from the container. Containers should use the 'awslogs' driver at a minimum. |
| ECSTaskDefinitionNoEnvironmentVariables | The ECS Task Definition includes a container definition that directly specifies environment variables. | Use secrets to inject environment variables during container startup from AWS Systems Manager Parameter Store or Secrets Manager instead of directly specifying plaintext environment variables. Updates to direct environment variables require operators to change task definitions and perform new deployments. |
| EFSEncrypted | The EFS does not have encryption at rest enabled. | Because sensitive data can exist and to help protect data at rest, ensure encryption is enabled for your Amazon Elastic File System (EFS). |
| EKSClusterControlPlaneLogs | The EKS Cluster does not publish 'api', 'audit', 'authenticator, 'controllerManager', and 'scheduler' control plane logs. | EKS control plane logging provides audit and diagnostic logs directly from the Amazon EKS control plane to CloudWatch Logs in your account. These logs make it easy for you to secure and run your clusters. This is a granular rule that returns individual findings that can be suppressed with appliesTo. The findings are in the format LogExport::<log> for exported logs. Example: appliesTo: ['LogExport::authenticate']. |
| ElastiCacheClusterNonDefaultPort | The ElastiCache cluster uses the default endpoint port. | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. Redis port 6379 and Memcached port 11211). |
| ElastiCacheRedisClusterEncryption | The ElastiCache Redis cluster does not have both encryption in transit and at rest enabled. | Encryption in transit helps secure communications to the cluster. Encryption at rest helps protect data at rest from unauthorized access. |
| ElastiCacheRedisClusterRedisAuth | The ElastiCache Redis cluster does not use Redis AUTH for user authentication. | Redis authentication tokens enable Redis to require a token (password) before allowing clients to execute commands, thereby improving data security. |
| ElasticBeanstalkEC2InstanceLogsToS3 | The Elastic Beanstalk environment does not upload EC2 Instance logs to S3. | Beanstalk environment logs should be retained and uploaded to Amazon S3 in order to keep the logging data for future audits, historical purposes or to track and analyze the EB application environment behavior for a long period of time. |
| ElasticBeanstalkVPCSpecified | The Elastic Beanstalk environment is not configured to use a specific VPC. | Use a non-default VPC in order to separate your environment from default resources. |
| ALBHttpToHttpsRedirection | The ALB's HTTP listeners are not configured to redirect to HTTPS. | To help protect data in transit, ensure that your Application Load Balancer automatically redirects unencrypted HTTP requests to HTTPS. Because sensitive data can exist, enable encryption in transit to help protect that data. |
| ELBTlsHttpsListenersOnly | The CLB does not restrict its listeners to only the SSL and HTTPS protocols. | Ensure that your Classic Load Balancers (CLBs) are configured with SSL or HTTPS listeners. Because sensitive data can exist, enable encryption in transit to help protect that data. |
| EMRAuthEC2KeyPairOrKerberos | The EMR cluster does not implement authentication via an EC2 Key Pair or Kerberos. | SSH clients can use an EC2 key pair to authenticate to cluster instances. Alternatively, with EMR release version 5.10.0 or later, solutions can configure Kerberos to authenticate users and SSH connections to the master node. |
| EMREncryptionInTransit | The EMR cluster does not use a security configuration with encryption in transit enabled and configured. | EMR Clusters should have a method for encrypting data in transit using Transport Layer Security (TLS). |
| EMRLocalDiskEncryption | The EMR cluster does not use a security configuration with local disk encryption enabled. | Local disk encryption uses a combination of open-source HDFS encryption and LUKS encryption to secure data at rest. |
| GlueEncryptedCloudWatchLogs | The Glue crawler or job does not use a security configuration with CloudWatch Log encryption enabled. | Enabling encryption at rest helps prevent unauthorized users from getting access to the logging data published to CloudWatch Logs. |
| GlueJobBookmarkEncrypted | The Glue job does not have use a security configuration with job bookmark encryption enabled. | Job bookmark encryption encrypts bookmark data before it is sent to Amazon S3 for storage. |
| IAMNoManagedPolicies | The IAM user, role, or group uses AWS managed policies. | An AWS managed policy is a standalone policy that is created and administered by AWS. Currently, many AWS managed policies do not restrict resource scope. Replace AWS managed policies with system specific (customer) managed policies. This is a granular rule that returns individual findings that can be suppressed with appliesTo. The findings are in the format Policy::<policy> for AWS managed policies. Example: appliesTo: ['Policy::arn:<AWS::Partition>:iam::aws:policy/foo']. |
| IAMNoWildcardPermissions | The IAM entity contains wildcard permissions and does not have a cdk-nag rule suppression with evidence for those permission. | Metadata explaining the evidence (e.g. via supporting links) for wildcard permissions allows for transparency to operators. This is a granular rule that returns individual findings that can be suppressed with appliesTo. The findings are in the format Action::<action> for policy actions and Resource::<resource> for resources. Example: appliesTo: ['Action::s3:*']. |
| IAMPolicyNoStatementsWithFullAccess | The IAM policy grants full access - meaning the policy allows unlimited actions for a given AWS service | Ensure IAM Actions are restricted to only those actions that are needed. Allowing users to have more privileges than needed to complete a task may violate the principle of least privilege and separation of duties. |
| KinesisDataFirehoseSSE | The Kinesis Data Firehose delivery stream does not have server-side encryption enabled. | Enabling encryption allows the system to meet strict regulatory requirements and enhance the security of system data. |
| KinesisDataStreamDefaultKeyWhenSSE | The Kinesis Data Stream specifies server-side encryption and does not use the "aws/kinesis" key. | Customer Managed Keys can incur additional costs that scale with the amount of consumers and producers. Ensure that Customer Managed Keys are required for compliance before using them (https://docs.aws.amazon.com/streams/latest/dev/costs-performance.html). |
| KinesisDataStreamSSE | The Kinesis Data Stream does not have server-side encryption enabled. | Data is encrypted before it's written to the Kinesis stream storage layer, and decrypted after it’s retrieved from storage. This allows the system to meet strict regulatory requirements and enhance the security of system data. |
| KMSBackingKeyRotationEnabled | The KMS Symmetric key does not have automatic key rotation enabled. | KMS key rotation allow a system to set a rotation schedule for a KMS key so when a AWS KMS key is required to encrypt new data, the KMS service can automatically use the latest version of the HSA backing key to perform the encryption. |
| LambdaLatestVersion | The non-container Lambda function is not configured to use the latest runtime version. | Use the latest available runtime for the targeted language to avoid technical debt. Runtimes specific to a language or framework version are deprecated when the version reaches end of life. This rule only applies to non-container Lambda functions. |
| MediaStoreContainerCORSPolicy | The MediaStore container does not define a CORS policy. | Using a CORS policy helps follow the standard security advice of granting least privilege, or granting only the permissions required to allow needed access to the container. |
| MediaStoreContainerHasContainerPolicy | The MediaStore container does not define a container policy. | Using a container policy helps follow the standard security advice of granting least privilege, or granting only the permissions required to allow needed access to the container. |
| MediaStoreContainerSSLRequestsOnly | The MediaStore container does not require requests to use SSL. | You can use HTTPS (TLS) to help prevent potential attackers from eavesdropping on or manipulating network traffic using person-in-the-middle or similar attacks. You should allow only encrypted connections over HTTPS (TLS) using the aws:SecureTransport condition on MediaStore container policies. |
| MSKBrokerToBrokerTLS | The MSK cluster uses plaintext communication between brokers. | TLS communication secures data-in-transit by encrypting the connection between brokers. |
| MSKClientToBrokerTLS | The MSK cluster uses plaintext communication between clients and brokers. | TLS only communication secures data-in-transit by encrypting the connection between the clients and brokers. |
| NeptuneClusterEncryptionAtRest | The Neptune DB cluster does not have encryption at rest enabled. | Encrypting data-at-rest protects data confidentiality and prevents unauthorized users from accessing sensitive information. |
| NeptuneClusterIAMAuth | The Neptune DB cluster does not have IAM Database Authentication enabled. | With IAM Database Authentication enabled, the system doesn't have to use a password when connecting to the cluster. |
| OpenSearchAllowlistedIPs | The OpenSearch Service domain does not only grant access via allowlisted IP addresses. | Using allowlisted IP addresses helps protect the domain against unauthorized access. |
| OpenSearchEncryptedAtRest | The OpenSearch Service domain does not have encryption at rest enabled. | Because sensitive data can exist and to help protect data at rest, ensure encryption is enabled for your Amazon OpenSearch Service (OpenSearch Service) domains. |
| OpenSearchNodeToNodeEncryption | The OpenSearch Service domain does not have node-to-node encryption enabled. | Because sensitive data can exist, enable encryption in transit to help protect that data within your Amazon OpenSearch Service (OpenSearch Service) domains. |
| QuicksightSSLConnections | The Quicksight data sources connection is not configured to use SSL. | SSL secures communications to data sources, especially when using public networks. Using SSL with QuickSight requires the use of certificates signed by a publicly-recognized certificate authority. |
| AuroraMySQLPostgresIAMAuth | The RDS Aurora MySQL/PostgresSQL cluster does not have IAM Database Authentication enabled. | With IAM Database Authentication enabled, the system doesn't have to use a password when connecting to the MySQL/PostgreSQL database instances, instead it uses an authentication token. |
| RDSNonDefaultPort | The RDS instance or Aurora DB cluster uses the default endpoint port. | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. MySQL/Aurora port 3306, SQL Server port 1433, PostgreSQL port 5432, etc). |
| RDSStorageEncrypted | The RDS DB instance or Aurora DB cluster does not have encryption at rest enabled. | Because sensitive data can exist at rest in Amazon RDS DB instances, enable encryption at rest to help protect that data. |
| RedshiftClusterEncryptionAtRest | The Redshift cluster does not have encryption at rest enabled. | Encrypting data-at-rest protects data confidentiality. |
| RedshiftClusterNonDefaultPort | The Redshift cluster uses the default endpoint port. | Port obfuscation (using a non default endpoint port) adds an additional layer of defense against non-targeted attacks (i.e. Redshift port 5439). |
| RedshiftClusterNonDefaultUsername | The Redshift cluster uses the default "awsuser" username. | Using a custom user name instead of the default master user name (i.e. "awsuser") provides an additional layer of defense against non-targeted attacks. |
| RedshiftRequireTlsSSL | The Redshift cluster does not require TLS/SSL encryption. | Ensure that your Amazon Redshift clusters require TLS/SSL encryption to connect to SQL clients. Because sensitive data can exist, enable encryption in transit to help protect that data. |
| S3BucketLoggingEnabled | The S3 Bucket does not have server access logs enabled. | Amazon Simple Storage Service (Amazon S3) server access logging provides a method to monitor the network for potential cybersecurity events. The events are monitored by capturing detailed records for the requests that are made to an Amazon S3 bucket. Each access log record provides details about a single access request. The details include the requester, bucket name, request time, request action, response status, and an error code, if relevant. |
| S3BucketSSLRequestsOnly | The S3 Bucket or bucket policy does not require requests to use SSL/TLS. | You can use HTTPS (TLS) to help prevent potential attackers from eavesdropping on or manipulating network traffic using person-in-the-middle or similar attacks. You should allow only encrypted connections over HTTPS (TLS) using the aws:SecureTransport condition on Amazon S3 bucket policies. |
| SageMakerNotebookInstanceKMSKeyConfigured | The SageMaker notebook instance does not have an encrypted storage volume. | Encrypting storage volumes helps protect SageMaker data-at-rest. |
| SageMakerNotebookInVPC | The SageMaker notebook instance is not provisioned inside a VPC. | Provisioning the notebook instances inside a VPC enables the notebook to access VPC-only resources such as EFS file systems. |
| SageMakerNotebookNoDirectInternetAccess | The SageMaker notebook does not disable direct internet access. | By preventing direct internet access, you can keep sensitive data from being accessed by unauthorized users. |
| SecretsManagerRotationEnabled | The secret does not have automatic rotation scheduled. | Rotating secrets on a regular schedule can shorten the period a secret is active, and potentially reduce the business impact if the secret is compromised. |
| SNSEncryptedKMS | The SNS topic does not have KMS encryption enabled. | To help protect data at rest, ensure that your Amazon Simple Notification Service (Amazon SNS) topics require encryption using AWS Key Management Service (AWS KMS). Because sensitive data can exist at rest in published messages, enable encryption at rest to help protect that data. |
| SNSTopicSSLPublishOnly | The SNS Topic does not require publishers to use SSL. | Without HTTPS (TLS), a network-based attacker can eavesdrop on network traffic or manipulate it, using an attack such as man-in-the-middle. Allow only encrypted connections over HTTPS (TLS) using the aws:SecureTransport condition and the 'sns:Publish' action in the topic policy to force publishers to use SSL. If SSE is already enabled then this control is auto enforced. |
| SQSQueueSSE | The SQS Queue does not have server-side encryption enabled. | Server side encryption adds additional protection of sensitive data delivered as messages to subscribers. |
| SQSQueueSSLRequestsOnly | The SQS queue does not require requests to use SSL. | Without HTTPS (TLS), a network-based attacker can eavesdrop on network traffic or manipulate it, using an attack such as man-in-the-middle. Allow only encrypted connections over HTTPS (TLS) using the aws:SecureTransport condition in the queue policy to force requests to use SSL. |
| TimestreamDatabaseCustomerManagedKey | The Timestream database does not use a Customer Managed KMS Key for at rest encryption. | All Timestream tables in a database are encrypted at rest by default using an AWS Managed Key. These keys are rotated every three years. Data at rest must be encrypted using CMKs if you require more control over the permissions and lifecycle of your keys, including the ability to have them automatically rotated on an periodic basis. |
| VPCNoNACLs | A Network ACL or Network ACL entry has been implemented. | Network ACLs should be used sparingly for the following reasons: they can be complex to manage, they are stateless, every IP address must be explicitly opened in each (inbound/outbound) direction, and they affect a complete subnet. Use security groups when possible as they are stateful and easier to manage. |
