# coding: utf-8

"""
    Connection Rest API 1.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ideastatica_connection_api.models.cut_method import CutMethod
from ideastatica_connection_api.models.cut_orientation import CutOrientation
from ideastatica_connection_api.models.cut_part import CutPart
from ideastatica_connection_api.models.distance_comparison import DistanceComparison
from ideastatica_connection_api.models.reference_element import ReferenceElement
from ideastatica_connection_api.models.weld_type import WeldType
from typing import Optional, Set
from typing_extensions import Self

class CutBeamByBeamData(BaseModel):
    """
    Provides data of the cut objec by object
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Name of the cut")
    modified_object: Optional[ReferenceElement] = Field(default=None, alias="modifiedObject")
    cutting_object: Optional[ReferenceElement] = Field(default=None, alias="cuttingObject")
    is_weld: Optional[StrictBool] = Field(default=None, description="is cut welded", alias="isWeld")
    weld_thickness: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Thickness of the weld - value 0 = recommended size", alias="weldThickness")
    weld_type: Optional[WeldType] = Field(default=None, alias="weldType")
    offset: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Offset")
    method: Optional[CutMethod] = None
    orientation: Optional[CutOrientation] = None
    plane_on_cutting_object: Optional[DistanceComparison] = Field(default=None, alias="planeOnCuttingObject")
    cut_part: Optional[CutPart] = Field(default=None, alias="cutPart")
    extend_before_cut: Optional[StrictBool] = Field(default=None, description="Extend before cut - for cuts where user can decide if modified beam will be extended or not", alias="extendBeforeCut")
    __properties: ClassVar[List[str]] = ["name", "modifiedObject", "cuttingObject", "isWeld", "weldThickness", "weldType", "offset", "method", "orientation", "planeOnCuttingObject", "cutPart", "extendBeforeCut"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CutBeamByBeamData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of modified_object
        if self.modified_object:
            _dict['modifiedObject'] = self.modified_object.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cutting_object
        if self.cutting_object:
            _dict['cuttingObject'] = self.cutting_object.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CutBeamByBeamData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "modifiedObject": ReferenceElement.from_dict(obj["modifiedObject"]) if obj.get("modifiedObject") is not None else None,
            "cuttingObject": ReferenceElement.from_dict(obj["cuttingObject"]) if obj.get("cuttingObject") is not None else None,
            "isWeld": obj.get("isWeld"),
            "weldThickness": obj.get("weldThickness"),
            "weldType": obj.get("weldType"),
            "offset": obj.get("offset"),
            "method": obj.get("method"),
            "orientation": obj.get("orientation"),
            "planeOnCuttingObject": obj.get("planeOnCuttingObject"),
            "cutPart": obj.get("cutPart"),
            "extendBeforeCut": obj.get("extendBeforeCut")
        })
        return _obj


