# coding: utf-8

"""
    Connection Rest API 1.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 1.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ConMember(BaseModel):
    """
    ConMember
    """ # noqa: E501
    is_continuous: Optional[StrictBool] = Field(default=None, alias="isContinuous")
    cross_section_id: Optional[StrictInt] = Field(default=None, alias="crossSectionId")
    mirror_y: Optional[StrictBool] = Field(default=None, alias="mirrorY")
    mirror_z: Optional[StrictBool] = Field(default=None, alias="mirrorZ")
    is_bearing: Optional[StrictBool] = Field(default=None, alias="isBearing")
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["isContinuous", "crossSectionId", "mirrorY", "mirrorZ", "isBearing", "id", "name", "active"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConMember from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if cross_section_id (nullable) is None
        # and model_fields_set contains the field
        if self.cross_section_id is None and "cross_section_id" in self.model_fields_set:
            _dict['crossSectionId'] = None

        # set to None if mirror_y (nullable) is None
        # and model_fields_set contains the field
        if self.mirror_y is None and "mirror_y" in self.model_fields_set:
            _dict['mirrorY'] = None

        # set to None if mirror_z (nullable) is None
        # and model_fields_set contains the field
        if self.mirror_z is None and "mirror_z" in self.model_fields_set:
            _dict['mirrorZ'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConMember from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isContinuous": obj.get("isContinuous"),
            "crossSectionId": obj.get("crossSectionId"),
            "mirrorY": obj.get("mirrorY"),
            "mirrorZ": obj.get("mirrorZ"),
            "isBearing": obj.get("isBearing"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active")
        })
        return _obj


