"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
const pod_1 = require("./pod");
/**
 * A Job creates one or more Pods and ensures that a specified number of them successfully terminate. As pods successfully complete,
 * the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
 * Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
 * The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
 * You can also use a Job to run multiple Pods in parallel.
 */
class Job extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.apiObject = new k8s.KubeJob(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this._podTemplate = new pod_1.PodTemplate({
            ...props,
            restartPolicy: (_b = props.restartPolicy) !== null && _b !== void 0 ? _b : pod_1.RestartPolicy.NEVER,
        });
        this.activeDeadline = props.activeDeadline;
        this.backoffLimit = props.backoffLimit;
        this.ttlAfterFinished = props.ttlAfterFinished;
    }
    get podMetadata() {
        return this._podTemplate.podMetadata;
    }
    get containers() {
        return this._podTemplate.containers;
    }
    get initContainers() {
        return this._podTemplate.initContainers;
    }
    get volumes() {
        return this._podTemplate.volumes;
    }
    get restartPolicy() {
        return this._podTemplate.restartPolicy;
    }
    get serviceAccount() {
        return this._podTemplate.serviceAccount;
    }
    get securityContext() {
        return this._podTemplate.securityContext;
    }
    addContainer(container) {
        return this._podTemplate.addContainer(container);
    }
    addInitContainer(container) {
        return this._podTemplate.addInitContainer(container);
    }
    addVolume(volume) {
        return this._podTemplate.addVolume(volume);
    }
    /**
     * @internal
     */
    _toKube() {
        var _b;
        return {
            template: this._podTemplate._toPodTemplateSpec(),
            activeDeadlineSeconds: (_b = this.activeDeadline) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            backoffLimit: this.backoffLimit,
            ttlSecondsAfterFinished: this.ttlAfterFinished ? this.ttlAfterFinished.toSeconds() : undefined,
        };
    }
}
exports.Job = Job;
_a = JSII_RTTI_SYMBOL_1;
Job[_a] = { fqn: "cdk8s-plus-22.Job", version: "1.0.0-beta.155" };
//# sourceMappingURL=data:application/json;base64,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