"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = exports.flatten = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const utils_1 = require("./utils");
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
function flatten(object) {
    return Object.assign({}, ...function _flatten(child, path = []) {
        return [].concat(...Object.keys(child)
            .map(key => {
            let childKey = Buffer.isBuffer(child[key]) ? child[key].toString('utf8') : child[key];
            // if the value is a json string then treat it as an object
            // and keep recursing. This allows for easier assertions against complex json strings
            if (typeof childKey === 'string') {
                childKey = isJsonString(childKey);
            }
            return typeof childKey === 'object' && childKey !== null
                ? _flatten(childKey, path.concat([key]))
                : ({ [path.concat([key]).join('.')]: childKey });
        }));
    }(object));
}
exports.flatten = flatten;
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        // eslint-disable-next-line
        const AWS = require('aws-sdk');
        console.log(`AWS SDK VERSION: ${AWS.VERSION}`);
        if (!Object.prototype.hasOwnProperty.call(AWS, request.service)) {
            throw Error(`Service ${request.service} does not exist in AWS SDK version ${AWS.VERSION}.`);
        }
        const service = new AWS[request.service]();
        const response = await service[request.api](request.parameters && (0, utils_1.decode)(request.parameters)).promise();
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.ResponseMetadata;
        const respond = {
            apiCallResponse: response,
        };
        const flatData = {
            ...flatten(respond),
        };
        let resp = respond;
        if (request.outputPaths) {
            resp = filterKeys(flatData, request.outputPaths);
        }
        else if (request.flattenResponse === 'true') {
            resp = flatData;
        }
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
function filterKeys(object, searchStrings) {
    return Object.entries(object).reduce((filteredObject, [key, value]) => {
        for (const searchString of searchStrings) {
            if (key.startsWith(`apiCallResponse.${searchString}`)) {
                filteredObject[key] = value;
            }
        }
        return filteredObject;
    }, {});
}
function isJsonString(value) {
    try {
        return JSON.parse(value);
    }
    catch {
        return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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