"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontendWebAppDeployStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_cloudfront_origin_bucket_1 = require("@gammarer/aws-secure-cloudfront-origin-bucket");
const aws_secure_frontend_web_app_cloudfront_distribution_1 = require("@gammarer/aws-secure-frontend-web-app-cloudfront-distribution");
const cdk = require("aws-cdk-lib");
const acm = require("aws-cdk-lib/aws-certificatemanager");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const route53 = require("aws-cdk-lib/aws-route53");
const alias = require("aws-cdk-lib/aws-route53-targets");
const s3 = require("aws-cdk-lib/aws-s3");
const s3deploy = require("aws-cdk-lib/aws-s3-deployment");
class FrontendWebAppDeployStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // 👇Create CloudFront Origin Access Identity.
        const oai = new cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        // 👇Create Secure Cloud Front Origin Bucket
        const originBucket = new aws_secure_cloudfront_origin_bucket_1.SecureCloudFrontOriginBucket(this, 'SecureCloudFrontOriginBucket', {
            bucketName: props.originBucketName,
            cloudFrontOriginAccessIdentityS3CanonicalUserId: oai.cloudFrontOriginAccessIdentityS3CanonicalUserId,
        });
        // 👇Get Hosted Zone.
        const hostedZone = route53.HostedZone.fromHostedZoneAttributes(this, 'HostedZone', {
            hostedZoneId: props.hostedZoneId,
            zoneName: props.domainName,
        });
        // 👇Create Certificate with DNS validate.
        const certificate = new acm.Certificate(this, 'Certificate', {
            domainName: props.domainName,
            validation: acm.CertificateValidation.fromDns(hostedZone),
        });
        // 👇Secure Frontend Web App CloudFront Distribution.
        const distribution = new aws_secure_frontend_web_app_cloudfront_distribution_1.SecureFrontendWebAppCloudFrontDistribution(this, 'SecureFrontendWebAppCloudFrontDistribution', {
            comment: 'frontend web app distribution.',
            accessLogBucket: s3.Bucket.fromBucketArn(this, 'LogBucket', props.logBucketArn),
            certificate: certificate,
            domainName: props.domainName,
            originAccessIdentity: oai,
            originBucket: originBucket,
        });
        // 👇Route 53 DNS (Alias)
        new route53.ARecord(this, 'DNSARecord', {
            zone: hostedZone,
            recordName: props.domainName,
            target: route53.RecordTarget.fromAlias(new alias.CloudFrontTarget(distribution)),
            ttl: cdk.Duration.seconds(300),
        });
        // 👇Deploy to Bucket with CloudFront Cache invalidate
        new s3deploy.BucketDeployment(this, 'DeployWithInvalidation', {
            sources: [s3deploy.Source.asset(props.deploySourceAssetPath)],
            destinationBucket: originBucket,
            prune: true,
            distribution,
            distributionPaths: ['/*'],
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
FrontendWebAppDeployStack[_a] = { fqn: "@gammarer/aws-frontend-web-app-deploy-stack.FrontendWebAppDeployStack", version: "0.7.0" };
exports.FrontendWebAppDeployStack = FrontendWebAppDeployStack;
//# sourceMappingURL=data:application/json;base64,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