# Generated by Django 2.2 on 2022-07-12 16:07

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='App',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('version', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), blank=True, default=list, size=None, verbose_name='Version')),
                ('family', models.CharField(blank=True, db_index=True, max_length=1024, verbose_name='Family')),
            ],
            options={
                'verbose_name': 'App',
                'verbose_name_plural': 'Apps',
            },
        ),
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('family', models.CharField(blank=True, db_index=True, max_length=1024, verbose_name='Family')),
                ('brand', models.CharField(blank=True, db_index=True, max_length=1024, verbose_name='Brand')),
                ('model', models.CharField(blank=True, db_index=True, max_length=1024, verbose_name='Model')),
                ('bitness', models.CharField(blank=True, db_index=True, max_length=24, verbose_name='Bitness')),
                ('memory', models.DecimalField(blank=True, decimal_places=4, max_digits=28, null=True, verbose_name='Memory')),
                ('dpr', models.DecimalField(decimal_places=6, default=1, max_digits=28, verbose_name='DPR')),
                ('viewport_width', models.IntegerField(blank=True, null=True, verbose_name='Viewport width')),
            ],
            options={
                'verbose_name': 'Device',
                'verbose_name_plural': 'Devices',
            },
        ),
        migrations.CreateModel(
            name='Interlocutor',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('outer_id', models.TextField(blank=True, verbose_name='Device/App identifier')),
                ('user_agent', models.TextField(blank=True, verbose_name='User Agent string')),
                ('client_hints', django.contrib.postgres.fields.jsonb.JSONField(default=dict, verbose_name='Client hints')),
                ('app', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='interlocutors', to='wcd_device_recognizer.App', verbose_name='App')),
                ('device', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='interlocutors', to='wcd_device_recognizer.Device', verbose_name='Device')),
            ],
            options={
                'verbose_name': 'Interlocutor',
                'verbose_name_plural': 'Interlocutors',
            },
        ),
        migrations.CreateModel(
            name='OS',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('version', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), blank=True, default=list, size=None, verbose_name='Version')),
                ('family', models.CharField(blank=True, db_index=True, max_length=1024, verbose_name='Family')),
                ('arch', models.CharField(blank=True, db_index=True, max_length=24, verbose_name='Architecture')),
            ],
            options={
                'verbose_name': 'OS',
                'verbose_name_plural': 'OSs',
            },
        ),
        migrations.CreateModel(
            name='InterlocutorNetwork',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('ip', models.GenericIPAddressField(verbose_name='IP Address')),
                ('interlocutor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='network_connections', to='wcd_device_recognizer.Interlocutor', verbose_name='Interlocutor')),
            ],
            options={
                'verbose_name': 'Interlocutor network info',
                'verbose_name_plural': 'Interlocutor network infos',
            },
        ),
        migrations.AddField(
            model_name='interlocutor',
            name='os',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='interlocutors', to='wcd_device_recognizer.OS', verbose_name='OS'),
        ),
    ]
