/*
 * # Fomantic UI - 2.8.8
 * https://github.com/fomantic/Fomantic-UI
 * http://fomantic-ui.com/
 *
 * Copyright 2025 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(B,R,P,W){"use strict";B.isFunction=B.isFunction||function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},R=void 0!==R&&R.Math==Math?R:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),B.fn.modal=function(T){var A,e=B(this),H=B(R),D=B(P),O=B("body"),E=e.selector||"",L=(new Date).getTime(),N=[],z=T,j="string"==typeof z,q=[].slice.call(arguments,1),I=R.requestAnimationFrame||R.mozRequestAnimationFrame||R.webkitRequestAnimationFrame||R.msRequestAnimationFrame||function(e){setTimeout(e,0)};return e.each(function(){var o,s,e,i,n,a,c,t,r,l,d,u=B.isPlainObject(T)?B.extend(!0,{},B.fn.modal.settings,T):B.extend({},B.fn.modal.settings),m=u.selector,f=u.className,h=u.namespace,g=u.fields,p=u.error,v="."+h,b="module-"+h,y=B(this),x=B(u.context),k=y.find(m.close),w=this,C=y.hasClass("modal")?y.data(b):W,S=!1,F="",M="";d={initialize:function(){if(y.hasClass("modal")||(d.create.modal(),B.isFunction(u.onHidden)||(u.onHidden=function(){d.destroy(),y.remove()})),y.addClass(u.class),""!==u.title&&y.find(m.title).html(d.helpers.escape(u.title,u.preserveHTML)).addClass(u.classTitle),""!==u.content&&y.find(m.content).html(d.helpers.escape(u.content,u.preserveHTML)).addClass(u.classContent),d.has.configActions()){var s=y.find(m.actions).addClass(u.classActions);0===s.length?s=B("<div/>",{class:f.actions+" "+(u.classActions||"")}).appendTo(y):s.empty(),u.actions.forEach(function(e){var t=e[g.icon]?'<i class="'+d.helpers.deQuote(e[g.icon])+' icon"></i>':"",n=d.helpers.escape(e[g.text]||"",u.preserveHTML),i=d.helpers.deQuote(e[g.class]||""),o=e[g.click]&&B.isFunction(e[g.click])?e[g.click]:function(){};s.append(B("<button/>",{html:t+n,class:f.button+" "+i,click:function(){!1!==o.call(w,y)&&d.hide()}}))})}d.cache={},d.verbose("Initializing dimmer",x),d.create.id(),d.create.dimmer(),u.allowMultiple&&d.create.innerDimmer(),u.centered||y.addClass("top aligned"),d.refreshModals(),d.bind.events(),u.observeChanges&&d.observeChanges(),d.instantiate(),u.autoShow&&d.show()},instantiate:function(){d.verbose("Storing instance of modal"),C=d,y.data(b,C)},create:{modal:function(){y=B("<div/>",{class:f.modal}),u.closeIcon&&(k=B("<i/>",{class:f.close}),y.append(k)),""!==u.title&&B("<div/>",{class:f.title}).appendTo(y),""!==u.content&&B("<div/>",{class:f.content}).appendTo(y),d.has.configActions()&&B("<div/>",{class:f.actions}).appendTo(y),x.append(y)},dimmer:function(){var e={debug:u.debug,dimmerName:"modals"},t=B.extend(!0,e,u.dimmerSettings);B.fn.dimmer!==W?(d.debug("Creating dimmer"),i=x.dimmer(t),u.detachable?(d.verbose("Modal is detachable, moving content into dimmer"),i.dimmer("add content",y)):d.set.undetached(),n=i.dimmer("get dimmer")):d.error(p.dimmer)},id:function(){r=(Math.random().toString(16)+"000000000").substr(2,8),t="."+r,d.verbose("Creating unique id for element",r)},innerDimmer:function(){0==y.find(m.dimmer).length&&y.prepend('<div class="ui inverted dimmer"></div>')}},destroy:function(){l&&l.disconnect(),d.verbose("Destroying previous modal"),y.removeData(b).off(v),H.off(t),n.off(t),k.off(v),x.dimmer("destroy")},observeChanges:function(){"MutationObserver"in R&&((l=new MutationObserver(function(e){d.debug("DOM tree modified, refreshing"),d.refresh()})).observe(w,{childList:!0,subtree:!0}),d.debug("Setting up mutation observer",l))},refresh:function(){d.remove.scrolling(),d.cacheSizes(),d.can.useFlex()||d.set.modalOffset(),d.set.screenHeight(),d.set.type()},refreshModals:function(){s=y.siblings(m.modal),o=s.add(y)},attachEvents:function(e,t){var n=B(e);t=B.isFunction(d[t])?d[t]:d.toggle,0<n.length?(d.debug("Attaching modal events to element",e,t),n.off(v).on("click"+v,t)):d.error(p.notFound,e)},bind:{events:function(){d.verbose("Attaching events"),y.on("click"+v,m.close,d.event.close).on("click"+v,m.approve,d.event.approve).on("click"+v,m.deny,d.event.deny),H.on("resize"+t,d.event.resize)},scrollLock:function(){i.get(0).addEventListener("touchmove",d.event.preventScroll,{passive:!1})}},unbind:{scrollLock:function(){i.get(0).removeEventListener("touchmove",d.event.preventScroll,{passive:!1})}},get:{id:function(){return(Math.random().toString(16)+"000000000").substr(2,8)},element:function(){return y},settings:function(){return u}},event:{approve:function(){S||!1===u.onApprove.call(w,B(this))?d.verbose("Approve callback returned false cancelling hide"):(S=!0,d.hide(function(){S=!1}))},preventScroll:function(e){-1!==e.target.className.indexOf("dimmer")&&e.preventDefault()},deny:function(){S||!1===u.onDeny.call(w,B(this))?d.verbose("Deny callback returned false cancelling hide"):(S=!0,d.hide(function(){S=!1}))},close:function(){d.hide()},mousedown:function(e){var t=B(e.target),n=d.is.rtl();(a=0<t.closest(m.modal).length)&&d.verbose("Mouse down event registered inside the modal"),(c=d.is.scrolling()&&(!n&&B(R).outerWidth()-u.scrollbarWidth<=e.clientX||n&&u.scrollbarWidth>=e.clientX))&&d.verbose("Mouse down event registered inside the scrollbar")},mouseup:function(e){if(u.closable)if(a)d.debug("Dimmer clicked but mouse down was initially registered inside the modal");else if(c)d.debug("Dimmer clicked but mouse down was initially registered inside the scrollbar");else{var t=0<B(e.target).closest(m.modal).length,n=B.contains(P.documentElement,e.target);if(!t&&n&&d.is.active()&&y.hasClass(f.front)){if(d.debug("Dimmer clicked, hiding all modals"),u.allowMultiple){if(!d.hideAll())return}else if(!d.hide())return;d.remove.clickaway()}}else d.verbose("Dimmer clicked but closable setting is disabled")},debounce:function(e,t){clearTimeout(d.timer),d.timer=setTimeout(e,t)},keyboard:function(e){27==e.which&&(u.closable?(d.debug("Escape key pressed hiding modal"),y.hasClass(f.front)&&d.hide()):d.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){i.dimmer("is active")&&(d.is.animating()||d.is.active())&&I(d.refresh)}},toggle:function(){d.is.active()||d.is.animating()?d.hide():d.show()},show:function(e){e=B.isFunction(e)?e:function(){},d.refreshModals(),d.set.dimmerSettings(),d.set.dimmerStyles(),d.showModal(e)},hide:function(e){return e=B.isFunction(e)?e:function(){},d.refreshModals(),d.hideModal(e)},showModal:function(e){e=B.isFunction(e)?e:function(){},d.is.animating()||!d.is.active()?(d.showDimmer(),d.cacheSizes(),d.set.bodyMargin(),d.can.useFlex()?d.remove.legacy():(d.set.legacy(),d.set.modalOffset(),d.debug("Using non-flex legacy modal positioning.")),d.set.screenHeight(),d.set.type(),d.set.clickaway(),!u.allowMultiple&&d.others.active()?d.hideOthers(d.showModal):(S=!1,u.allowMultiple&&(d.others.active()&&s.filter("."+f.active).find(m.dimmer).addClass("active"),u.detachable&&y.detach().appendTo(n)),u.onShow.call(w),u.transition&&B.fn.transition!==W&&y.transition("is supported")?(d.debug("Showing modal with css animations"),y.transition({debug:u.debug,animation:(u.transition.showMethod||u.transition)+" in",queue:u.queue,duration:u.transition.showDuration||u.duration,useFailSafe:!0,onComplete:function(){u.onVisible.apply(w),u.keyboardShortcuts&&d.add.keyboardShortcuts(),d.save.focus(),d.set.active(),u.autofocus&&d.set.autofocus(),e()}})):d.error(p.noTransition))):d.debug("Modal is already visible")},hideModal:function(e,t,n){var i=s.filter("."+f.active).last();if(e=B.isFunction(e)?e:function(){},d.debug("Hiding modal"),!1===u.onHide.call(w,B(this)))return d.verbose("Hide callback returned false cancelling hide"),S=!1;(d.is.animating()||d.is.active())&&(u.transition&&B.fn.transition!==W&&y.transition("is supported")?(d.remove.active(),y.transition({debug:u.debug,animation:(u.transition.hideMethod||u.transition)+" out",queue:u.queue,duration:u.transition.hideDuration||u.duration,useFailSafe:!0,onStart:function(){d.others.active()||d.others.animating()||t||d.hideDimmer(),u.keyboardShortcuts&&!d.others.active()&&d.remove.keyboardShortcuts()},onComplete:function(){d.unbind.scrollLock(),u.allowMultiple&&(i.addClass(f.front),y.removeClass(f.front),n?o.find(m.dimmer).removeClass("active"):i.find(m.dimmer).removeClass("active")),B.isFunction(u.onHidden)&&u.onHidden.call(w),d.remove.dimmerStyles(),d.restore.focus(),e()}})):d.error(p.noTransition))},showDimmer:function(){i.dimmer("is animating")||!i.dimmer("is active")?(d.save.bodyMargin(),d.debug("Showing dimmer"),i.dimmer("show")):d.debug("Dimmer already visible")},hideDimmer:function(){i.dimmer("is animating")||i.dimmer("is active")?(d.unbind.scrollLock(),i.dimmer("hide",function(){d.restore.bodyMargin(),d.remove.clickaway(),d.remove.screenHeight()})):d.debug("Dimmer is not visible cannot hide")},hideAll:function(n){var e=o.filter("."+f.active+", ."+f.animating);if(n=B.isFunction(n)?n:function(){},0<e.length){d.debug("Hiding all visible modals");var i=!0;return B(e.get().reverse()).each(function(e,t){i=i&&B(t).modal("hide modal",n,!1,!0)}),i&&d.hideDimmer(),i}},hideOthers:function(e){var t=s.filter("."+f.active+", ."+f.animating);e=B.isFunction(e)?e:function(){},0<t.length&&(d.debug("Hiding other modals",s),t.modal("hide modal",e,!0))},others:{active:function(){return 0<s.filter("."+f.active).length},animating:function(){return 0<s.filter("."+f.animating).length}},add:{keyboardShortcuts:function(){d.verbose("Adding keyboard shortcuts"),D.on("keyup"+v,d.event.keyboard)}},save:{focus:function(){0<B(P.activeElement).closest(y).length||(e=B(P.activeElement).blur())},bodyMargin:function(){F=O.css("margin-"+(d.can.leftBodyScrollbar()?"left":"right"));var e=parseInt(F.replace(/[^\d.]/g,"")),t=R.innerWidth-P.documentElement.clientWidth;M=e+t}},restore:{focus:function(){e&&0<e.length&&u.restoreFocus&&e.focus()},bodyMargin:function(){var n=d.can.leftBodyScrollbar()?"left":"right";O.css("margin-"+n,F),O.find(m.bodyFixed.replace("right",n)).each(function(){var e=B(this),t="fixed"===e.css("position")?"padding-"+n:n;e.css(t,"")})}},remove:{active:function(){y.removeClass(f.active)},legacy:function(){y.removeClass(f.legacy)},clickaway:function(){u.detachable||y.off("mousedown"+t),n.off("mousedown"+t),n.off("mouseup"+t)},dimmerStyles:function(){n.removeClass(f.inverted),i.removeClass(f.blurring)},bodyStyle:function(){""===O.attr("style")&&(d.verbose("Removing style attribute"),O.removeAttr("style"))},screenHeight:function(){d.debug("Removing page height"),O.css("height","")},keyboardShortcuts:function(){d.verbose("Removing keyboard shortcuts"),D.off("keyup"+v)},scrolling:function(){i.removeClass(f.scrolling),y.removeClass(f.scrolling)}},cacheSizes:function(){y.addClass(f.loading);var e=y.prop("scrollHeight"),t=y.outerWidth(),n=y.outerHeight();d.cache.pageHeight!==W&&0===n||(B.extend(d.cache,{pageHeight:B(P).outerHeight(),width:t,height:n+u.offset,scrollHeight:e+u.offset,contextHeight:"body"==u.context?B(R).height():i.height()}),d.cache.topOffset=-d.cache.height/2),y.removeClass(f.loading),d.debug("Caching modal and container sizes",d.cache)},helpers:{deQuote:function(e){return String(e).replace(/"/g,"")},escape:function(e,t){if(t)return e;var n={"<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"};return/[&<>"'`]/.test(e)?(e=e.replace(/&(?![a-z0-9#]{1,6};)/,"&amp;")).replace(/[<>"'`]/g,function(e){return n[e]}):e}},can:{leftBodyScrollbar:function(){return d.cache.leftBodyScrollbar===W&&(d.cache.leftBodyScrollbar=d.is.rtl()&&(d.is.iframe&&!d.is.firefox()||d.is.safari()||d.is.edge()||d.is.ie())),d.cache.leftBodyScrollbar},useFlex:function(){return"auto"===u.useFlex?u.detachable&&!d.is.ie():(u.useFlex&&d.is.ie()?d.debug("useFlex true is not supported in IE"):u.useFlex&&!u.detachable&&d.debug("useFlex true in combination with detachable false is not supported"),u.useFlex)},fit:function(){var e=d.cache.contextHeight,t=d.cache.contextHeight/2,n=d.cache.topOffset,i=d.cache.scrollHeight,o=d.cache.height,s=u.padding;return o<i?t+n+i+s<e:o+2*s<e}},has:{configActions:function(){return Array.isArray(u.actions)&&0<u.actions.length}},is:{active:function(){return y.hasClass(f.active)},ie:function(){if(d.cache.isIE===W){var e=!R.ActiveXObject&&"ActiveXObject"in R,t="ActiveXObject"in R;d.cache.isIE=e||t}return d.cache.isIE},animating:function(){return y.transition("is supported")?y.transition("is animating"):y.is(":visible")},scrolling:function(){return i.hasClass(f.scrolling)},modernBrowser:function(){return!(R.ActiveXObject||"ActiveXObject"in R)},rtl:function(){return d.cache.isRTL===W&&(d.cache.isRTL="rtl"===O.attr("dir")||"rtl"===O.css("direction")),d.cache.isRTL},safari:function(){return d.cache.isSafari===W&&(d.cache.isSafari=/constructor/i.test(R.HTMLElement)||!!R.ApplePaySession),d.cache.isSafari},edge:function(){return d.cache.isEdge===W&&(d.cache.isEdge=!!R.setImmediate&&!d.is.ie()),d.cache.isEdge},firefox:function(){return d.cache.isFirefox===W&&(d.cache.isFirefox=!!R.InstallTrigger),d.cache.isFirefox},iframe:function(){return!(self===top)}},set:{autofocus:function(){var e=y.find("[tabindex], :input").filter(":visible").filter(function(){return 0===B(this).closest(".disabled").length}),t=e.filter("[autofocus]"),n=0<t.length?t.first():e.first();0<n.length&&n.focus()},bodyMargin:function(){var n=d.can.leftBodyScrollbar()?"left":"right";(u.detachable||d.can.fit())&&O.css("margin-"+n,M+"px"),O.find(m.bodyFixed.replace("right",n)).each(function(){var e=B(this),t="fixed"===e.css("position")?"padding-"+n:n;e.css(t,"calc("+e.css(t)+" + "+M+"px)")})},clickaway:function(){u.detachable||y.on("mousedown"+t,d.event.mousedown),n.on("mousedown"+t,d.event.mousedown),n.on("mouseup"+t,d.event.mouseup)},dimmerSettings:function(){if(B.fn.dimmer!==W){var e={debug:u.debug,dimmerName:"modals",closable:"auto",useFlex:d.can.useFlex(),duration:{show:u.transition.showDuration||u.duration,hide:u.transition.hideDuration||u.duration}},t=B.extend(!0,e,u.dimmerSettings);u.inverted&&(t.variation=t.variation!==W?t.variation+" inverted":"inverted"),x.dimmer("setting",t)}else d.error(p.dimmer)},dimmerStyles:function(){u.inverted?n.addClass(f.inverted):n.removeClass(f.inverted),u.blurring?i.addClass(f.blurring):i.removeClass(f.blurring)},modalOffset:function(){if(u.detachable)y.css({marginTop:!y.hasClass("aligned")&&d.can.fit()?-d.cache.height/2:u.padding/2,marginLeft:-d.cache.width/2});else{var e=d.can.fit();y.css({top:!y.hasClass("aligned")&&e?B(P).scrollTop()+(d.cache.contextHeight-d.cache.height)/2:!e||y.hasClass("top")?B(P).scrollTop()+u.padding:B(P).scrollTop()+(d.cache.contextHeight-d.cache.height-u.padding),marginLeft:-d.cache.width/2})}d.verbose("Setting modal offset for legacy mode")},screenHeight:function(){d.can.fit()?O.css("height",""):y.hasClass("bottom")||(d.debug("Modal is taller than page content, resizing page height"),O.css("height",d.cache.height+2*u.padding))},active:function(){y.addClass(f.active+" "+f.front),s.filter("."+f.active).removeClass(f.front)},scrolling:function(){i.addClass(f.scrolling),y.addClass(f.scrolling),d.unbind.scrollLock()},legacy:function(){y.addClass(f.legacy)},type:function(){d.can.fit()?(d.verbose("Modal fits on screen"),d.others.active()||d.others.animating()||(d.remove.scrolling(),d.bind.scrollLock())):y.hasClass("bottom")?d.verbose("Bottom aligned modal not fitting on screen is unsupported for scrolling"):(d.verbose("Modal cannot fit on screen setting to scrolling"),d.set.scrolling())},undetached:function(){i.addClass(f.undetached)}},setting:function(e,t){if(d.debug("Changing setting",e,t),B.isPlainObject(e))B.extend(!0,u,e);else{if(t===W)return u[e];B.isPlainObject(u[e])?B.extend(!0,u[e],t):u[e]=t}},internal:function(e,t){if(B.isPlainObject(e))B.extend(!0,d,e);else{if(t===W)return d[e];d[e]=t}},debug:function(){!u.silent&&u.debug&&(u.performance?d.performance.log(arguments):(d.debug=Function.prototype.bind.call(console.info,console,u.name+":"),d.debug.apply(console,arguments)))},verbose:function(){!u.silent&&u.verbose&&u.debug&&(u.performance?d.performance.log(arguments):(d.verbose=Function.prototype.bind.call(console.info,console,u.name+":"),d.verbose.apply(console,arguments)))},error:function(){u.silent||(d.error=Function.prototype.bind.call(console.error,console,u.name+":"),d.error.apply(console,arguments))},performance:{log:function(e){var t,n;u.performance&&(n=(t=(new Date).getTime())-(L||t),L=t,N.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:w,"Execution Time":n})),clearTimeout(d.performance.timer),d.performance.timer=setTimeout(d.performance.display,500)},display:function(){var e=u.name+":",n=0;L=!1,clearTimeout(d.performance.timer),B.each(N,function(e,t){n+=t["Execution Time"]}),e+=" "+n+"ms",E&&(e+=" '"+E+"'"),(console.group!==W||console.table!==W)&&0<N.length&&(console.groupCollapsed(e),console.table?console.table(N):B.each(N,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),N=[]}},invoke:function(i,e,t){var o,s,n,a=C;return e=e||q,t=w||t,"string"==typeof i&&a!==W&&(i=i.split(/[\. ]/),o=i.length-1,B.each(i,function(e,t){var n=e!=o?t+i[e+1].charAt(0).toUpperCase()+i[e+1].slice(1):i;if(B.isPlainObject(a[n])&&e!=o)a=a[n];else{if(a[n]!==W)return s=a[n],!1;if(!B.isPlainObject(a[t])||e==o)return a[t]!==W&&(s=a[t]),!1;a=a[t]}})),B.isFunction(s)?n=s.apply(t,e):s!==W&&(n=s),Array.isArray(A)?A.push(n):A!==W?A=[A,n]:n!==W&&(A=n),s}},j?(C===W&&(B.isFunction(u.templates[z])&&(u.autoShow=!0,u.className.modal=u.className.template,u=B.extend(!0,{},u,u.templates[z].apply(d,q)),f=u.className,h=u.namespace,g=u.fields,p=u.error),d.initialize()),B.isFunction(u.templates[z])||d.invoke(z)):(C!==W&&C.invoke("destroy"),d.initialize(),A=y)}),A!==W?A:this},B.fn.modal.settings={name:"Modal",namespace:"modal",useFlex:"auto",offset:0,silent:!1,debug:!1,verbose:!1,performance:!0,observeChanges:!1,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,restoreFocus:!0,autoShow:!1,inverted:!1,blurring:!1,centered:!0,dimmerSettings:{closable:!1,useCSS:!0},keyboardShortcuts:!0,context:"body",queue:!1,duration:500,transition:"scale",padding:50,scrollbarWidth:10,title:"",content:"",class:"",classTitle:"",classContent:"",classActions:"",closeIcon:!1,actions:!1,preserveHTML:!0,fields:{class:"class",text:"text",icon:"icon",click:"click"},onShow:function(){},onVisible:function(){},onHide:function(){return!0},onHidden:!1,onApprove:function(){return!0},onDeny:function(){return!0},selector:{title:"> .header",content:"> .content",actions:"> .actions",close:"> .close",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal",dimmer:"> .ui.dimmer",bodyFixed:"> .ui.fixed.menu, > .ui.right.toast-container, > .ui.right.sidebar, > .ui.fixed.nag, > .ui.fixed.nag > .close",prompt:".ui.input > input"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",blurring:"blurring",inverted:"inverted",legacy:"legacy",loading:"loading",scrolling:"scrolling",undetached:"undetached",front:"front",close:"close icon",button:"ui button",modal:"ui modal",title:"header",content:"content",actions:"actions",template:"ui tiny modal",ok:"positive",cancel:"negative",prompt:"ui fluid input"},text:{ok:"Ok",cancel:"Cancel"}},B.fn.modal.settings.templates={getArguments:function(e){var t=[].slice.call(e);return B.isPlainObject(t[0])?B.extend({handler:function(){},content:"",title:""},t[0]):(B.isFunction(t[t.length-1])||t.push(function(){}),{handler:t.pop(),content:t.pop()||"",title:t.pop()||""})},alert:function(){var e=this.get.settings(),t=e.templates.getArguments(arguments);return{title:t.title,content:t.content,actions:[{text:e.text.ok,class:e.className.ok,click:t.handler}]}},confirm:function(){var e=this.get.settings(),t=e.templates.getArguments(arguments);return{title:t.title,content:t.content,actions:[{text:e.text.ok,class:e.className.ok,click:function(){t.handler(!0)}},{text:e.text.cancel,class:e.className.cancel,click:function(){t.handler(!1)}}]}},prompt:function(){var n=this,e=this.get.settings(),i=e.templates.getArguments(arguments);return 0===B(B.parseHTML(i.content)).filter(".ui.input").length&&(i.content+='<p><div class="'+e.className.prompt+'"><input placeholder="'+this.helpers.deQuote(i.placeholder||"")+'" type="text" value="'+this.helpers.deQuote(i.defaultValue||"")+'"></div></p>'),{title:i.title,content:i.content,actions:[{text:e.text.ok,class:e.className.ok,click:function(){var e=n.get.settings(),t=n.get.element().find(e.selector.prompt)[0];i.handler(B(t).val())}},{text:e.text.cancel,class:e.className.cancel,click:function(){i.handler(null)}}]}}}}(jQuery,window,document);