import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface ServiceNowConnectorProfileProps extends ConnectorProfileProps {
    readonly basicAuth: ServiceNowBasicSettings;
    readonly instanceUrl: string;
}
export interface ServiceNowBasicSettings {
    readonly username: string;
    readonly password: string;
}
export declare class ServiceNowConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): ServiceNowConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): ServiceNowConnectorProfile;
    constructor(scope: Construct, id: string, props: ServiceNowConnectorProfileProps);
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
}
