import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SAPOdataConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices/source';
export interface SAPOdataSourceProps {
    readonly profile: SAPOdataConnectorProfile;
    readonly object: string;
}
export declare class SAPOdataSource implements ISource {
    private readonly props;
    readonly connectorType: ConnectorType;
    constructor(props: SAPOdataSourceProps);
    bind(flow: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
