"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SAPOdataConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SAPOdataConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        let sapOdata = {};
        if (properties.basicAuth) {
            sapOdata.basicAuthCredentials = {
                username: properties.basicAuth.username,
                password: properties.basicAuth.password,
            };
        }
        else if (properties.oAuth) {
            sapOdata.oAuthCredentials = {
                accessToken: properties.oAuth.accessToken,
                refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken,
                clientId: properties.oAuth.flow?.refreshTokenGrant.clientId,
                clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret,
            };
        }
        return {
            sapoData: sapOdata,
        };
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            sapoData: {
                applicationHostUrl: properties.applicationHostUrl,
                applicationServicePath: properties.applicationServicePath,
                portNumber: properties.portNumber,
                clientNumber: properties.clientNumber,
                logonLanguage: properties.logonLanguage,
            },
        };
    }
}
exports.SAPOdataConnectorProfile = SAPOdataConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataConnectorProfile", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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