"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SAPOdataDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
class SAPOdataDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SAPOdataConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        this.tryAddNodeDependency(flow, this.props.successResponseHandling?.location.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.successResponseHandling?.location.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            sapoData: {
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                successResponseHandlingConfig: this.props.successResponseHandling?.location && {
                    bucketName: this.props.successResponseHandling.location.bucket.bucketName,
                },
                idFieldNames: this.props.operation.ids,
                objectPath: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.SAPOdataDestination = SAPOdataDestination;
_a = JSII_RTTI_SYMBOL_1;
SAPOdataDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SAPOdataDestination", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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