"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class SalesforceConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceConnectorType.instance);
        this.tryAddNodeDependency(this, this.getRefreshTokenGrantFlowProperty(props.oAuth.flow)?.client);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(properties) {
        const props = properties;
        return {
            salesforce: {
                isSandboxEnvironment: props.isSandbox,
                instanceUrl: props.instanceUrl,
            },
        };
    }
    /**
     * This is a auxiliary method for obtaining a refreshTokeNGrandFlow. It's a temporary solution due to the typo in the properties
     * as we don't want to abruptly fail customer solutions depending on the library.
     * @param flow a SalesforceOAuthFlow object
     * @returns a SalesforceOAuthRefreshTokenGrantFlow object or undefined if the flow is undefined.
     * @throws an error if both refreshTokenGrant and refresTokenGrant are specified. This is a temporary solution due to the typo in the properties.
     * @deprecated - this method will be removed in the future releases.
     */
    getRefreshTokenGrantFlowProperty(flow) {
        if (flow) {
            if (flow.refresTokenGrant && flow.refreshTokenGrant) {
                throw new Error('Only one of the properties refreshTokenGrant or refresTokenGrant should be specified');
            }
            return flow.refresTokenGrant ?? flow.refreshTokenGrant;
        }
        return undefined;
    }
    buildConnectorProfileCredentials(properties) {
        const props = properties;
        let salesforce = {};
        salesforce.accessToken = props.oAuth.accessToken;
        const refreshTokenGrant = this.getRefreshTokenGrantFlowProperty(props.oAuth.flow);
        salesforce.refreshToken = refreshTokenGrant?.refreshToken ?? 'dummyRefreshToken';
        if (refreshTokenGrant?.client) {
            salesforce.clientCredentialsArn = refreshTokenGrant.client.secretArn;
            // TODO: make sure why this doesn't work.
            //       this doc says it should: https://docs.aws.amazon.com/appflow/latest/userguide/salesforce.html
            //       in order to obtain the access token I needed to follow: https://medium.com/@bpmmendis94/obtain-access-refresh-tokens-from-salesforce-rest-api-a324fe4ccd9b
            salesforce.accessToken = salesforce.accessToken ?? 'dummyAccessToken';
        }
        return {
            salesforce: salesforce,
        };
    }
}
exports.SalesforceConnectorProfile = SalesforceConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceConnectorProfile", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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