import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { ISecret } from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface SalesforceConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: SalesforceOAuthSettings;
    readonly instanceUrl: string;
    /**
     * @default false
     */
    readonly isSandbox?: boolean;
}
export interface SalesforceOAuthRefreshTokenGrantFlow {
    readonly refreshToken?: string;
    readonly client?: ISecret;
}
export interface SalesforceOAuthFlow {
    /**
     * The parameters required for the refresh token grant OAuth flow
     *
     * @deprecated - this property will be removed in the future releases. Use refreshTokenGrant property instead.
     */
    readonly refresTokenGrant?: SalesforceOAuthRefreshTokenGrantFlow;
    /**
     * The parameters required for the refresh token grant OAuth flow
     */
    readonly refreshTokenGrant?: SalesforceOAuthRefreshTokenGrantFlow;
}
export interface SalesforceOAuthSettings {
    readonly accessToken?: string;
    readonly flow?: SalesforceOAuthFlow;
}
export declare class SalesforceConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): SalesforceConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): SalesforceConnectorProfile;
    constructor(scope: Construct, id: string, props: SalesforceConnectorProfileProps);
    protected buildConnectorProfileProperties(properties: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    /**
     * This is a auxiliary method for obtaining a refreshTokeNGrandFlow. It's a temporary solution due to the typo in the properties
     * as we don't want to abruptly fail customer solutions depending on the library.
     * @param flow a SalesforceOAuthFlow object
     * @returns a SalesforceOAuthRefreshTokenGrantFlow object or undefined if the flow is undefined.
     * @throws an error if both refreshTokenGrant and refresTokenGrant are specified. This is a temporary solution due to the typo in the properties.
     * @deprecated - this method will be removed in the future releases.
     */
    private getRefreshTokenGrantFlowProperty;
    protected buildConnectorProfileCredentials(properties: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
