"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceDestination = exports.SalesforceDataTransferApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
/**
 * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
 *
 * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
 *
 * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
 */
var SalesforceDataTransferApi;
(function (SalesforceDataTransferApi) {
    SalesforceDataTransferApi["AUTOMATIC"] = "AUTOMATIC";
    SalesforceDataTransferApi["BULKV2"] = "BULKV2";
    SalesforceDataTransferApi["REST_SYNC"] = "REST_SYNC";
})(SalesforceDataTransferApi = exports.SalesforceDataTransferApi || (exports.SalesforceDataTransferApi = {}));
class SalesforceDestination {
    constructor(props) {
        this.props = props;
        this.connectorType = type_1.SalesforceConnectorType.instance;
    }
    bind(flow) {
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        this.tryAddNodeDependency(flow, this.props.profile);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            connectorProfileName: this.props.profile.name,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            salesforce: {
                dataTransferApi: this.props.dataTransferApi,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling.failOnFirstError,
                },
                idFieldNames: this.props.operation.ids,
                object: this.props.object,
                writeOperationType: this.props.operation.type,
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.SalesforceDestination = SalesforceDestination;
_a = JSII_RTTI_SYMBOL_1;
SalesforceDestination[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceDestination", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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