import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { SalesforceMarketingCloudConnectorProfile } from './profile';
import { ConnectorType } from '../core/connectors/connector-type';
import { IFlow } from '../core/flows';
import { ISource } from '../core/vertices';
/**
 * Properties of a Salesforce Marketing Cloud Source
 */
export interface SalesforceMarketingCloudSourceProps {
    readonly profile: SalesforceMarketingCloudConnectorProfile;
    readonly apiVersion: string;
    readonly object: string;
}
/**
 * A class that represents a Salesforce Marketing Cloud Source
 */
export declare class SalesforceMarketingCloudSource implements ISource {
    private readonly props;
    /**
     * The AppFlow type of the connector that this source is implemented for
     */
    readonly connectorType: ConnectorType;
    constructor(props: SalesforceMarketingCloudSourceProps);
    bind(scope: IFlow): CfnFlow.SourceFlowConfigProperty;
    private buildSourceConnectorProperties;
    private tryAddNodeDependency;
}
