"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SalesforceMarketingCloudConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class SalesforceMarketingCloudConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.SalesforceMarketingCloudConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.CLIENT_CREDENTIALS,
                    tokenUrl: properties.oAuth.endpoints.token,
                },
                profileProperties: {
                    instanceUrl: properties.instanceUrl,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    accessToken: properties.oAuth.accessToken,
                    clientId: properties.oAuth.flow?.clientCredentials.clientId,
                    clientSecret: properties.oAuth.flow?.clientCredentials.clientSecret,
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.SalesforceMarketingCloudConnectorProfile = SalesforceMarketingCloudConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
SalesforceMarketingCloudConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.SalesforceMarketingCloudConnectorProfile", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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