"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicrosoftSharepointOnlineConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class MicrosoftSharepointOnlineConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MicrosoftSharepointOnlineConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken,
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId,
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret,
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.MicrosoftSharepointOnlineConnectorProfile = MicrosoftSharepointOnlineConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MicrosoftSharepointOnlineConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MicrosoftSharepointOnlineConnectorProfile", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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