import { CfnConnectorProfile } from 'aws-cdk-lib/aws-appflow';
import { Construct } from 'constructs';
import { ConnectorProfileBase, ConnectorProfileProps } from '../core/connectors/connector-profile';
export interface MicrosoftSharepointOnlineConnectorProfileProps extends ConnectorProfileProps {
    readonly oAuth: MicrosoftSharepointOnlineOAuthSettings;
}
export interface MicrosoftSharepointOnlineOAuthEndpointsSettings {
    readonly token: string;
}
export interface MicrosoftSharepointOnlineRefreshTokenGrantFlow {
    readonly refreshToken?: string;
    readonly clientSecret?: string;
    readonly clientId?: string;
}
export interface MicrosoftSharepointOnlineOAuthFlow {
    readonly refreshTokenGrant: MicrosoftSharepointOnlineRefreshTokenGrantFlow;
}
export interface MicrosoftSharepointOnlineOAuthSettings {
    /**
     * The access token to be used when interacting with Google Analytics 4
     *
     * Note that if only the access token is provided AppFlow is not able to retrieve a fresh access token when the current one is expired
     */
    readonly accessToken?: string;
    readonly flow?: MicrosoftSharepointOnlineOAuthFlow;
    readonly endpoints: MicrosoftSharepointOnlineOAuthEndpointsSettings;
}
export declare class MicrosoftSharepointOnlineConnectorProfile extends ConnectorProfileBase {
    static fromConnectionProfileArn(scope: Construct, id: string, arn: string): MicrosoftSharepointOnlineConnectorProfile;
    static fromConnectionProfileName(scope: Construct, id: string, name: string): MicrosoftSharepointOnlineConnectorProfile;
    constructor(scope: Construct, id: string, props: MicrosoftSharepointOnlineConnectorProfileProps);
    protected buildConnectorProfileProperties(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfilePropertiesProperty;
    protected buildConnectorProfileCredentials(props: ConnectorProfileProps): CfnConnectorProfile.ConnectorProfileCredentialsProperty;
}
