"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarketoConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_profile_1 = require("../core/connectors/connector-profile");
class MarketoConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.MarketoConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            marketo: {
                instanceUrl: properties.instanceUrl,
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            marketo: {
                accessToken: properties.oAuth.accessToken,
                clientId: properties.oAuth.flow.clientCredentials.clientId,
                clientSecret: properties.oAuth.flow.clientCredentials.clientSecret,
            },
        };
    }
}
exports.MarketoConnectorProfile = MarketoConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
MarketoConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.MarketoConnectorProfile", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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