"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleAnalytics4ConnectorProfile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const connector_authentication_type_1 = require("../core/connectors/connector-authentication-type");
const connector_profile_1 = require("../core/connectors/connector-profile");
const oauth2_granttype_1 = require("../core/connectors/oauth2-granttype");
class GoogleAnalytics4ConnectorProfile extends connector_profile_1.ConnectorProfileBase {
    constructor(scope, id, props) {
        super(scope, id, props, type_1.GoogleAnalytics4ConnectorType.instance);
    }
    static fromConnectionProfileArn(scope, id, arn) {
        return this._fromConnectorProfileAttributes(scope, id, { arn });
    }
    static fromConnectionProfileName(scope, id, name) {
        return this._fromConnectorProfileAttributes(scope, id, { name });
    }
    buildConnectorProfileProperties(props) {
        const properties = props;
        return {
            customConnector: {
                oAuth2Properties: {
                    // INFO: even if we're using a refresh token grant flow this property is required
                    oAuth2GrantType: oauth2_granttype_1.OAuth2GrantType.AUTHORIZATION_CODE,
                    // INFO: even if we provide only the access token this property is required
                    // TODO: think about if this is correct. token can be IResolvable
                    tokenUrl: properties.oAuth.endpoints?.token ?? GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint,
                },
            },
        };
    }
    buildConnectorProfileCredentials(props) {
        const properties = props;
        return {
            customConnector: {
                oauth2: {
                    // INFO: when using Refresh Token Grant Flow - access token property is required
                    accessToken: properties.oAuth.accessToken ?? 'dummyAccessToken',
                    refreshToken: properties.oAuth.flow?.refreshTokenGrant.refreshToken,
                    clientId: properties.oAuth.flow?.refreshTokenGrant.clientId,
                    clientSecret: properties.oAuth.flow?.refreshTokenGrant.clientSecret,
                },
                authenticationType: connector_authentication_type_1.ConnectorAuthenticationType.OAUTH2,
            },
        };
    }
}
exports.GoogleAnalytics4ConnectorProfile = GoogleAnalytics4ConnectorProfile;
_a = JSII_RTTI_SYMBOL_1;
GoogleAnalytics4ConnectorProfile[_a] = { fqn: "@cdklabs/cdk-appflow.GoogleAnalytics4ConnectorProfile", version: "0.0.12" };
GoogleAnalytics4ConnectorProfile.defaultTokenEndpoint = 'https://oauth2.googleapis.com/token';
//# sourceMappingURL=data:application/json;base64,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