"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const type_1 = require("./type");
const appflow_permissions_manager_1 = require("../core/appflow-permissions-manager");
const flows_1 = require("../core/flows");
/**
 * This class represents AppFlow's EventBridge destination
 */
class EventBridgeDestination {
    constructor(props) {
        this.props = props;
        this.compatibleFlows = [flows_1.FlowType.EVENT];
        this.connectorType = type_1.EventBridgeConnectorType.instance;
    }
    bind(flow) {
        if (!this.compatibleFlows.includes(flow.type)) {
            throw new Error(`Flow of type ${flow.type} does not support EventBridge as a destination`);
        }
        this.tryAddNodeDependency(flow, this.props.errorHandling?.errorLocation?.bucket);
        appflow_permissions_manager_1.AppFlowPermissionsManager.instance().grantBucketWrite(this.props.errorHandling?.errorLocation?.bucket);
        return {
            connectorType: this.connectorType.asProfileConnectorType,
            destinationConnectorProperties: this.buildDestinationConnectorProperties(),
        };
    }
    buildDestinationConnectorProperties() {
        return {
            eventBridge: {
                object: this.props.partnerBus,
                errorHandlingConfig: this.props.errorHandling && {
                    bucketName: this.props.errorHandling?.errorLocation?.bucket?.bucketName,
                    bucketPrefix: this.props.errorHandling?.errorLocation?.prefix,
                    failOnFirstError: this.props.errorHandling?.failOnFirstError,
                },
            },
        };
    }
    tryAddNodeDependency(scope, resource) {
        if (resource && typeof resource !== 'string') {
            scope.node.addDependency(resource);
        }
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "@cdklabs/cdk-appflow.EventBridgeDestination", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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