"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const operation_1 = require("./operation");
const tasks_1 = require("./tasks");
const OP_NOOP = 'NO_OP';
/**
 * A representation of a transform operation, that is an operation modifying source fields
 */
class Transform extends operation_1.OperationBase {
    /**
     * Truncates the field to a specified length
     * @param field a source field to truncate
     * @param length the maximum length after truncation
     * @returns a @see Transform instance
     */
    static truncate(field, length) {
        if (!Number.isInteger(length)) {
            throw new Error('length has to be an integer value');
        }
        if (length <= 0) {
            throw new Error('length has to be a positive integer value');
        }
        return new Transform([
            new tasks_1.Task('Truncate', [typeof field === 'string' ? field : field.name], { operation: OP_NOOP }, { TRUNCATE_LENGTH: `${length}` }),
        ]);
    }
    /**
     * Masks the field with a specified mask
     * @param field a source field to mask
     * @param mask a mask character. @default '*'
     * @returns a @see Transform instance
     */
    static mask(field, mask = '*') {
        if (mask && mask.length !== 1) {
            throw new Error('The mask has to be a single character');
        }
        return new Transform([
            new tasks_1.Task('Mask', [typeof field === 'string' ? field : field.name], { operation: 'MASK_ALL' }, {
                // TODO: test this. The AWS Console generated transform has length, but what for?
                MASK_LENGTH: '5',
                MASK_VALUE: mask ?? '*',
            }),
        ]);
    }
    static maskStart(field, length, mask) {
        if (!Number.isInteger(length)) {
            throw new Error('length has to be an integer value');
        }
        if (length <= 0) {
            throw new Error('length has to be a positive integer value');
        }
        if (mask && mask.length !== 1) {
            throw new Error('The mask has to be a single character');
        }
        return new Transform([
            new tasks_1.Task('Mask', [typeof field === 'string' ? field : field.name], { operation: 'MASK_FIRST_N' }, {
                MASK_LENGTH: `${length}`,
                MASK_VALUE: mask ?? '*',
            }),
        ]);
    }
    static maskEnd(field, length, mask) {
        if (!Number.isInteger(length)) {
            throw new Error('length has to be an integer value');
        }
        if (length <= 0) {
            throw new Error('length has to be a positive integer value');
        }
        if (mask && mask.length !== 1) {
            throw new Error('The mask has to be a single character');
        }
        return new Transform([
            new tasks_1.Task('Mask', [typeof field === 'string' ? field : field.name], { operation: 'MASK_LAST_N' }, {
                MASK_LENGTH: `${length}`,
                MASK_VALUE: mask ?? '*',
            }),
        ]);
    }
}
exports.Transform = Transform;
_a = JSII_RTTI_SYMBOL_1;
Transform[_a] = { fqn: "@cdklabs/cdk-appflow.Transform", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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