import { CfnFlow } from 'aws-cdk-lib/aws-appflow';
import { ConnectorType } from '../connectors/connector-type';
import { IFlow } from '../flows';
import { ISource } from '../vertices/source';
/**
 * A representation of a unitary action on the record fields
 */
export interface ITask {
    bind(flow: IFlow, source: ISource): CfnFlow.TaskProperty;
}
/**
 * A generic bucket for the task properties
 */
export interface TaskProperties {
    [key: string]: string;
}
/**
 * A pair that represents the (typically source) connector, and a task operation to be performed in the context of the connector
 */
export interface TaskConnectorOperator {
    readonly type?: ConnectorType;
    readonly operation: string;
}
/**
 * A representation of a unitary action on the record fields
 */
export declare class Task implements ITask {
    protected type: string;
    protected sourceFields: string[];
    protected connectorOperator: TaskConnectorOperator;
    protected properties: TaskProperties;
    protected destinationField?: string | undefined;
    constructor(type: string, sourceFields: string[], connectorOperator: TaskConnectorOperator, properties: TaskProperties, destinationField?: string | undefined);
    bind(_flow: IFlow, source: ISource): CfnFlow.TaskProperty;
    private buildOperatorFor;
}
